/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.List;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.tree.Yaml;

public final class MergeYaml
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression used to find matching keys.", example="$.metadata")
    private final String key;
    @Option(displayName="YAML snippet", description="The YAML snippet to insert. The snippet will be indented to match the style of its surroundings.", example="labels: \n\tlabel-one: \"value-one\"")
    @Language(value="yml")
    private final String yaml;
    @Option(displayName="Accept theirs", description="When the YAML snippet to insert conflicts with an existing key value pair and an existing key has a different value, prefer the original value.", required=false)
    @Nullable
    private final Boolean acceptTheirs;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.yml")
    @Nullable
    @Incubating(since="7.11.0")
    private final String fileMatcher;

    public Validated validate() {
        return super.validate().and(Validated.test((String)"yaml", (String)"Must be valid YAML", (Object)this.yaml, y -> {
            List<Yaml.Documents> parsed = new YamlParser().parse(this.yaml);
            if (parsed.isEmpty()) {
                return false;
            }
            return !parsed.get(0).getDocuments().isEmpty();
        }));
    }

    public String getDisplayName() {
        return "Merge YAML snippet";
    }

    public String getDescription() {
        return "Merge a YAML snippet with an existing YAML document.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new HasSourcePath(this.fileMatcher);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.key);
        final Yaml.Block incoming = new YamlParser().parse(this.yaml).get(0).getDocuments().get(0).getBlock();
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                if ("$".equals(MergeYaml.this.key)) {
                    return document.withBlock((Yaml.Block)new MergeYamlVisitor((Yaml)document.getBlock(), MergeYaml.this.yaml, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs)).visit(document.getBlock(), ctx, this.getCursor()));
                }
                return super.visitDocument(document, ctx);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                if (matcher.matches(this.getCursor())) {
                    m = (Yaml.Mapping)new MergeYamlVisitor((Yaml)mapping, incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs)).visitNonNull(mapping, ctx, this.getCursor().getParentOrThrow());
                }
                return m;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                if (matcher.matches(this.getCursor()) && !(entry.getValue() instanceof Yaml.Sequence)) {
                    return entry.withValue((Yaml.Block)new MergeYamlVisitor((Yaml)entry.getValue(), incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs)).visit(entry.getValue(), ctx, this.getCursor()));
                }
                return super.visitMappingEntry(entry, ctx);
            }

            @Override
            public Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext ctx) {
                if (matcher.matches(this.getCursor().getParentOrThrow())) {
                    return sequence.withEntries(ListUtils.map(sequence.getEntries(), entry -> entry.withBlock((Yaml.Block)new MergeYamlVisitor((Yaml)entry.getBlock(), incoming, Boolean.TRUE.equals(MergeYaml.this.acceptTheirs)).visit(entry.getBlock(), ctx, new Cursor(this.getCursor(), entry)))));
                }
                return super.visitSequence(sequence, ctx);
            }
        };
    }

    public MergeYaml(String key, @Language(value="yml") String yaml, @Nullable Boolean acceptTheirs, @Nullable String fileMatcher) {
        this.key = key;
        this.yaml = yaml;
        this.acceptTheirs = acceptTheirs;
        this.fileMatcher = fileMatcher;
    }

    public String getKey() {
        return this.key;
    }

    @Language(value="yml")
    public String getYaml() {
        return this.yaml;
    }

    @Nullable
    public Boolean getAcceptTheirs() {
        return this.acceptTheirs;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "MergeYaml(key=" + this.getKey() + ", yaml=" + this.getYaml() + ", acceptTheirs=" + this.getAcceptTheirs() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeYaml)) {
            return false;
        }
        MergeYaml other = (MergeYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$acceptTheirs = this.getAcceptTheirs();
        Boolean other$acceptTheirs = other.getAcceptTheirs();
        if (this$acceptTheirs == null ? other$acceptTheirs != null : !((Object)this$acceptTheirs).equals(other$acceptTheirs)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$yaml = this.getYaml();
        String other$yaml = other.getYaml();
        if (this$yaml == null ? other$yaml != null : !this$yaml.equals(other$yaml)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MergeYaml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $acceptTheirs = this.getAcceptTheirs();
        result = result * 59 + ($acceptTheirs == null ? 43 : ((Object)$acceptTheirs).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $yaml = this.getYaml();
        result = result * 59 + ($yaml == null ? 43 : $yaml.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

