/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.search;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;
import org.openrewrite.yaml.XPathMatcher;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class FindKey
extends Recipe {
    @Option(displayName="Key path", description="XPath expression used to find matching keys.", example="/subjects/kind")
    private final String key;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Find YAML entries";
    }

    public String getDescription() {
        return "Find YAML entries by XPath expression.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher xPathMatcher = new XPathMatcher(this.key);
        return new YamlVisitor<ExecutionContext>(){

            @Override
            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)super.visitMappingEntry(entry, ctx);
                if (xPathMatcher.matches(this.getCursor())) {
                    e = e.withMarkers(e.getMarkers().addOrUpdate((Marker)new RecipeSearchResult(FindKey.this.id, (Recipe)FindKey.this)));
                }
                return e;
            }
        };
    }

    public static Set<Yaml.Mapping.Entry> find(Yaml y, String xPath) {
        final XPathMatcher xPathMatcher = new XPathMatcher(xPath);
        YamlVisitor<Set<Yaml.Mapping.Entry>> findVisitor = new YamlVisitor<Set<Yaml.Mapping.Entry>>(){

            @Override
            public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, Set<Yaml.Mapping.Entry> es) {
                Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)super.visitMappingEntry(entry, es);
                if (xPathMatcher.matches(this.getCursor())) {
                    es.add(e);
                }
                return e;
            }
        };
        HashSet<Yaml.Mapping.Entry> es = new HashSet<Yaml.Mapping.Entry>();
        findVisitor.visit(y, es);
        return es;
    }

    public FindKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindKey(key=" + this.getKey() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKey)) {
            return false;
        }
        FindKey other = (FindKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

