/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindIndentYamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class CoalescePropertiesVisitor<P>
extends YamlIsoVisitor<P> {
    private final FindIndentYamlVisitor<P> findIndent = new FindIndentYamlVisitor(0);

    @Override
    public Yaml.Document visitDocument(Yaml.Document document, P p) {
        this.findIndent.visit(document, p);
        return super.visitDocument(document, (Object)p);
    }

    @Override
    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
        Yaml m = super.visitMapping(mapping, (Object)p);
        boolean changed = false;
        ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
        for (Yaml.Mapping.Entry entry : ((Yaml.Mapping)m).getEntries()) {
            if (entry.getValue() instanceof Yaml.Mapping) {
                Yaml.Mapping valueMapping = (Yaml.Mapping)entry.getValue();
                if (valueMapping.getEntries().size() == 1) {
                    Yaml.Mapping.Entry subEntry = valueMapping.getEntries().iterator().next();
                    Yaml.Scalar coalescedKey = entry.getKey().withValue(entry.getKey().getValue() + "." + subEntry.getKey().getValue());
                    entries.add(entry.withKey(coalescedKey).withValue(subEntry.getValue()));
                    int indentToUse = this.findIndent.getMostCommonIndent() > 0 ? this.findIndent.getMostCommonIndent() : 4;
                    this.doAfterVisit(new ShiftFormatLeftVisitor(subEntry.getValue(), indentToUse));
                    changed = true;
                    continue;
                }
                entries.add(entry);
                continue;
            }
            entries.add(entry);
        }
        if (changed) {
            m = ((Yaml.Mapping)m).withEntries(entries);
        }
        return m;
    }
}

