/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.XPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="An XPath expression to locate a YAML entry.", example="subjects/kind")
    private final String oldKeyPath;
    @Option(displayName="New value", example="Deployment")
    private final String value;

    public String getDisplayName() {
        return "Change value";
    }

    public String getDescription() {
        return "Change a YAML mapping entry value leaving the key intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher xPathMatcher = new XPathMatcher(this.oldKeyPath);
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext context) {
                Yaml e = super.visitMappingEntry(entry, context);
                if (xPathMatcher.matches(this.getCursor())) {
                    e = ((Yaml.Mapping.Entry)e).withValue(new Yaml.Scalar(Tree.randomId(), ((Yaml.Mapping.Entry)e).getValue().getPrefix(), Markers.EMPTY, Yaml.Scalar.Style.PLAIN, ChangeValue.this.value));
                }
                return e;
            }
        };
    }

    public ChangeValue(String oldKeyPath, String value) {
        this.oldKeyPath = oldKeyPath;
        this.value = value;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "ChangeValue(oldKeyPath=" + this.getOldKeyPath() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

