/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.internal;

import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class YamlPrinter<P>
extends YamlVisitor<PrintOutputCapture<P>> {
    @Override
    public Yaml visitDocument(Yaml.Document document, PrintOutputCapture<P> p) {
        p.out.append(document.getPrefix());
        this.visitMarkers(document.getMarkers(), p);
        if (document.isExplicit()) {
            p.out.append("---");
        }
        this.visit(document.getBlock(), p);
        p.out.append(document.getEnd().getPrefix());
        if (document.getEnd().isExplicit()) {
            p.out.append("...");
        }
        return document;
    }

    @Override
    public Yaml visitDocuments(Yaml.Documents documents, PrintOutputCapture<P> p) {
        this.visitMarkers(documents.getMarkers(), p);
        this.visit(documents.getDocuments(), p);
        return documents;
    }

    @Override
    public Yaml visitSequenceEntry(Yaml.Sequence.Entry entry, PrintOutputCapture<P> p) {
        p.out.append(entry.getPrefix());
        if (entry.isDash()) {
            p.out.append('-');
        }
        this.visit(entry.getBlock(), p);
        if (entry.getTrailingCommaPrefix() != null) {
            p.out.append(entry.getTrailingCommaPrefix()).append(',');
        }
        return entry;
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence sequence, PrintOutputCapture<P> p) {
        this.visitMarkers(sequence.getMarkers(), p);
        if (sequence.getOpeningBracketPrefix() != null) {
            p.out.append(sequence.getOpeningBracketPrefix()).append('[');
        }
        Yaml result = super.visitSequence(sequence, p);
        if (sequence.getClosingBracketPrefix() != null) {
            p.out.append(sequence.getClosingBracketPrefix()).append(']');
        }
        return result;
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry, PrintOutputCapture<P> p) {
        p.out.append(entry.getPrefix());
        this.visitMarkers(entry.getMarkers(), p);
        this.visit(entry.getKey(), p);
        p.out.append(entry.getBeforeMappingValueIndicator()).append(':');
        this.visit(entry.getValue(), p);
        return entry;
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping mapping, PrintOutputCapture<P> p) {
        this.visitMarkers(mapping.getMarkers(), p);
        return super.visitMapping(mapping, p);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar scalar, PrintOutputCapture<P> p) {
        p.out.append(scalar.getPrefix());
        this.visitMarkers(scalar.getMarkers(), p);
        if (scalar.getAnchor() != null) {
            this.visit(scalar.getAnchor(), p);
        }
        switch (scalar.getStyle()) {
            case DOUBLE_QUOTED: {
                p.out.append('\"').append(scalar.getValue().replaceAll("\\n", "\\\\n")).append('\"');
                break;
            }
            case SINGLE_QUOTED: {
                p.out.append('\'').append(scalar.getValue().replaceAll("\\n", "\\\\n")).append('\'');
                break;
            }
            case LITERAL: {
                p.out.append('|').append(scalar.getValue());
                break;
            }
            case FOLDED: {
                p.out.append('>').append(scalar.getValue());
                break;
            }
            default: {
                p.out.append(scalar.getValue());
            }
        }
        return scalar;
    }

    @Override
    public Yaml visitAnchor(Yaml.Anchor anchor, PrintOutputCapture<P> p) {
        this.visitMarkers(anchor.getMarkers(), p);
        p.out.append("&");
        p.out.append(anchor.getKey());
        p.out.append(anchor.getPostfix());
        return anchor;
    }

    @Override
    public Yaml visitAlias(Yaml.Alias alias, PrintOutputCapture<P> p) {
        p.out.append(alias.getPrefix());
        this.visitMarkers(alias.getMarkers(), p);
        p.out.append("*");
        p.out.append(alias.getAnchor().getKey());
        return alias;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("~~").append(description == null ? "" : "(" + description + ")~~").append(">");
        }
        return (M)marker;
    }
}

