/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.internal.grammar.JsonPath;
import org.openrewrite.yaml.internal.grammar.JsonPathBaseVisitor;
import org.openrewrite.yaml.internal.grammar.JsonPathLexer;
import org.openrewrite.yaml.tree.Yaml;

public class JsonPathMatcher {
    private final String jsonPath;

    public JsonPathMatcher(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public <T> Optional<T> find(Cursor cursor) {
        LinkedList cursorPath = cursor.getPathAsStream().filter(o -> o instanceof Tree).map(Tree.class::cast).collect(Collectors.toCollection(LinkedList::new));
        if (cursorPath.isEmpty()) {
            return Optional.empty();
        }
        Collections.reverse(cursorPath);
        Tree start = this.jsonPath.startsWith(".") && !this.jsonPath.startsWith("..") ? (Tree)cursor.getValue() : (Tree)cursorPath.peekFirst();
        JsonPathYamlVisitor v = new JsonPathYamlVisitor(cursorPath, start);
        JsonPath.JsonpathContext ctx = this.jsonPath().jsonpath();
        Object result = v.visit((ParseTree)ctx);
        return Optional.ofNullable(result);
    }

    public boolean matches(Cursor cursor) {
        List cursorPath = cursor.getPathAsStream().collect(Collectors.toList());
        return this.find(cursor).map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return !Collections.disjoint(l, cursorPath) && l.contains(cursor.getValue());
            }
            return Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    public boolean encloses(Cursor cursor) {
        List cursorPath = cursor.getPathAsStream().collect(Collectors.toList());
        return this.find(cursor).map(o -> {
            if (o instanceof List) {
                return ((List)o).stream().anyMatch(cursorPath::contains);
            }
            return cursorPath.contains(o) && !Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    private JsonPath jsonPath() {
        return new JsonPath((TokenStream)new CommonTokenStream((TokenSource)new JsonPathLexer((CharStream)CharStreams.fromString((String)this.jsonPath))));
    }

    private static class JsonPathYamlVisitor
    extends JsonPathBaseVisitor<Object> {
        private final List<Tree> cursorPath;
        protected Object context;

        public JsonPathYamlVisitor(List<Tree> cursorPath, Object context) {
            this.cursorPath = cursorPath;
            this.context = context;
        }

        protected Object defaultResult() {
            return this.context;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            this.context = nextResult;
            return this.context;
        }

        @Override
        public Object visitJsonpath(JsonPath.JsonpathContext ctx) {
            if (ctx.ROOT() != null) {
                this.context = this.cursorPath.stream().filter(t -> t instanceof Yaml.Mapping).findFirst().orElseGet(() -> this.cursorPath.stream().filter(t -> t instanceof Yaml.Document && ((Yaml.Document)t).getBlock() instanceof Yaml.Mapping).map(t -> ((Yaml.Document)t).getBlock()).findFirst().orElse(null));
            }
            return super.visitJsonpath(ctx);
        }

        @Override
        public Object visitRecursiveDescent(JsonPath.RecursiveDescentContext ctx) {
            if (this.context == null) {
                return null;
            }
            Object result = null;
            for (Tree path : this.cursorPath) {
                JsonPathYamlVisitor v = new JsonPathYamlVisitor(this.cursorPath, path);
                int len = ctx.getParent().getChildCount();
                for (int i = 1; i < len && (result = v.visit(ctx.getParent().getChild(i))) != null; ++i) {
                }
                if (result == null) continue;
                return path;
            }
            return result;
        }

        @Override
        public Object visitWildcardExpression(JsonPath.WildcardExpressionContext ctx) {
            if (this.context instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)this.context;
                if (e.getValue() instanceof Yaml.Scalar) {
                    return e;
                }
                this.context = e.getValue();
                return this.visitWildcardExpression(ctx);
            }
            if (this.context instanceof List) {
                return this.context;
            }
            if (this.context instanceof Yaml.Mapping) {
                Yaml.Mapping m = (Yaml.Mapping)this.context;
                return m.getEntries();
            }
            if (this.context instanceof Yaml.Sequence) {
                Yaml.Sequence s = (Yaml.Sequence)this.context;
                return s.getEntries().stream().map(Yaml.Sequence.Entry::getBlock).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public Object visitRangeOp(JsonPath.RangeOpContext ctx) {
            List<Object> results;
            if (this.context == null) {
                return null;
            }
            if (this.context instanceof List) {
                results = (ArrayList)this.context;
            } else {
                if (this.context instanceof Yaml.Mapping) {
                    return this.context;
                }
                if (this.context instanceof Yaml.Sequence) {
                    Yaml.Sequence s = (Yaml.Sequence)this.context;
                    results = s.getEntries().stream().map(Yaml.Sequence.Entry::getBlock).collect(Collectors.toList());
                } else {
                    if (this.context instanceof Yaml.Mapping.Entry) {
                        this.context = ((Yaml.Mapping.Entry)this.context).getValue();
                        return this.visitRangeOp(ctx);
                    }
                    results = new ArrayList();
                }
            }
            int start = ctx.start() != null ? Integer.parseInt(ctx.start().getText()) : 0;
            int end = ctx.end() != null ? Integer.parseInt(ctx.end().getText()) : Integer.MAX_VALUE;
            int entryCount = results.size();
            int limit = 0;
            if (end > 0) {
                limit = end - start;
            } else if (end < 0) {
                limit = entryCount + end;
            }
            return results.stream().skip(start).limit(limit).collect(Collectors.toList());
        }

        @Override
        public Object visitAndExpression(JsonPath.AndExpressionContext ctx) {
            Object left = this.visit((ParseTree)ctx.expression(0));
            Object right = this.visit((ParseTree)ctx.expression(1));
            if (left instanceof List) {
                List l = (List)left;
                l.retainAll((List)right);
                return l;
            }
            return Objects.equals(left, right);
        }

        @Override
        public Object visitBinaryExpression(JsonPath.BinaryExpressionContext ctx) {
            BiPredicate<Object, Object> predicate = (lh, rh) -> {
                if (ctx.EQ() != null) {
                    return Objects.equals(lh, rh);
                }
                if (ctx.MATCHES() != null && lh != null && rh != null) {
                    String lhStr = lh.toString();
                    if (rh instanceof String) {
                        return Pattern.compile(rh.toString()).matcher(lhStr).matches();
                    }
                }
                return false;
            };
            if (this.context instanceof Yaml.Mapping.Entry) {
                this.context = ((Yaml.Mapping.Entry)this.context).getValue();
                return this.visitBinaryExpression(ctx);
            }
            if (this.context instanceof Yaml.Mapping) {
                return this.context;
            }
            if (this.context instanceof Yaml.Sequence) {
                Yaml.Sequence s = (Yaml.Sequence)this.context;
                JsonPath.ExpressionContext leftHandExpr = ctx.expression(0);
                Object rightHand = ctx.expression(1) instanceof JsonPath.LiteralExpressionContext ? JsonPathYamlVisitor.unquoteExpression((JsonPath.LiteralExpressionContext)ctx.expression(1)) : this.visit((ParseTree)ctx.expression(1));
                ArrayList<Yaml.Block> results = new ArrayList<Yaml.Block>();
                for (Yaml.Sequence.Entry e : s.getEntries()) {
                    this.context = e.getBlock();
                    Object leftHand = JsonPathYamlVisitor.getValue(this.visit((ParseTree)leftHandExpr));
                    if (!predicate.test(leftHand, rightHand)) continue;
                    results.add(e.getBlock());
                }
                if (!results.isEmpty()) {
                    return results;
                }
            }
            return null;
        }

        @Override
        public Object visitBracketOperator(JsonPath.BracketOperatorContext ctx) {
            if (ctx.expression() instanceof JsonPath.LiteralExpressionContext) {
                if (this.context instanceof Yaml.Mapping.Entry) {
                    this.context = ((Yaml.Mapping.Entry)this.context).getValue();
                    return this.visitBracketOperator(ctx);
                }
                if (this.context instanceof Yaml.Mapping) {
                    Yaml.Mapping m = (Yaml.Mapping)this.context;
                    JsonPath.LiteralExpressionContext litExpr = (JsonPath.LiteralExpressionContext)ctx.expression();
                    String key = JsonPathYamlVisitor.unquoteExpression(litExpr);
                    return m.getEntries().stream().filter(e -> e.getKey().getValue().equals(key)).findFirst().orElse(null);
                }
            }
            return super.visitBracketOperator(ctx);
        }

        @Override
        @Nullable
        public Object visitIdentifier(JsonPath.IdentifierContext ctx) {
            if (this.context instanceof Yaml.Mapping.Entry) {
                Yaml.Mapping.Entry e2 = (Yaml.Mapping.Entry)this.context;
                if (e2.getValue() instanceof Yaml.Scalar) {
                    return e2.getKey().getValue().equals(ctx.Identifier().getText()) ? e2 : null;
                }
                this.context = e2.getValue();
                return this.visitIdentifier(ctx);
            }
            if (this.context instanceof List) {
                List l = (List)this.context;
                return l.stream().map(o -> {
                    this.context = o;
                    return this.visitIdentifier(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (this.context instanceof Yaml.Mapping) {
                Yaml.Mapping m = (Yaml.Mapping)this.context;
                return m.getEntries().stream().filter(e -> e.getKey().getValue().equals(ctx.Identifier().getText())).findFirst().orElse(null);
            }
            if (this.context instanceof Yaml.Sequence) {
                Yaml.Sequence s = (Yaml.Sequence)this.context;
                return s.getEntries().stream().map(e -> {
                    this.context = e;
                    return this.visitIdentifier(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return null;
        }

        private static String unquoteExpression(JsonPath.LiteralExpressionContext ctx) {
            String s = null;
            if (ctx.litExpression().StringLiteral() != null) {
                s = ctx.litExpression().StringLiteral().getText();
            }
            if (s != null && (s.startsWith("'") || s.startsWith("\""))) {
                return s.substring(1, s.length() - 1);
            }
            return "null".equals(s) ? null : s;
        }

        private static Object getValue(Object o) {
            Yaml.Mapping.Entry e;
            if (o instanceof Yaml.Mapping.Entry && (e = (Yaml.Mapping.Entry)o).getValue() instanceof Yaml.Scalar) {
                Yaml.Scalar s = (Yaml.Scalar)e.getValue();
                return s.getValue();
            }
            return null;
        }
    }
}

