/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.yaml.YamlRefactorVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class ChangePropertyKey
extends YamlRefactorVisitor {
    private String property;
    private String toProperty;
    private boolean coalesce = true;

    public ChangePropertyKey() {
        this.setCursoringOn();
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setToProperty(String toProperty) {
        this.toProperty = toProperty;
    }

    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    public Validated validate() {
        return Validated.required((String)"property", (Object)this.property).and(Validated.required((String)"toProperty", (Object)this.toProperty));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Yaml visitMappingEntry(Yaml.Mapping.Entry entry) {
        Yaml.Mapping.Entry e = (Yaml.Mapping.Entry)this.refactor(entry, x$0 -> super.visitMappingEntry((Yaml.Mapping.Entry)x$0));
        Deque propertyEntries = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).collect(Collectors.toCollection(ArrayDeque::new));
        String property = StreamSupport.stream(Spliterators.spliteratorUnknownSize(propertyEntries.descendingIterator(), 0), false).map(e2 -> e2.getKey().getValue()).collect(Collectors.joining("."));
        String propertyToTest = this.toProperty;
        if (property.equals(this.property)) {
            Iterator propertyEntriesLeftToRight = propertyEntries.descendingIterator();
            while (propertyEntriesLeftToRight.hasNext()) {
                Yaml.Mapping.Entry propertyEntry = (Yaml.Mapping.Entry)propertyEntriesLeftToRight.next();
                String value = propertyEntry.getKey().getValue();
                if (!propertyToTest.startsWith(value)) {
                    this.andThen((RefactorVisitor)new InsertSubproperty(propertyEntry, propertyToTest, entry.getValue()));
                    this.andThen((RefactorVisitor)new DeleteProperty(entry));
                    if (!this.coalesce) break;
                    this.maybeCoalesceProperties();
                    break;
                }
                propertyToTest = propertyToTest.substring(value.length() + 1);
            }
        }
        return e;
    }

    private static class DeleteProperty
    extends YamlRefactorVisitor {
        private final Yaml.Mapping.Entry scope;

        private DeleteProperty(Yaml.Mapping.Entry scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        @Override
        public Yaml visitMapping(Yaml.Mapping mapping) {
            Yaml.Mapping m = (Yaml.Mapping)this.refactor(mapping, x$0 -> super.visitMapping((Yaml.Mapping)x$0));
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
            for (Yaml.Mapping.Entry entry : m.getEntries()) {
                if (entry == this.scope || entry.getValue() instanceof Yaml.Mapping && ((Yaml.Mapping)entry.getValue()).getEntries().isEmpty()) {
                    changed = true;
                    continue;
                }
                entries.add(entry);
            }
            if (changed) {
                Yaml.Document document;
                m = m.withEntries(entries);
                if (this.getCursor().getParentOrThrow().getTree() instanceof Yaml.Document && !(document = (Yaml.Document)this.getCursor().getParentOrThrow().getTree()).isExplicit()) {
                    m = m.withEntries(Formatting.formatFirstPrefix(m.getEntries(), (String)""));
                }
            }
            return m;
        }
    }

    private static class InsertSubproperty
    extends YamlRefactorVisitor {
        private final Yaml.Mapping.Entry scope;
        private final String subproperty;
        private final Yaml.Block value;

        private InsertSubproperty(Yaml.Mapping.Entry scope, String subproperty, Yaml.Block value) {
            this.scope = scope;
            this.subproperty = subproperty;
            this.value = value;
        }

        @Override
        public Yaml visitMapping(Yaml.Mapping mapping) {
            Yaml.Mapping m = (Yaml.Mapping)this.refactor(mapping, x$0 -> super.visitMapping((Yaml.Mapping)x$0));
            if (m.getEntries().contains(this.scope)) {
                Formatting newEntryFormatting = this.scope.getFormatting();
                if (newEntryFormatting.getPrefix().isEmpty()) {
                    newEntryFormatting = newEntryFormatting.withPrefix("\n");
                }
                m = m.withEntries(Stream.concat(m.getEntries().stream(), Stream.of(new Yaml.Mapping.Entry(Tree.randomId(), new Yaml.Scalar(Tree.randomId(), Yaml.Scalar.Style.PLAIN, this.subproperty, Formatting.EMPTY), this.value.copyPaste(), newEntryFormatting))).collect(Collectors.toList()));
            }
            return m;
        }
    }
}

