/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.xml.internal.grammar.XPathLexer;
import org.openrewrite.xml.internal.grammar.XPathParser;

final class XPathCompiler {
    private static final Cache<String, CompiledXPath> CACHE = Caffeine.newBuilder().maximumSize(256L).build();
    static final int FLAG_ABSOLUTE_PATH = 1;
    static final int FLAG_DESCENDANT_OR_SELF = 2;
    static final int FLAG_HAS_DESCENDANT = 4;
    static final int FLAG_HAS_ABBREVIATED_STEP = 8;
    static final int FLAG_HAS_AXIS_STEP = 16;
    static final int FLAG_HAS_ATTRIBUTE_STEP = 32;
    static final int FLAG_HAS_NODE_TYPE_TEST = 64;
    static final int EXPR_PATH = 0;
    static final int EXPR_BOOLEAN = 1;
    static final int EXPR_FILTER = 2;
    private static final CompiledStep[] EMPTY_STEPS = new CompiledStep[0];
    private static final CompiledExpr[] EMPTY_PREDICATES = new CompiledExpr[0];

    private XPathCompiler() {
    }

    public static CompiledXPath compile(String expression) {
        return Objects.requireNonNull((CompiledXPath)CACHE.get((Object)expression, XPathCompiler::compileInternal));
    }

    private static CompiledXPath compileInternal(String expression) {
        XPathLexer lexer = new XPathLexer((CharStream)CharStreams.fromString((String)expression));
        XPathParser parser = new XPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return XPathCompiler.compileXPathExpression(parser.xpathExpression());
    }

    private static CompiledXPath compileXPathExpression(XPathParser.XpathExpressionContext ctx) {
        XPathParser.RelationalExprContext relExpr;
        XPathParser.EqualityExprContext eqExpr;
        XPathParser.AndExprContext andExpr;
        XPathParser.ExprContext exprCtx = ctx.expr();
        if (exprCtx == null || exprCtx.orExpr() == null) {
            return new CompiledXPath(EMPTY_STEPS, 0, 0, null, null);
        }
        XPathParser.OrExprContext orExpr = exprCtx.orExpr();
        if (orExpr.andExpr().size() == 1 && (andExpr = orExpr.andExpr(0)).equalityExpr().size() == 1 && (eqExpr = andExpr.equalityExpr(0)).relationalExpr().size() == 1 && (relExpr = eqExpr.relationalExpr(0)).unaryExpr().size() == 1) {
            XPathParser.PathExprContext pathExpr = relExpr.unaryExpr(0).unionExpr().pathExpr();
            if (pathExpr.locationPath() != null) {
                return XPathCompiler.compileLocationPath(pathExpr.locationPath());
            }
            if (pathExpr.functionCallExpr() != null || pathExpr.bracketedExpr() != null || pathExpr.literalOrNumber() != null) {
                return XPathCompiler.compileFilterExprAsXPath(pathExpr);
            }
        }
        CompiledExpr boolExpr = XPathCompiler.compileOrExpr(orExpr);
        return new CompiledXPath(EMPTY_STEPS, 0, 1, boolExpr, null);
    }

    private static CompiledXPath compileLocationPath(XPathParser.LocationPathContext locationPath) {
        XPathParser.RelativeLocationPathContext relPath = null;
        int flags = 0;
        if (locationPath.absoluteLocationPath() != null) {
            XPathParser.AbsoluteLocationPathContext absCtx = locationPath.absoluteLocationPath();
            flags = absCtx.DOUBLE_SLASH() != null ? (flags |= 2) : (flags |= 1);
            relPath = absCtx.relativeLocationPath();
        } else if (locationPath.relativeLocationPath() != null) {
            relPath = locationPath.relativeLocationPath();
        }
        CompiledStep[] compiledSteps = EMPTY_STEPS;
        if (relPath != null) {
            int i;
            List<XPathParser.StepContext> stepCtxs = relPath.step();
            List<XPathParser.PathSeparatorContext> separators = relPath.pathSeparator();
            compiledSteps = new CompiledStep[stepCtxs.size()];
            for (i = 0; i < stepCtxs.size(); ++i) {
                boolean isDescendant = false;
                if (i > 0 && i - 1 < separators.size()) {
                    isDescendant = separators.get(i - 1).DOUBLE_SLASH() != null;
                }
                compiledSteps[i] = CompiledStep.fromStepContext(stepCtxs.get(i), isDescendant);
            }
            for (i = 0; i < compiledSteps.length; ++i) {
                CompiledStep s = compiledSteps[i];
                if (s.isDescendant) {
                    flags |= 4;
                }
                switch (s.type.ordinal()) {
                    case 0: 
                    case 1: {
                        flags |= 8;
                        break;
                    }
                    case 2: {
                        flags |= 0x10;
                        break;
                    }
                    case 3: {
                        flags |= 0x20;
                        break;
                    }
                    case 4: {
                        flags |= 0x40;
                    }
                }
                if (i + 1 >= compiledSteps.length || !compiledSteps[i + 1].isBacktrack()) continue;
                s.setNextIsBacktrack();
            }
        }
        compiledSteps = XPathCompiler.normalizeParentSteps(compiledSteps);
        flags = XPathCompiler.recomputeFlags(compiledSteps, flags);
        return new CompiledXPath(compiledSteps, flags, 0, null, null);
    }

    private static CompiledXPath compileFilterExprAsXPath(XPathParser.PathExprContext pathExpr) {
        XPathParser.BracketedExprContext bracketed;
        if (pathExpr.bracketedExpr() != null && (bracketed = pathExpr.bracketedExpr()).LPAREN() != null && bracketed.expr() != null) {
            String innerPath = bracketed.expr().getText();
            CompiledExpr[] predicates = XPathCompiler.compilePredicates(bracketed.predicate());
            String trailingPath = null;
            boolean trailingIsDescendant = false;
            if (pathExpr.pathSeparator() != null && pathExpr.relativeLocationPath() != null) {
                trailingPath = pathExpr.relativeLocationPath().getText();
                trailingIsDescendant = pathExpr.pathSeparator().DOUBLE_SLASH() != null;
            }
            CompiledFilterExpr compiled = new CompiledFilterExpr(innerPath, predicates, trailingPath, trailingIsDescendant);
            return new CompiledXPath(EMPTY_STEPS, 0, 2, null, compiled);
        }
        CompiledExpr boolExpr = XPathCompiler.compilePathExpr(pathExpr);
        return new CompiledXPath(EMPTY_STEPS, 0, 1, boolExpr, null);
    }

    private static CompiledStep[] normalizeParentSteps(CompiledStep[] steps) {
        if (steps.length == 0) {
            return steps;
        }
        boolean hasNormalizableParent = false;
        for (int i = 1; i < steps.length; ++i) {
            if (!steps[i].isBacktrack() || XPathCompiler.isLeadingParentStep(steps, i)) continue;
            hasNormalizableParent = true;
            break;
        }
        if (!hasNormalizableParent) {
            return steps;
        }
        ArrayList<CompiledStep> result = new ArrayList<CompiledStep>();
        int i = 0;
        while (i < steps.length) {
            if (steps[i].isBacktrack() && !XPathCompiler.isLeadingParentStep(steps, i)) {
                int parentCount = 0;
                int parentStart = i;
                while (i < steps.length && steps[i].isBacktrack()) {
                    ++parentCount;
                    ++i;
                }
                int predicateStartIdx = parentStart - parentCount;
                if (predicateStartIdx < 0 || predicateStartIdx >= result.size()) continue;
                int stepsToConvert = Math.min(parentCount, result.size() - predicateStartIdx);
                CompiledStep[] predicateSteps = new CompiledStep[stepsToConvert];
                for (int j = 0; j < stepsToConvert; ++j) {
                    predicateSteps[j] = (CompiledStep)result.remove(predicateStartIdx);
                }
                CompiledExpr predicate = XPathCompiler.createPathPredicate(predicateSteps);
                if (predicateStartIdx <= 0 || predicateStartIdx > result.size()) continue;
                int anchorIdx = predicateStartIdx - 1;
                result.set(anchorIdx, ((CompiledStep)result.get(anchorIdx)).withAdditionalPredicate(predicate));
                continue;
            }
            result.add(steps[i]);
            ++i;
        }
        return result.toArray(new CompiledStep[0]);
    }

    private static boolean isLeadingParentStep(CompiledStep[] steps, int index) {
        for (int i = 0; i < index; ++i) {
            if (steps[i].isBacktrack()) continue;
            return false;
        }
        return true;
    }

    private static CompiledExpr createPathPredicate(CompiledStep[] steps) {
        if (steps.length == 1) {
            return CompiledExpr.child(steps[0].name);
        }
        CompiledExpr[] childExprs = new CompiledExpr[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            childExprs[i] = CompiledExpr.child(steps[i].name);
        }
        return CompiledExpr.path(childExprs, null);
    }

    private static int recomputeFlags(CompiledStep[] steps, int originalFlags) {
        int flags = originalFlags & 3;
        block6: for (CompiledStep s : steps) {
            if (s.isDescendant) {
                flags |= 4;
            }
            switch (s.type.ordinal()) {
                case 0: 
                case 1: {
                    flags |= 8;
                    continue block6;
                }
                case 2: {
                    flags |= 0x10;
                    continue block6;
                }
                case 3: {
                    flags |= 0x20;
                    continue block6;
                }
                case 4: {
                    flags |= 0x40;
                }
            }
        }
        return flags;
    }

    static String getNameTestName(@Nullable XPathParser.NameTestContext nameTest) {
        if (nameTest == null) {
            return "*";
        }
        if (nameTest.WILDCARD() != null) {
            return "*";
        }
        return nameTest.getText();
    }

    static String getNodeTestName(@Nullable XPathParser.NodeTestContext nodeTest) {
        if (nodeTest == null) {
            return "*";
        }
        if (nodeTest.nameTest() != null) {
            return XPathCompiler.getNameTestName(nodeTest.nameTest());
        }
        if (nodeTest.nodeType() != null) {
            return nodeTest.nodeType().getText();
        }
        return "*";
    }

    static String getAttributeStepName(XPathParser.AttributeStepContext attrStep) {
        if (attrStep.WILDCARD() != null) {
            return "*";
        }
        if (attrStep.QNAME() != null) {
            return attrStep.QNAME().getText();
        }
        if (attrStep.NCNAME() != null) {
            return attrStep.NCNAME().getText();
        }
        return "*";
    }

    static CompiledExpr[] compilePredicates(@Nullable List<XPathParser.PredicateContext> predicates) {
        if (predicates == null || predicates.isEmpty()) {
            return EMPTY_PREDICATES;
        }
        CompiledExpr[] result = new CompiledExpr[predicates.size()];
        for (int i = 0; i < predicates.size(); ++i) {
            result[i] = XPathCompiler.compilePredicate(predicates.get(i));
        }
        return result;
    }

    static CompiledExpr compilePredicate(XPathParser.PredicateContext predicate) {
        if (predicate.predicateExpr() == null || predicate.predicateExpr().expr() == null) {
            return CompiledExpr.unsupported("empty predicate");
        }
        return XPathCompiler.compileExpr(predicate.predicateExpr().expr());
    }

    static CompiledExpr compileExpr(XPathParser.ExprContext expr) {
        if (expr.orExpr() == null) {
            return CompiledExpr.unsupported("empty expression");
        }
        return XPathCompiler.compileOrExpr(expr.orExpr());
    }

    static CompiledExpr compileOrExpr(XPathParser.OrExprContext orExpr) {
        List<XPathParser.AndExprContext> andExprs = orExpr.andExpr();
        if (andExprs.isEmpty()) {
            return CompiledExpr.unsupported("empty or expression");
        }
        CompiledExpr result = XPathCompiler.compileAndExpr(andExprs.get(0));
        for (int i = 1; i < andExprs.size(); ++i) {
            result = CompiledExpr.or(result, XPathCompiler.compileAndExpr(andExprs.get(i)));
        }
        return result;
    }

    static CompiledExpr compileAndExpr(XPathParser.AndExprContext andExpr) {
        List<XPathParser.EqualityExprContext> eqExprs = andExpr.equalityExpr();
        if (eqExprs.isEmpty()) {
            return CompiledExpr.unsupported("empty and expression");
        }
        CompiledExpr result = XPathCompiler.compileEqualityExpr(eqExprs.get(0));
        for (int i = 1; i < eqExprs.size(); ++i) {
            result = CompiledExpr.and(result, XPathCompiler.compileEqualityExpr(eqExprs.get(i)));
        }
        return result;
    }

    static CompiledExpr compileEqualityExpr(XPathParser.EqualityExprContext eqExpr) {
        List<XPathParser.RelationalExprContext> relExprs = eqExpr.relationalExpr();
        if (relExprs.isEmpty()) {
            return CompiledExpr.unsupported("empty equality expression");
        }
        CompiledExpr result = XPathCompiler.compileRelationalExpr(relExprs.get(0));
        for (int i = 1; i < relExprs.size(); ++i) {
            Token opToken = XPathCompiler.getEqualityOperator(eqExpr, i - 1);
            ComparisonOp op = opToken != null && opToken.getType() == 14 ? ComparisonOp.NE : ComparisonOp.EQ;
            CompiledExpr right = XPathCompiler.compileRelationalExpr(relExprs.get(i));
            result = CompiledExpr.comparison(result, op, right);
        }
        return result;
    }

    private static @Nullable Token getEqualityOperator(XPathParser.EqualityExprContext ctx, int index) {
        int tokenIndex = 0;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            TerminalNode term;
            int type;
            if (!(ctx.getChild(i) instanceof TerminalNode) || (type = (term = (TerminalNode)ctx.getChild(i)).getSymbol().getType()) != 13 && type != 14) continue;
            if (tokenIndex == index) {
                return term.getSymbol();
            }
            ++tokenIndex;
        }
        return null;
    }

    static CompiledExpr compileRelationalExpr(XPathParser.RelationalExprContext relExpr) {
        List<XPathParser.UnaryExprContext> unaryExprs = relExpr.unaryExpr();
        if (unaryExprs.isEmpty()) {
            return CompiledExpr.unsupported("empty relational expression");
        }
        CompiledExpr result = XPathCompiler.compileUnaryExpr(unaryExprs.get(0));
        for (int i = 1; i < unaryExprs.size(); ++i) {
            Token opToken = XPathCompiler.getRelationalOperator(relExpr, i - 1);
            ComparisonOp op = ComparisonOp.EQ;
            if (opToken != null) {
                switch (opToken.getType()) {
                    case 17: {
                        op = ComparisonOp.LT;
                        break;
                    }
                    case 18: {
                        op = ComparisonOp.GT;
                        break;
                    }
                    case 15: {
                        op = ComparisonOp.LE;
                        break;
                    }
                    case 16: {
                        op = ComparisonOp.GE;
                    }
                }
            }
            CompiledExpr right = XPathCompiler.compileUnaryExpr(unaryExprs.get(i));
            result = CompiledExpr.comparison(result, op, right);
        }
        return result;
    }

    private static @Nullable Token getRelationalOperator(XPathParser.RelationalExprContext ctx, int index) {
        int tokenIndex = 0;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            TerminalNode term;
            int type;
            if (!(ctx.getChild(i) instanceof TerminalNode) || (type = (term = (TerminalNode)ctx.getChild(i)).getSymbol().getType()) != 17 && type != 18 && type != 15 && type != 16) continue;
            if (tokenIndex == index) {
                return term.getSymbol();
            }
            ++tokenIndex;
        }
        return null;
    }

    static CompiledExpr compileUnaryExpr(XPathParser.UnaryExprContext unaryExpr) {
        return XPathCompiler.compileUnionExpr(unaryExpr.unionExpr());
    }

    static CompiledExpr compileUnionExpr(XPathParser.UnionExprContext unionExpr) {
        return XPathCompiler.compilePathExpr(unionExpr.pathExpr());
    }

    static CompiledExpr compilePathExpr(XPathParser.PathExprContext pathExpr) {
        if (pathExpr.locationPath() != null) {
            return XPathCompiler.compileLocationPathAsExpr(pathExpr.locationPath());
        }
        CompiledExpr filterResult = null;
        if (pathExpr.functionCallExpr() != null) {
            filterResult = XPathCompiler.compileFunctionCallExpr(pathExpr.functionCallExpr());
        } else if (pathExpr.bracketedExpr() != null) {
            filterResult = XPathCompiler.compileBracketedExpr(pathExpr.bracketedExpr());
        } else if (pathExpr.literalOrNumber() != null) {
            filterResult = XPathCompiler.compileLiteralOrNumber(pathExpr.literalOrNumber());
        }
        if (filterResult != null) {
            if (pathExpr.pathSeparator() != null && pathExpr.relativeLocationPath() != null) {
                return filterResult;
            }
            return filterResult;
        }
        return CompiledExpr.unsupported("unknown path expression");
    }

    static CompiledExpr compileLocationPathAsExpr(XPathParser.LocationPathContext locationPath) {
        if (locationPath.absoluteLocationPath() != null) {
            return CompiledExpr.absolutePath(locationPath.getText());
        }
        if (locationPath.relativeLocationPath() != null) {
            return XPathCompiler.compileRelativePathAsExpr(locationPath.relativeLocationPath());
        }
        return CompiledExpr.unsupported("unknown location path");
    }

    static CompiledExpr compileRelativePathAsExpr(XPathParser.RelativeLocationPathContext relPath) {
        List<XPathParser.StepContext> steps = relPath.step();
        if (steps.isEmpty()) {
            return CompiledExpr.unsupported("empty path");
        }
        XPathParser.StepContext lastStep = steps.get(steps.size() - 1);
        FunctionType terminalFunction = null;
        int elementStepCount = steps.size();
        if (lastStep.nodeTest() != null && lastStep.nodeTest().nodeType() != null) {
            String funcName = lastStep.nodeTest().nodeType().getText();
            terminalFunction = XPathCompiler.getNodeTypeAsFunctionType(funcName);
            elementStepCount = steps.size() - 1;
        }
        if (elementStepCount == 1 && terminalFunction == null) {
            XPathParser.StepContext step = steps.get(0);
            if (step.abbreviatedStep() != null) {
                if (step.abbreviatedStep().DOTDOT() != null) {
                    return CompiledExpr.parent();
                }
                if (step.abbreviatedStep().DOT() != null) {
                    return CompiledExpr.self();
                }
            }
            if (step.nodeTest() != null) {
                return CompiledExpr.child(XPathCompiler.getNodeTestName(step.nodeTest()));
            }
            if (step.attributeStep() != null) {
                return CompiledExpr.attribute(XPathCompiler.getAttributeStepName(step.attributeStep()));
            }
        }
        CompiledExpr[] pathSteps = new CompiledExpr[elementStepCount];
        for (int i = 0; i < elementStepCount; ++i) {
            XPathParser.StepContext step = steps.get(i);
            if (step.nodeTest() != null) {
                pathSteps[i] = CompiledExpr.child(XPathCompiler.getNodeTestName(step.nodeTest()));
                continue;
            }
            if (step.abbreviatedStep() != null) {
                if (step.abbreviatedStep().DOTDOT() != null) {
                    pathSteps[i] = CompiledExpr.parent();
                    continue;
                }
                pathSteps[i] = CompiledExpr.self();
                continue;
            }
            if (step.attributeStep() != null) {
                pathSteps[i] = CompiledExpr.attribute(XPathCompiler.getAttributeStepName(step.attributeStep()));
                continue;
            }
            return CompiledExpr.unsupported("complex step in path");
        }
        return CompiledExpr.path(pathSteps, terminalFunction);
    }

    private static @Nullable FunctionType getNodeTypeAsFunctionType(String name) {
        switch (name) {
            case "text": {
                return FunctionType.TEXT;
            }
            case "comment": {
                return FunctionType.COMMENT;
            }
            case "node": {
                return FunctionType.NODE;
            }
            case "processing-instruction": {
                return FunctionType.PROCESSING_INSTRUCTION;
            }
        }
        return null;
    }

    static CompiledExpr compileFunctionCallExpr(XPathParser.FunctionCallExprContext fcExpr) {
        return XPathCompiler.compileFunctionCall(fcExpr.functionCall());
    }

    static CompiledExpr compileBracketedExpr(XPathParser.BracketedExprContext bracketed) {
        if (bracketed.expr() != null) {
            return XPathCompiler.compileExpr(bracketed.expr());
        }
        return CompiledExpr.unsupported("empty bracketed expression");
    }

    static CompiledExpr compileLiteralOrNumber(XPathParser.LiteralOrNumberContext literalOrNum) {
        if (literalOrNum.literal() != null) {
            return CompiledExpr.string(XPathCompiler.stripQuotes(literalOrNum.literal().getText()));
        }
        if (literalOrNum.NUMBER() != null) {
            try {
                int value = Integer.parseInt(literalOrNum.NUMBER().getText());
                return CompiledExpr.numeric(value);
            }
            catch (NumberFormatException e) {
                return CompiledExpr.unsupported("invalid number: " + literalOrNum.NUMBER().getText());
            }
        }
        return CompiledExpr.unsupported("unknown literal/number");
    }

    static CompiledExpr compileFunctionCall(XPathParser.FunctionCallContext fc) {
        if (fc.functionName() == null) {
            return CompiledExpr.unsupported("unknown function");
        }
        String funcName = XPathCompiler.getFunctionNameText(fc.functionName());
        if (funcName == null) {
            return CompiledExpr.unsupported("unknown function");
        }
        FunctionType type = XPathCompiler.getFunctionType(funcName);
        CompiledExpr[] args = EMPTY_PREDICATES;
        List<XPathParser.ArgumentContext> argCtxs = fc.argument();
        if (argCtxs != null && !argCtxs.isEmpty()) {
            args = new CompiledExpr[argCtxs.size()];
            for (int i = 0; i < argCtxs.size(); ++i) {
                args[i] = XPathCompiler.compileArgument(argCtxs.get(i));
            }
        }
        return CompiledExpr.function(type, args);
    }

    static CompiledExpr compileArgument(XPathParser.ArgumentContext arg) {
        if (arg.expr() != null) {
            return XPathCompiler.compileExpr(arg.expr());
        }
        return CompiledExpr.unsupported("unknown argument type");
    }

    private static @Nullable String getFunctionNameText(XPathParser.FunctionNameContext fnCtx) {
        return fnCtx.getText();
    }

    static FunctionType getFunctionType(String name) {
        switch (name) {
            case "position": {
                return FunctionType.POSITION;
            }
            case "last": {
                return FunctionType.LAST;
            }
            case "local-name": {
                return FunctionType.LOCAL_NAME;
            }
            case "namespace-uri": {
                return FunctionType.NAMESPACE_URI;
            }
            case "contains": {
                return FunctionType.CONTAINS;
            }
            case "starts-with": {
                return FunctionType.STARTS_WITH;
            }
            case "ends-with": {
                return FunctionType.ENDS_WITH;
            }
            case "string-length": {
                return FunctionType.STRING_LENGTH;
            }
            case "substring-before": {
                return FunctionType.SUBSTRING_BEFORE;
            }
            case "substring-after": {
                return FunctionType.SUBSTRING_AFTER;
            }
            case "count": {
                return FunctionType.COUNT;
            }
            case "text": {
                return FunctionType.TEXT;
            }
            case "not": {
                return FunctionType.NOT;
            }
            case "comment": {
                return FunctionType.COMMENT;
            }
            case "node": {
                return FunctionType.NODE;
            }
            case "processing-instruction": {
                return FunctionType.PROCESSING_INSTRUCTION;
            }
        }
        throw new IllegalArgumentException("Unsupported XPath function: " + name + "()");
    }

    static String stripQuotes(String s) {
        if (s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if ((first == '\'' || first == '\"') && s.charAt(s.length() - 1) == first) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static final class CompiledXPath {
        final CompiledStep[] steps;
        final int flags;
        final int exprType;
        final @Nullable CompiledExpr booleanExpr;
        final @Nullable CompiledFilterExpr filterExpr;

        CompiledXPath(CompiledStep[] steps, int flags, int exprType, @Nullable CompiledExpr booleanExpr, @Nullable CompiledFilterExpr filterExpr) {
            this.steps = steps;
            this.flags = flags;
            this.exprType = exprType;
            this.booleanExpr = booleanExpr;
            this.filterExpr = filterExpr;
        }

        public boolean isPathExpression() {
            return this.exprType == 0;
        }

        public boolean isBooleanExpression() {
            return this.exprType == 1;
        }

        public boolean isFilterExpression() {
            return this.exprType == 2;
        }

        public boolean hasAbsolutePath() {
            return (this.flags & 1) != 0;
        }

        public boolean hasDescendantOrSelf() {
            return (this.flags & 2) != 0;
        }

        public boolean hasDescendant() {
            return (this.flags & 4) != 0;
        }
    }

    public static final class CompiledStep {
        final StepType type;
        final boolean isDescendant;
        final @Nullable String name;
        final AxisType axisType;
        final NodeTypeTestType nodeTypeTestType;
        final CompiledExpr[] predicates;
        private static final int STEP_FLAG_NEEDS_POSITION = 1;
        private static final int STEP_FLAG_NEXT_IS_BACKTRACK = 2;
        int flags;
        static final byte STRATEGY_NAME_ONLY = 0;
        static final byte STRATEGY_NAME_THEN_PRED = 1;
        static final byte STRATEGY_WILDCARD = 2;
        static final byte STRATEGY_PRED_ONLY = 3;
        static final byte STRATEGY_DOT = 4;
        static final byte STRATEGY_NODE_TYPE = 5;
        static final byte STRATEGY_OTHER = 6;
        final byte strategy;

        private CompiledStep(StepType type, boolean isDescendant, @Nullable String name, AxisType axisType, NodeTypeTestType nodeTypeTestType, CompiledExpr[] predicates, int flags, byte strategy) {
            this.type = type;
            this.isDescendant = isDescendant;
            this.name = name;
            this.axisType = axisType;
            this.nodeTypeTestType = nodeTypeTestType;
            this.predicates = predicates;
            this.flags = flags;
            this.strategy = strategy;
        }

        private static byte computeStrategy(StepType type, @Nullable String name, CompiledExpr[] predicates) {
            switch (type.ordinal()) {
                case 5: {
                    boolean hasPredicates;
                    boolean isWildcard = "*".equals(name);
                    boolean bl = hasPredicates = predicates.length > 0;
                    if (isWildcard) {
                        return hasPredicates ? (byte)3 : 2;
                    }
                    return hasPredicates ? (byte)1 : 0;
                }
                case 0: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
            return 6;
        }

        public byte getStrategy() {
            return this.strategy;
        }

        public StepType getType() {
            return this.type;
        }

        public boolean isDescendant() {
            return this.isDescendant;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public AxisType getAxisType() {
            return this.axisType;
        }

        public NodeTypeTestType getNodeTypeTestType() {
            return this.nodeTypeTestType;
        }

        public CompiledExpr[] getPredicates() {
            return this.predicates;
        }

        boolean needsPositionInfo() {
            return (this.flags & 1) != 0;
        }

        boolean nextIsBacktrack() {
            return (this.flags & 2) != 0;
        }

        void setNextIsBacktrack() {
            this.flags |= 2;
        }

        static CompiledStep fromStepContext(XPathParser.StepContext step, boolean isDescendant) {
            int flags;
            CompiledExpr[] predicates = XPathCompiler.compilePredicates(step.predicate());
            int n = flags = CompiledStep.predicatesNeedPosition(predicates) ? 1 : 0;
            if (step.abbreviatedStep() != null) {
                if (step.abbreviatedStep().DOTDOT() != null) {
                    return new CompiledStep(StepType.ABBREVIATED_DOTDOT, isDescendant, null, AxisType.OTHER, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.ABBREVIATED_DOTDOT, null, predicates));
                }
                return new CompiledStep(StepType.ABBREVIATED_DOT, isDescendant, null, AxisType.OTHER, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.ABBREVIATED_DOT, null, predicates));
            }
            if (step.attributeStep() != null) {
                String attrName = XPathCompiler.getAttributeStepName(step.attributeStep());
                return new CompiledStep(StepType.ATTRIBUTE_STEP, isDescendant, attrName, AxisType.OTHER, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.ATTRIBUTE_STEP, attrName, predicates));
            }
            if (step.axisSpecifier() != null && step.nodeTest() != null) {
                AxisType axisType;
                XPathParser.AxisSpecifierContext axisSpec = step.axisSpecifier();
                String axisName = axisSpec.axisName().NCNAME().getText();
                String nodeTestName = XPathCompiler.getNodeTestName(step.nodeTest());
                switch (axisName) {
                    case "parent": {
                        axisType = AxisType.PARENT;
                        break;
                    }
                    case "self": {
                        axisType = AxisType.SELF;
                        break;
                    }
                    case "child": {
                        axisType = AxisType.CHILD;
                        break;
                    }
                    default: {
                        axisType = AxisType.OTHER;
                    }
                }
                return new CompiledStep(StepType.AXIS_STEP, isDescendant, nodeTestName, axisType, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.AXIS_STEP, nodeTestName, predicates));
            }
            if (step.nodeTest() != null) {
                XPathParser.NodeTestContext nodeTest = step.nodeTest();
                if (nodeTest.nodeType() != null) {
                    NodeTypeTestType testType;
                    String functionName;
                    switch (functionName = nodeTest.nodeType().getText()) {
                        case "text": {
                            testType = NodeTypeTestType.TEXT;
                            break;
                        }
                        case "comment": {
                            testType = NodeTypeTestType.COMMENT;
                            break;
                        }
                        case "node": {
                            testType = NodeTypeTestType.NODE;
                            break;
                        }
                        case "processing-instruction": {
                            testType = NodeTypeTestType.PROCESSING_INSTRUCTION;
                            break;
                        }
                        default: {
                            testType = NodeTypeTestType.UNKNOWN;
                        }
                    }
                    return new CompiledStep(StepType.NODE_TYPE_TEST, isDescendant, null, AxisType.OTHER, testType, predicates, flags, CompiledStep.computeStrategy(StepType.NODE_TYPE_TEST, null, predicates));
                }
                String nodeName = XPathCompiler.getNodeTestName(nodeTest);
                return new CompiledStep(StepType.NODE_TEST, isDescendant, nodeName, AxisType.OTHER, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.NODE_TEST, nodeName, predicates));
            }
            return new CompiledStep(StepType.NODE_TEST, isDescendant, null, AxisType.OTHER, NodeTypeTestType.UNKNOWN, predicates, flags, CompiledStep.computeStrategy(StepType.NODE_TEST, null, predicates));
        }

        private static boolean predicatesNeedPosition(CompiledExpr[] predicates) {
            for (CompiledExpr pred : predicates) {
                if (!pred.needsPosition()) continue;
                return true;
            }
            return false;
        }

        boolean isBacktrack() {
            return this.type == StepType.ABBREVIATED_DOTDOT || this.type == StepType.AXIS_STEP && this.axisType == AxisType.PARENT;
        }

        CompiledStep withAdditionalPredicate(CompiledExpr predicate) {
            CompiledExpr[] newPredicates = new CompiledExpr[this.predicates.length + 1];
            System.arraycopy(this.predicates, 0, newPredicates, 0, this.predicates.length);
            newPredicates[this.predicates.length] = predicate;
            int newFlags = this.flags;
            if (predicate.needsPosition()) {
                newFlags |= 1;
            }
            return new CompiledStep(this.type, this.isDescendant, this.name, this.axisType, this.nodeTypeTestType, newPredicates, newFlags, CompiledStep.computeStrategy(this.type, this.name, newPredicates));
        }
    }

    public static final class CompiledExpr {
        final ExprType type;
        final int numericValue;
        final @Nullable String stringValue;
        final @Nullable CompiledExpr left;
        final @Nullable ComparisonOp op;
        final @Nullable CompiledExpr right;
        final @Nullable FunctionType functionType;
        final CompiledExpr @Nullable [] args;
        final @Nullable String name;
        final boolean booleanValue;

        private CompiledExpr(ExprType type, int numericValue, @Nullable String stringValue, @Nullable CompiledExpr left, @Nullable ComparisonOp op, @Nullable CompiledExpr right, @Nullable FunctionType functionType, CompiledExpr @Nullable [] args, @Nullable String name, boolean booleanValue) {
            this.type = type;
            this.numericValue = numericValue;
            this.stringValue = stringValue;
            this.left = left;
            this.op = op;
            this.right = right;
            this.functionType = functionType;
            this.args = args;
            this.name = name;
            this.booleanValue = booleanValue;
        }

        public static CompiledExpr numeric(int value) {
            return new CompiledExpr(ExprType.NUMERIC, value, null, null, null, null, null, null, null, false);
        }

        public static CompiledExpr string(String value) {
            return new CompiledExpr(ExprType.STRING, 0, value, null, null, null, null, null, null, false);
        }

        public static CompiledExpr comparison(CompiledExpr left, ComparisonOp op, CompiledExpr right) {
            return new CompiledExpr(ExprType.COMPARISON, 0, null, left, op, right, null, null, null, false);
        }

        public static CompiledExpr and(CompiledExpr left, CompiledExpr right) {
            return new CompiledExpr(ExprType.AND, 0, null, left, null, right, null, null, null, false);
        }

        public static CompiledExpr or(CompiledExpr left, CompiledExpr right) {
            return new CompiledExpr(ExprType.OR, 0, null, left, null, right, null, null, null, false);
        }

        public static CompiledExpr function(FunctionType type, CompiledExpr ... args) {
            return new CompiledExpr(ExprType.FUNCTION, 0, null, null, null, null, type, args, null, false);
        }

        public static CompiledExpr attribute(@Nullable String name) {
            return new CompiledExpr(ExprType.ATTRIBUTE, 0, null, null, null, null, null, null, name, false);
        }

        public static CompiledExpr child(@Nullable String name) {
            return new CompiledExpr(ExprType.CHILD, 0, null, null, null, null, null, null, name, false);
        }

        public static CompiledExpr parent() {
            return new CompiledExpr(ExprType.PARENT, 0, null, null, null, null, null, null, null, false);
        }

        public static CompiledExpr self() {
            return new CompiledExpr(ExprType.SELF, 0, null, null, null, null, null, null, null, false);
        }

        public static CompiledExpr path(CompiledExpr[] steps, @Nullable FunctionType terminalFunction) {
            return new CompiledExpr(ExprType.PATH, 0, null, null, null, null, terminalFunction, steps, null, false);
        }

        public static CompiledExpr bool(boolean value) {
            return new CompiledExpr(ExprType.BOOLEAN, 0, null, null, null, null, null, null, null, value);
        }

        public static CompiledExpr absolutePath(String pathExpr) {
            return new CompiledExpr(ExprType.ABSOLUTE_PATH, 0, pathExpr, null, null, null, null, null, null, false);
        }

        public static CompiledExpr unsupported(String description) {
            throw new UnsupportedOperationException("Unsupported XPath expression: " + description);
        }

        public boolean needsPosition() {
            switch (this.type.ordinal()) {
                case 0: {
                    return true;
                }
                case 5: {
                    return this.functionType == FunctionType.POSITION || this.functionType == FunctionType.LAST;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.left != null && this.left.needsPosition() || this.right != null && this.right.needsPosition();
                }
            }
            return false;
        }

        public boolean isWildcard() {
            return !(this.type != ExprType.ATTRIBUTE && this.type != ExprType.CHILD || this.name != null && !"*".equals(this.name));
        }

        public boolean hasRelativePath() {
            switch (this.type.ordinal()) {
                case 7: 
                case 8: {
                    return true;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.left != null && this.left.hasRelativePath() || this.right != null && this.right.hasRelativePath();
                }
                case 5: {
                    if (this.args != null) {
                        for (CompiledExpr arg : this.args) {
                            if (!arg.hasRelativePath()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public boolean hasPureAbsolutePath() {
            switch (this.type.ordinal()) {
                case 9: {
                    return this.stringValue != null && this.stringValue.startsWith("/") && !this.stringValue.startsWith("//");
                }
                case 2: 
                case 3: 
                case 4: {
                    boolean leftPure = this.left == null || !this.left.hasAnyAbsolutePath() || this.left.hasPureAbsolutePath();
                    boolean rightPure = this.right == null || !this.right.hasAnyAbsolutePath() || this.right.hasPureAbsolutePath();
                    boolean hasAny = this.left != null && this.left.hasAnyAbsolutePath() || this.right != null && this.right.hasAnyAbsolutePath();
                    return hasAny && leftPure && rightPure;
                }
                case 5: {
                    if (this.args != null) {
                        boolean anyAbsolute = false;
                        for (CompiledExpr arg : this.args) {
                            if (!arg.hasAnyAbsolutePath()) continue;
                            anyAbsolute = true;
                            if (arg.hasPureAbsolutePath()) continue;
                            return false;
                        }
                        return anyAbsolute;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean hasAnyAbsolutePath() {
            switch (this.type.ordinal()) {
                case 9: {
                    return true;
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.left != null && this.left.hasAnyAbsolutePath() || this.right != null && this.right.hasAnyAbsolutePath();
                }
                case 5: {
                    if (this.args != null) {
                        for (CompiledExpr arg : this.args) {
                            if (!arg.hasAnyAbsolutePath()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        public ExprType getType() {
            return this.type;
        }
    }

    public static final class CompiledFilterExpr {
        final String pathExpr;
        final CompiledExpr[] predicates;
        final @Nullable String trailingPath;
        final boolean trailingIsDescendant;

        CompiledFilterExpr(String pathExpr, CompiledExpr[] predicates, @Nullable String trailingPath, boolean trailingIsDescendant) {
            this.pathExpr = pathExpr;
            this.predicates = predicates;
            this.trailingPath = trailingPath;
            this.trailingIsDescendant = trailingIsDescendant;
        }
    }

    public static enum StepType {
        ABBREVIATED_DOT,
        ABBREVIATED_DOTDOT,
        AXIS_STEP,
        ATTRIBUTE_STEP,
        NODE_TYPE_TEST,
        NODE_TEST;

    }

    public static enum FunctionType {
        POSITION,
        LAST,
        LOCAL_NAME,
        NAMESPACE_URI,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH,
        STRING_LENGTH,
        SUBSTRING_BEFORE,
        SUBSTRING_AFTER,
        COUNT,
        TEXT,
        NOT,
        COMMENT,
        NODE,
        PROCESSING_INSTRUCTION;

    }

    public static enum ComparisonOp {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;

    }

    public static enum ExprType {
        NUMERIC,
        STRING,
        COMPARISON,
        AND,
        OR,
        FUNCTION,
        ATTRIBUTE,
        CHILD,
        PATH,
        ABSOLUTE_PATH,
        BOOLEAN,
        PARENT,
        SELF;

    }

    public static enum NodeTypeTestType {
        TEXT,
        COMMENT,
        NODE,
        PROCESSING_INSTRUCTION,
        UNKNOWN;

    }

    public static enum AxisType {
        PARENT,
        SELF,
        CHILD,
        OTHER;

    }
}

