/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeNamespaceValue
extends Recipe {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String VERSION_PREFIX = "version";
    @Nullable
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be changed. Interpreted as an XPath Expression.", example="property", required=false)
    private final String elementName;
    @Nullable
    @Option(displayName="Old value", description="Only change the property value if it matches the configured `oldValue`.", example="newfoo.bar.attribute.value.string", required=false)
    private final String oldValue;
    @Option(displayName="New value", description="The new value to be used for the namespace.", example="newfoo.bar.attribute.value.string")
    private final String newValue;
    @Nullable
    @Option(displayName="Resource version", description="The version of resource to change", example="1.1", required=false)
    private final String versionMatcher;
    @Nullable
    @Option(displayName="Search All Namespaces", description="Specify whether evaluate all namespaces. Defaults to true", example="true", required=false)
    private final Boolean searchAllNamespaces;

    public String getDisplayName() {
        return "Change XML Attribute of a specific resource version";
    }

    public String getDescription() {
        return "Alters XML Attribute value within specified element of a specific resource versions.";
    }

    @JsonCreator
    public ChangeNamespaceValue(@Nullable @JsonProperty(value="elementName") String elementName, @Nullable @JsonProperty(value="oldValue") String oldValue, @NonNull @JsonProperty(value="newValue") String newValue, @Nullable @JsonProperty(value="versionMatcher") String versionMatcher, @Nullable @JsonProperty(value="searchAllNamespaces") Boolean searchAllNamespaces) {
        this.elementName = elementName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.versionMatcher = versionMatcher;
        this.searchAllNamespaces = searchAllNamespaces;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){
            @Nullable
            private final XPathMatcher elementNameMatcher;
            {
                this.elementNameMatcher = ChangeNamespaceValue.this.elementName != null ? new XPathMatcher(ChangeNamespaceValue.this.elementName) : null;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml t = super.visitTag(tag, ctx);
                if (this.matchesElementName(this.getCursor()) && this.matchesVersion((Xml.Tag)t)) {
                    t = ((Xml.Tag)t).withAttributes(ListUtils.map(((Xml.Tag)t).getAttributes(), this::maybeReplaceNamespaceAttribute));
                }
                return t;
            }

            private boolean matchesElementName(Cursor cursor) {
                return this.elementNameMatcher == null || this.elementNameMatcher.matches(cursor);
            }

            private boolean matchesVersion(Xml.Tag tag) {
                if (ChangeNamespaceValue.this.versionMatcher == null) {
                    return true;
                }
                for (Xml.Attribute attribute : tag.getAttributes()) {
                    if (!this.isVersionAttribute(attribute) || !this.isVersionMatch(attribute)) continue;
                    return true;
                }
                return false;
            }

            private Xml.Attribute maybeReplaceNamespaceAttribute(Xml.Attribute attribute) {
                if (this.isXmlnsAttribute(attribute) && this.isOldValue(attribute)) {
                    return attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), ChangeNamespaceValue.this.newValue));
                }
                return attribute;
            }

            private boolean isXmlnsAttribute(Xml.Attribute attribute) {
                boolean searchAll = ChangeNamespaceValue.this.searchAllNamespaces == null || Boolean.TRUE.equals(ChangeNamespaceValue.this.searchAllNamespaces);
                return searchAll && attribute.getKeyAsString().startsWith(ChangeNamespaceValue.XMLNS_PREFIX) || !searchAll && attribute.getKeyAsString().equals(ChangeNamespaceValue.XMLNS_PREFIX);
            }

            private boolean isVersionAttribute(Xml.Attribute attribute) {
                return attribute.getKeyAsString().startsWith(ChangeNamespaceValue.VERSION_PREFIX);
            }

            private boolean isOldValue(Xml.Attribute attribute) {
                return ChangeNamespaceValue.this.oldValue == null || attribute.getValueAsString().equals(ChangeNamespaceValue.this.oldValue);
            }

            private boolean isVersionMatch(Xml.Attribute attribute) {
                String[] versions = ChangeNamespaceValue.this.versionMatcher.split(",");
                double dversion = Double.parseDouble(attribute.getValueAsString());
                for (String splitVersion : versions) {
                    double dversionExpected;
                    boolean checkGreaterThan = false;
                    if (splitVersion.endsWith("+")) {
                        splitVersion = splitVersion.substring(0, splitVersion.length() - 1);
                        checkGreaterThan = true;
                    }
                    try {
                        dversionExpected = Double.parseDouble(splitVersion);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    if ((checkGreaterThan || dversionExpected != dversion) && (!checkGreaterThan || !(dversionExpected <= dversion))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public String getElementName() {
        return this.elementName;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public String getVersionMatcher() {
        return this.versionMatcher;
    }

    @Nullable
    public Boolean getSearchAllNamespaces() {
        return this.searchAllNamespaces;
    }

    @NonNull
    public String toString() {
        return "ChangeNamespaceValue(elementName=" + this.getElementName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", versionMatcher=" + this.getVersionMatcher() + ", searchAllNamespaces=" + this.getSearchAllNamespaces() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeNamespaceValue)) {
            return false;
        }
        ChangeNamespaceValue other = (ChangeNamespaceValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$searchAllNamespaces = this.getSearchAllNamespaces();
        Boolean other$searchAllNamespaces = other.getSearchAllNamespaces();
        if (this$searchAllNamespaces == null ? other$searchAllNamespaces != null : !((Object)this$searchAllNamespaces).equals(other$searchAllNamespaces)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$versionMatcher = this.getVersionMatcher();
        String other$versionMatcher = other.getVersionMatcher();
        return !(this$versionMatcher == null ? other$versionMatcher != null : !this$versionMatcher.equals(other$versionMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeNamespaceValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $searchAllNamespaces = this.getSearchAllNamespaces();
        result = result * 59 + ($searchAllNamespaces == null ? 43 : ((Object)$searchAllNamespaces).hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $versionMatcher = this.getVersionMatcher();
        result = result * 59 + ($versionMatcher == null ? 43 : $versionMatcher.hashCode());
        return result;
    }
}

