/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.trait;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.trait.Reference;
import org.openrewrite.xml.tree.Xml;

public abstract class XmlReference
implements Reference {
    public Tree getTree() {
        return super.getTree();
    }

    public String getValue() {
        Xml.Tag tag;
        if (this.getTree() instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)this.getTree();
            return attribute.getValueAsString();
        }
        if (this.getTree() instanceof Xml.Tag && (tag = (Xml.Tag)this.getTree()).getValue().isPresent()) {
            return tag.getValue().get();
        }
        throw new IllegalArgumentException("getTree() must be an Xml.Attribute or Xml.Tag: " + this.getTree().getClass());
    }

    public boolean supportsRename() {
        return true;
    }

    public Tree rename(Reference.Renamer renamer, Cursor cursor, ExecutionContext ctx) {
        Tree tree = (Tree)cursor.getValue();
        if (tree instanceof Xml.Attribute) {
            Xml.Attribute attribute = (Xml.Attribute)tree;
            String renamed = renamer.rename((Reference)this);
            return attribute.withValue(attribute.getValue().withValue(renamed));
        }
        if (tree instanceof Xml.Tag && ((Xml.Tag)tree).getValue().isPresent()) {
            String renamed = renamer.rename((Reference)this);
            return ((Xml.Tag)tree).withValue(renamed);
        }
        return tree;
    }
}

