/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.style;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.style.Autodetect;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.table.XmlStyleReport;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class AutodetectDebug
extends ScanningRecipe<Accumulator> {
    private final transient XmlStyleReport report = new XmlStyleReport((Recipe)this);

    public String getDisplayName() {
        return "XML style Auto-detection debug";
    }

    public String getDescription() {
        return "Runs XML Autodetect and records the results in data tables and search markers. A debugging tool for figuring out why XML documents get styled the way they do.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                acc.overallDetector.sample((SourceFile)document);
                return document;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        TabsAndIndentsStyle tis = acc.overallProjectStyle();
        this.report.insertRow(ctx, new XmlStyleReport.Row("Overall Project Style", tis.getUseTabCharacter(), tis.getIndentSize(), tis.getTabSize(), tis.getContinuationIndentSize(), -1, -1, -1, -1, -1, -1));
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new XmlVisitor<ExecutionContext>(){
            TabsAndIndentsStyle currentDocumentStyle;
            int tagPrefixesCounted;
            int tagIndentsMatchingOwnStyle;
            int tagIndentsMatchingProjectStyle;
            int attributePrefixesCounted;
            int attributeIndentsMatchingOwnStyle;
            int attributeIndentsMatchingProjectStyle;
            int depth = 0;

            @Override
            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Autodetect.Detector detector = new Autodetect.Detector();
                detector.sample((SourceFile)document);
                this.currentDocumentStyle = Objects.requireNonNull((TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, Collections.singletonList(detector.build())));
                super.visitDocument(document, ctx);
                AutodetectDebug.this.report.insertRow(ctx, new XmlStyleReport.Row(document.getSourcePath().toString(), this.currentDocumentStyle.getUseTabCharacter(), this.currentDocumentStyle.getIndentSize(), this.currentDocumentStyle.getTabSize(), this.currentDocumentStyle.getContinuationIndentSize(), this.tagPrefixesCounted, this.tagIndentsMatchingOwnStyle, this.tagIndentsMatchingProjectStyle, this.attributePrefixesCounted, this.attributeIndentsMatchingOwnStyle, this.attributeIndentsMatchingProjectStyle));
                return document;
            }

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.depth > 0) {
                    ++this.tagPrefixesCounted;
                    if (AutodetectDebug.indentMatchesStyle(tag.getPrefix(), this.depth, this.currentDocumentStyle)) {
                        ++this.tagIndentsMatchingOwnStyle;
                    }
                    if (AutodetectDebug.indentMatchesStyle(tag.getPrefix(), this.depth, acc.overallProjectStyle())) {
                        ++this.tagIndentsMatchingProjectStyle;
                    }
                }
                ListUtils.map(tag.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, ctx));
                ++this.depth;
                ListUtils.map(tag.getContent(), a -> (Content)this.visitAndCast((Tree)a, ctx));
                --this.depth;
                return tag;
            }

            @Override
            public Xml visitAttribute(Xml.Attribute attribute, ExecutionContext ctx) {
                if (attribute.getPrefix().contains("\n")) {
                    ++this.attributePrefixesCounted;
                    if (AutodetectDebug.continuationIndentMatchesStyle(attribute.getPrefix(), this.depth, this.currentDocumentStyle)) {
                        ++this.attributeIndentsMatchingOwnStyle;
                    }
                    if (AutodetectDebug.continuationIndentMatchesStyle(attribute.getPrefix(), this.depth, acc.overallProjectStyle())) {
                        ++this.attributeIndentsMatchingProjectStyle;
                    }
                }
                return attribute;
            }
        };
    }

    private static boolean indentMatchesStyle(String prefix, int depth, TabsAndIndentsStyle s) {
        String lastLineOfPrefix = prefix.substring(prefix.lastIndexOf("\n") + 1);
        String expectedPrefix = s.getUseTabCharacter() != false ? StringUtils.repeat((String)"\t", (int)depth) : StringUtils.repeat((String)" ", (int)(s.getIndentSize() * depth));
        return lastLineOfPrefix.equals(expectedPrefix);
    }

    private static boolean continuationIndentMatchesStyle(String prefix, int depth, TabsAndIndentsStyle s) {
        String lastLineOfPrefix = prefix.substring(prefix.lastIndexOf("\n") + 1);
        String expectedPrefix = s.getUseTabCharacter() != false ? StringUtils.repeat((String)"\t", (int)depth) + StringUtils.repeat((String)"\t", (int)s.getContinuationIndentSize()) : StringUtils.repeat((String)" ", (int)(s.getIndentSize() * depth)) + StringUtils.repeat((String)" ", (int)s.getContinuationIndentSize());
        return lastLineOfPrefix.equals(expectedPrefix);
    }

    public static class Accumulator {
        Autodetect.Detector overallDetector = new Autodetect.Detector();
        private @Nullable TabsAndIndentsStyle overallProjectStyle;

        TabsAndIndentsStyle overallProjectStyle() {
            if (this.overallProjectStyle == null) {
                this.overallProjectStyle = Objects.requireNonNull((TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, Collections.singletonList(this.overallDetector.build())));
            }
            return this.overallProjectStyle;
        }
    }
}

