/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class TabsAndIndentsVisitor<P>
extends XmlIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final TabsAndIndentsStyle style;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public Xml preVisit(Xml tree, P p) {
        String prefix;
        Xml x = (Xml)super.preVisit((Tree)tree, p);
        if (x != null && (prefix = x.getPrefix()).contains("\n")) {
            int indentMultiple = (int)this.getCursor().getPathAsStream().filter(Xml.Tag.class::isInstance).count() - 1;
            if (this.getCursor().getValue() instanceof Xml.Attribute || this.getCursor().getValue() instanceof Xml.CharData || this.getCursor().getValue() instanceof Xml.Comment || this.getCursor().getValue() instanceof Xml.ProcessingInstruction) {
                ++indentMultiple;
            }
            StringBuilder shiftedPrefixBuilder = new StringBuilder(prefix.substring(0, prefix.lastIndexOf(10) + 1));
            for (int i = 0; i < indentMultiple; ++i) {
                if (this.style.getUseTabCharacter().booleanValue()) {
                    shiftedPrefixBuilder.append("\t");
                    continue;
                }
                for (int j = 0; j < (x instanceof Xml.Attribute ? this.style.getContinuationIndentSize() : this.style.getIndentSize()); ++j) {
                    shiftedPrefixBuilder.append(" ");
                }
            }
            String shiftedPrefix = shiftedPrefixBuilder.toString();
            if (!shiftedPrefix.equals(prefix)) {
                return x.withPrefix(shiftedPrefix);
            }
        }
        return x;
    }

    public @Nullable Xml postVisit(Xml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "stop", (Object)true);
        }
        return (Xml)super.postVisit((Tree)tree, p);
    }

    public @Nullable Xml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Xml)tree;
        }
        return (Xml)super.visit(tree, p);
    }
}

