/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagAttribute
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be changed. Interpreted as an XPath expression.", example="property")
    private final String elementName;
    @Option(displayName="Attribute name", description="The name of the attribute whose value is to be changed.", example="name")
    private final String attributeName;
    @Option(displayName="New value", description="The new value to be used for key specified by `attributeName`, Set to null if you want to remove the attribute.", example="newfoo.bar.attribute.value.string")
    @Nullable
    private final String newValue;
    @Option(displayName="Old value", example="foo.bar.attribute.value.string", required=false, description="Only change the property value if it matches the configured `oldValue`.")
    @Nullable
    private final String oldValue;
    @Option(displayName="Regex", description="Default false. If true, `oldValue` will be interpreted as a Regular Expression, and capture group contents will be available in `newValue`.", required=false)
    @Nullable
    private final Boolean regex;

    public String getDisplayName() {
        return "Change XML attribute";
    }

    public String getDescription() {
        return "Alters XML attribute value on a specified element.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (new XPathMatcher(ChangeTagAttribute.this.elementName).matches(this.getCursor())) {
                    t = t.withAttributes(ListUtils.map(t.getAttributes(), this::visitChosenElementAttribute));
                }
                return t;
            }

            public Xml.Attribute visitChosenElementAttribute(Xml.Attribute attribute) {
                if (!attribute.getKeyAsString().equals(ChangeTagAttribute.this.attributeName)) {
                    return attribute;
                }
                String stringValue = attribute.getValueAsString();
                if (ChangeTagAttribute.this.oldValue != null) {
                    if (Boolean.TRUE.equals(ChangeTagAttribute.this.regex) && !Pattern.matches(ChangeTagAttribute.this.oldValue, stringValue)) {
                        return attribute;
                    }
                    if ((ChangeTagAttribute.this.regex == null || Boolean.FALSE.equals(ChangeTagAttribute.this.regex)) && !stringValue.startsWith(ChangeTagAttribute.this.oldValue)) {
                        return attribute;
                    }
                }
                if (ChangeTagAttribute.this.newValue == null) {
                    return null;
                }
                String changedValue = ChangeTagAttribute.this.oldValue != null ? (Boolean.TRUE.equals(ChangeTagAttribute.this.regex) ? stringValue.replaceAll(ChangeTagAttribute.this.oldValue, ChangeTagAttribute.this.newValue) : stringValue.replace(ChangeTagAttribute.this.oldValue, ChangeTagAttribute.this.newValue)) : ChangeTagAttribute.this.newValue;
                return attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), changedValue));
            }
        };
    }

    @Generated
    public ChangeTagAttribute(String elementName, String attributeName, @Nullable String newValue, @Nullable String oldValue, @Nullable Boolean regex) {
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.regex = regex;
    }

    @Generated
    public String getElementName() {
        return this.elementName;
    }

    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }

    @Nullable
    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    @Generated
    public String getOldValue() {
        return this.oldValue;
    }

    @Nullable
    @Generated
    public Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeTagAttribute(elementName=" + this.getElementName() + ", attributeName=" + this.getAttributeName() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", regex=" + this.getRegex() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagAttribute)) {
            return false;
        }
        ChangeTagAttribute other = (ChangeTagAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        return !(this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        return result;
    }
}

