/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class FindNamespacePrefix
extends Recipe {
    @Option(displayName="Namespace prefix", description="The Namespace Prefix to find.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespacePrefix;
    @Option(displayName="XPath", description="An XPath expression used to find namespace URIs.", example="/dependencies/dependency", required=false)
    @Nullable
    private final String xPath;

    public String getDisplayName() {
        return "Find XML namespace prefixes";
    }

    public String getDescription() {
        return "Find XML namespace prefixes, optionally restricting the search by a XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher matcher = StringUtils.isBlank((String)this.xPath) ? null : new XPathMatcher(this.xPath);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
                if (tag.getNamespaces().containsKey(FindNamespacePrefix.this.namespacePrefix) && (matcher == null || matcher.matches(this.getCursor()))) {
                    t = (Xml.Tag)SearchResult.found((Tree)t);
                }
                return t;
            }
        };
    }

    public static Set<Xml.Tag> find(Xml x, final String namespacePrefix, @Nullable String xPath) {
        final XPathMatcher matcher = StringUtils.isBlank((String)xPath) ? null : new XPathMatcher(xPath);
        HashSet<Xml.Tag> ts = new HashSet<Xml.Tag>();
        new XmlVisitor<Set<Xml.Tag>>(){

            @Override
            public Xml visitTag(Xml.Tag tag, Set<Xml.Tag> ts) {
                if (tag.getNamespaces().containsKey(namespacePrefix) && (matcher == null || matcher.matches(this.getCursor()))) {
                    ts.add(tag);
                }
                return super.visitTag(tag, ts);
            }
        }.visit(x, ts);
        return ts;
    }

    @Generated
    public FindNamespacePrefix(String namespacePrefix, @Nullable String xPath) {
        this.namespacePrefix = namespacePrefix;
        this.xPath = xPath;
    }

    @Generated
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Nullable
    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindNamespacePrefix(namespacePrefix=" + this.getNamespacePrefix() + ", xPath=" + this.getXPath() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindNamespacePrefix)) {
            return false;
        }
        FindNamespacePrefix other = (FindNamespacePrefix)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespacePrefix = this.getNamespacePrefix();
        String other$namespacePrefix = other.getNamespacePrefix();
        if (this$namespacePrefix == null ? other$namespacePrefix != null : !this$namespacePrefix.equals(other$namespacePrefix)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        return !(this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindNamespacePrefix;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespacePrefix = this.getNamespacePrefix();
        result = result * 59 + ($namespacePrefix == null ? 43 : $namespacePrefix.hashCode());
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        return result;
    }
}

