/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.tree.Xml;

public class XPathMatcher {
    private static final Pattern PATTERN = Pattern.compile("([-\\w]+)\\[(@)?([-\\w]+)='([-\\w.]+)']");
    private final String expression;
    private final boolean startsWithSlash;
    private final boolean startsWithDoubleSlash;
    private final String[] parts;

    public XPathMatcher(String expression) {
        this.expression = expression;
        this.startsWithSlash = expression.startsWith("/");
        this.startsWithDoubleSlash = expression.startsWith("//");
        this.parts = expression.substring(this.startsWithDoubleSlash ? 2 : (this.startsWithSlash ? 1 : 0)).split("/");
    }

    public boolean matches(Cursor cursor) {
        ArrayList<Xml.Tag> path = new ArrayList<Xml.Tag>();
        for (Cursor c = cursor; c != null; c = c.getParent()) {
            if (!(c.getValue() instanceof Xml.Tag)) continue;
            path.add((Xml.Tag)c.getValue());
        }
        if (this.startsWithDoubleSlash || !this.startsWithSlash) {
            int pathIndex = 0;
            int i = this.parts.length - 1;
            while (i >= 0) {
                String part = this.parts[i];
                if (part.startsWith("@")) {
                    if (!(cursor.getValue() instanceof Xml.Attribute && ((Xml.Attribute)cursor.getValue()).getKeyAsString().equals(part.substring(1)) || "*".equals(part.substring(1)))) {
                        return false;
                    }
                    --pathIndex;
                } else if (path.size() < i + 1 || !((Xml.Tag)path.get(pathIndex)).getName().equals(part) && !"*".equals(part)) {
                    return false;
                }
                --i;
                ++pathIndex;
            }
            return this.startsWithSlash || path.size() - pathIndex <= 1;
        }
        Collections.reverse(path);
        if (this.expression.contains("//") && Arrays.stream(this.parts).anyMatch(StringUtils::isBlank)) {
            int blankPartIndex = Arrays.asList(this.parts).indexOf("");
            int doubleSlashIndex = this.expression.indexOf("//");
            if (path.size() > blankPartIndex && path.size() >= this.parts.length - 1) {
                String newExpression = Objects.equals(((Xml.Tag)path.get(blankPartIndex)).getName(), this.parts[blankPartIndex + 1]) ? String.format("%s/%s", this.expression.substring(0, doubleSlashIndex), this.expression.substring(doubleSlashIndex + 2)) : String.format("%s/%s/%s", this.expression.substring(0, doubleSlashIndex), ((Xml.Tag)path.get(blankPartIndex)).getName(), this.expression.substring(doubleSlashIndex + 2));
                return new XPathMatcher(newExpression).matches(cursor);
            }
        }
        if (this.parts.length > path.size() + 1) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            String partName;
            Matcher matcher;
            Xml.Tag tag;
            String part = this.parts[i];
            Xml.Tag tag2 = tag = i < path.size() ? (Xml.Tag)path.get(i) : null;
            if (tag != null && part.endsWith("]") && (matcher = PATTERN.matcher(part)).matches()) {
                boolean matchCondition;
                String name = matcher.group(1);
                boolean isAttribute = Objects.equals(matcher.group(2), "@");
                String selector = matcher.group(3);
                String value = matcher.group(4);
                boolean bl = matchCondition = isAttribute ? tag.getAttributes().stream().anyMatch(a -> a.getKeyAsString().equals(selector) && a.getValueAsString().equals(value)) : FindTags.find(tag, selector).stream().anyMatch(t -> t.getValue().map(v -> v.equals(value)).orElse(false));
                if (!matchCondition) {
                    return false;
                }
                partName = name;
            } else {
                partName = part;
            }
            if (part.startsWith("@")) {
                return cursor.getValue() instanceof Xml.Attribute && (((Xml.Attribute)cursor.getValue()).getKeyAsString().equals(part.substring(1)) || "*".equals(part.substring(1)));
            }
            if (path.size() >= i + 1 && (tag == null || tag.getName().equals(partName) || "*".equals(part))) continue;
            return false;
        }
        return cursor.getValue() instanceof Xml.Tag && path.size() == this.parts.length;
    }
}

