/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class NormalizeTabsOrSpaces
extends Recipe {
    public String getDisplayName() {
        return "Normalize to tabs or spaces";
    }

    public String getDescription() {
        return "Consistently use either tabs or spaces in indentation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends XmlIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)document.getStyle(TabsAndIndentsStyle.class);
            if (style == null) {
                style = TabsAndIndentsStyle.DEFAULT;
            }
            return (Xml.Document)new NormalizeTabsOrSpacesVisitor(style).visitNonNull(document, ctx);
        }
    }
}

