/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openrewrite.Tree;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.search.FindIndentXmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class AutoFormatVisitor<P>
extends XmlVisitor<P> {
    private final Xml.Tag[] scope;
    private final FindIndentXmlVisitor<P> findIndent = new FindIndentXmlVisitor(0);

    public AutoFormatVisitor(Xml.Tag ... scope) {
        this.scope = scope;
    }

    @Override
    public Xml visitDocument(Xml.Document document, P p) {
        this.findIndent.visit(document, p);
        return super.visitDocument(document, p);
    }

    public Xml preVisit(Xml tree, P p) {
        Xml x;
        block5: {
            String prefix;
            block6: {
                x = (Xml)super.preVisit((Tree)tree, p);
                if (x == null || !(prefix = x.getPrefix()).contains("\n")) break block5;
                if (this.scope.length == 0) break block6;
                if (!Arrays.stream(this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) break block5;
            }
            int indentMultiple = (int)this.getCursor().getPathAsStream().filter(Xml.Tag.class::isInstance).count() - 1;
            if (this.getCursor().getValue() instanceof Xml.Attribute) {
                ++indentMultiple;
            }
            int indentToUse = this.findIndent.getMostCommonIndent() > 0 ? this.findIndent.getMostCommonIndent() : 4;
            String shiftedPrefix = prefix.substring(0, prefix.lastIndexOf(10) + 1) + IntStream.range(0, indentMultiple * indentToUse).mapToObj(n -> this.findIndent.isIndentedWithSpaces() ? " " : "\t").collect(Collectors.joining(""));
            if (!shiftedPrefix.equals(prefix)) {
                return x.withPrefix(shiftedPrefix);
            }
        }
        return x;
    }
}

