/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Comparator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.AutoFormatVisitor;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class AddToTagVisitor<P>
extends XmlVisitor<P> {
    private final Xml.Tag scope;
    private final Xml.Tag tagToAdd;
    @Nullable
    private final Comparator<Xml.Tag> tagComparator;

    public AddToTagVisitor(Xml.Tag scope, Xml.Tag tagToAdd) {
        this(scope, tagToAdd, null);
    }

    public AddToTagVisitor(Xml.Tag scope, Xml.Tag tagToAdd, @Nullable Comparator<Xml.Tag> tagComparator) {
        this.scope = scope;
        this.tagToAdd = tagToAdd;
        this.tagComparator = tagComparator;
    }

    @Override
    public Xml visitTag(Xml.Tag t, P p) {
        if (this.scope.isScope(t)) {
            Xml.Tag formattedTagToAdd;
            boolean formatRequested = false;
            if (t.getClosing() == null) {
                t = t.withClosing(new Xml.Tag.Closing(Tree.randomId(), "\n", Markers.EMPTY, t.getName(), "")).withBeforeTagDelimiterPrefix("");
                this.doAfterVisit(new AutoFormatVisitor(t));
                formatRequested = true;
            }
            if (!t.getClosing().getPrefix().contains("\n")) {
                t = t.withClosing(t.getClosing().withPrefix("\n"));
            }
            if (!(formattedTagToAdd = this.tagToAdd).getPrefix().contains("\n")) {
                formattedTagToAdd = formattedTagToAdd.withPrefix("\n");
            }
            ArrayList<Xml.Tag> content = t.getContent() == null ? new ArrayList<Xml.Tag>() : new ArrayList<Xml.Tag>(t.getChildren());
            content.add(formattedTagToAdd);
            if (this.tagComparator != null) {
                content.sort(this.tagComparator);
            }
            t = t.withContent(content);
            if (!formatRequested) {
                this.doAfterVisit(new AutoFormatVisitor(formattedTagToAdd));
            }
        }
        return super.visitTag(t, p);
    }
}

