/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.security;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.security.IsOwaspSuppressionsFile;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class RemoveOwaspSuppressions
extends Recipe {
    public String getDisplayName() {
        return "Remove out-of-date OWASP suppressions";
    }

    public String getDescription() {
        return "Remove all OWASP suppressions with a suppression end date in the past, as these are no longer valid. For use with the OWASP `dependency-check` tool. More details on OWASP suppression files: https://jeremylong.github.io/DependencyCheck/general/suppression.html.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemoveSuppressionsVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsOwaspSuppressionsFile();
    }

    @NonNull
    public String toString() {
        return "RemoveOwaspSuppressions()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOwaspSuppressions)) {
            return false;
        }
        RemoveOwaspSuppressions other = (RemoveOwaspSuppressions)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveOwaspSuppressions;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static class RemoveSuppressionsVisitor
    extends XmlIsoVisitor<ExecutionContext> {
        private RemoveSuppressionsVisitor() {
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml t = super.visitTag(tag, ctx);
            if (!new XPathMatcher("/suppressions").matches(this.getCursor()) || ((Xml.Tag)t).getContent() == null) {
                return t;
            }
            return ((Xml.Tag)t).withContent(ListUtils.flatMap(((Xml.Tag)t).getContent(), (i, c) -> this.isPastDueSuppression((Content)c) ? null : c));
        }

        private boolean isPastDueSuppression(Content content) {
            Xml.Tag child;
            if (content instanceof Xml.Tag && (child = (Xml.Tag)content).getName().equals("suppress")) {
                for (Xml.Attribute attribute : child.getAttributes()) {
                    if (!attribute.getKeyAsString().equals("until")) continue;
                    String maybeDate = attribute.getValueAsString();
                    if (maybeDate.endsWith("Z")) {
                        maybeDate = maybeDate.substring(0, maybeDate.length() - 1);
                    }
                    try {
                        LocalDate date = LocalDate.parse(maybeDate);
                        if (!date.isBefore(LocalDate.now().minus(1L, ChronoUnit.DAYS))) continue;
                        return true;
                    }
                    catch (DateTimeParseException e) {
                        return false;
                    }
                }
            }
            return false;
        }
    }
}

