/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.internal;

import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class XmlPrinter<P>
extends XmlVisitor<PrintOutputCapture<P>> {
    @Override
    public Xml visitDocument(Xml.Document document, PrintOutputCapture<P> p) {
        p.out.append(document.getPrefix());
        this.visitMarkers(document.getMarkers(), p);
        document = (Xml.Document)super.visitDocument(document, p);
        p.out.append(document.getEof());
        return document;
    }

    @Override
    public Xml visitProlog(Xml.Prolog prolog, PrintOutputCapture<P> p) {
        p.out.append(prolog.getPrefix());
        this.visitMarkers(prolog.getMarkers(), p);
        return super.visitProlog(prolog, p);
    }

    @Override
    public Xml visitXmlDecl(Xml.XmlDecl xmlDecl, PrintOutputCapture<P> p) {
        this.visitMarkers(xmlDecl.getMarkers(), p);
        p.out.append("<?").append(xmlDecl.getName());
        this.visit(xmlDecl.getAttributes(), p);
        p.out.append(xmlDecl.getBeforeTagDelimiterPrefix()).append("?>");
        return xmlDecl;
    }

    @Override
    public Xml visitTag(Xml.Tag tag, PrintOutputCapture<P> p) {
        p.out.append(tag.getPrefix());
        this.visitMarkers(tag.getMarkers(), p);
        p.out.append('<').append(tag.getName());
        this.visit(tag.getAttributes(), p);
        p.out.append(tag.getBeforeTagDelimiterPrefix());
        if (tag.getClosing() == null) {
            p.out.append("/>");
        } else {
            p.out.append('>');
            this.visit(tag.getContent(), p);
            p.out.append(tag.getClosing().getPrefix()).append("</").append(tag.getClosing().getName()).append(tag.getClosing().getBeforeTagDelimiterPrefix()).append(">");
        }
        return tag;
    }

    @Override
    public Xml visitAttribute(Xml.Attribute attribute, PrintOutputCapture<P> p) {
        char valueDelim = Xml.Attribute.Value.Quote.Double.equals((Object)attribute.getValue().getQuote()) ? (char)'\"' : '\'';
        p.out.append(attribute.getPrefix());
        this.visitMarkers(attribute.getMarkers(), p);
        p.out.append(attribute.getKey().getPrefix()).append(attribute.getKeyAsString()).append(attribute.getBeforeEquals()).append('=').append(attribute.getValue().getPrefix()).append(valueDelim).append(attribute.getValueAsString()).append(valueDelim);
        return attribute;
    }

    @Override
    public Xml visitComment(Xml.Comment comment, PrintOutputCapture<P> p) {
        p.out.append(comment.getPrefix());
        this.visitMarkers(comment.getMarkers(), p);
        p.out.append("<!--").append(comment.getText()).append("-->");
        return comment;
    }

    @Override
    public Xml visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, PrintOutputCapture<P> p) {
        p.out.append(processingInstruction.getPrefix());
        this.visitMarkers(processingInstruction.getMarkers(), p);
        p.out.append("<?").append(processingInstruction.getName());
        this.visit(processingInstruction.getProcessingInstructions(), p);
        p.out.append(processingInstruction.getBeforeTagDelimiterPrefix()).append("?>");
        return processingInstruction;
    }

    @Override
    public Xml visitCharData(Xml.CharData charData, PrintOutputCapture<P> p) {
        p.out.append(charData.getPrefix());
        this.visitMarkers(charData.getMarkers(), p);
        if (charData.isCdata()) {
            p.out.append("<![CDATA[").append(charData.getText()).append("]]>");
        } else {
            p.out.append(charData.getText());
        }
        p.out.append(charData.getAfterText());
        return charData;
    }

    @Override
    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, PrintOutputCapture<P> p) {
        p.out.append(docTypeDecl.getPrefix());
        this.visitMarkers(docTypeDecl.getMarkers(), p);
        p.out.append("<!DOCTYPE");
        this.visit(docTypeDecl.getName(), p);
        this.visit(docTypeDecl.getExternalId(), p);
        this.visit(docTypeDecl.getInternalSubset(), p);
        if (docTypeDecl.getExternalSubsets() != null) {
            p.out.append(docTypeDecl.getExternalSubsets().getPrefix()).append('[');
            this.visit(docTypeDecl.getExternalSubsets().getElements(), p);
            p.out.append(']');
        }
        p.out.append(docTypeDecl.getBeforeTagDelimiterPrefix());
        p.out.append('>');
        return docTypeDecl;
    }

    @Override
    public Xml visitElement(Xml.Element element, PrintOutputCapture<P> p) {
        p.out.append(element.getPrefix());
        this.visitMarkers(element.getMarkers(), p);
        this.visit(element.getSubset(), p);
        p.out.append(element.getBeforeTagDelimiterPrefix());
        return element;
    }

    @Override
    public Xml visitIdent(Xml.Ident ident, PrintOutputCapture<P> p) {
        p.out.append(ident.getPrefix());
        this.visitMarkers(ident.getMarkers(), p);
        p.out.append(ident.getName());
        return ident;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("<!--~~").append(description == null ? "" : "(" + description + ")~~").append(">-->");
        }
        return (M)marker;
    }
}

