/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.xml.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Autodetect detect(List<Xml.Document> xmls) {
        IndentStatistics indentStatistics = new IndentStatistics();
        GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        for (Xml.Document xml : xmls) {
            new FindIndentXmlVisitor().visit(xml, indentStatistics);
            new FindLineFormatJavaVisitor().visit((Tree)xml, generalFormatStatistics);
        }
        return new Autodetect(Tree.randomId(), Arrays.asList(indentStatistics.getTabsAndIndentsStyle(), generalFormatStatistics.getFormatStyle()));
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }

    private static class FindIndentXmlVisitor
    extends XmlVisitor<IndentStatistics> {
        private FindIndentXmlVisitor() {
        }

        public Xml preVisit(Xml tree, IndentStatistics stats) {
            String prefix = tree.getPrefix();
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int indent = 0;
                for (char c2 : chars = prefix.toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        indent = 0;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    ++indent;
                }
                stats.indentFrequencies.merge(indent, 1L, Long::sum);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    stats.linesWithSpaceIndents++;
                } else {
                    stats.linesWithTabIndents++;
                }
            }
            return tree;
        }
    }

    private static class FindLineFormatJavaVisitor
    extends XmlVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        @Nullable
        public Xml visit(@Nullable Tree tree, GeneralFormatStatistics stats) {
            if (tree instanceof Xml) {
                String prefix = ((Xml)tree).getPrefix();
                char[] chars = prefix.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c != '\n' && c != '\r' || c != '\n') continue;
                    if (i == 0 || chars[i - 1] != '\r') {
                        stats.linesWithLFNewLines++;
                        continue;
                    }
                    stats.linesWithCRLFNewLines++;
                }
            }
            return (Xml)super.visit(tree, (Object)stats);
        }
    }

    private static class IndentStatistics {
        private final Map<Integer, Long> indentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;

        private IndentStatistics() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            Map.Entry<Integer, Long> i1 = null;
            Map.Entry<Integer, Long> i2 = null;
            for (Map.Entry<Integer, Long> sample : this.indentFrequencies.entrySet()) {
                if (sample.getKey() == 0) continue;
                if (i1 == null || (Long)i1.getValue() < sample.getValue() && sample.getKey() % i1.getKey() != 0) {
                    i1 = sample;
                    continue;
                }
                if (i2 != null && ((Long)i2.getValue() >= sample.getValue() || sample.getKey() % i2.getKey() == 0)) continue;
                i2 = sample;
            }
            int indent1 = i1 == null ? 2 : (Integer)i1.getKey();
            int indent2 = i2 == null ? indent1 : (Integer)i2.getKey();
            int indent = Math.min(indent1, indent2);
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent);
        }
    }
}

