/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.maven;

import org.openrewrite.Tree;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlSourceVisitor;
import org.openrewrite.xml.maven.Dependency;
import org.openrewrite.xml.maven.MavenPom;
import org.openrewrite.xml.tree.Xml;

public class ReadPom
extends XmlSourceVisitor<MavenPom> {
    private final XPathMatcher dependencyMatcher = new XPathMatcher("/project/dependencies/dependency");
    private final XPathMatcher propertyMatcher = new XPathMatcher("/project/properties/*");

    public ReadPom() {
        this.setCursoringOn();
    }

    public MavenPom defaultTo(Tree t) {
        return new MavenPom();
    }

    public MavenPom reduce(MavenPom r1, MavenPom r2) {
        return r1.merge(r2);
    }

    @Override
    public MavenPom visitTag(Xml.Tag tag) {
        if (this.dependencyMatcher.matches(this.getCursor())) {
            return new MavenPom().withDependency(new Dependency(tag.getChildValue("groupId"), tag.getChildValue("artifactId"), tag.getChildValue("version"), tag.getChildValue("scope")));
        }
        if (this.propertyMatcher.matches(this.getCursor())) {
            return tag.getValue().map(value -> new MavenPom().withProperty(tag.getName(), (String)value)).orElseGet(MavenPom::new);
        }
        return (MavenPom)super.visitTag(tag);
    }
}

