/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jspecify.annotations.Nullable;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.internal.grammar.TomlParser;
import org.openrewrite.toml.internal.grammar.TomlParserBaseVisitor;
import org.openrewrite.toml.marker.ArrayTable;
import org.openrewrite.toml.marker.InlineTable;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlRightPadded;
import org.openrewrite.toml.tree.TomlType;
import org.openrewrite.toml.tree.TomlValue;

public class TomlParserVisitor
extends TomlParserBaseVisitor<Toml> {
    private final Path path;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    private int cursor = 0;
    private int codePointCursor = 0;
    private static final DateTimeFormatter RFC3339_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).parseLenient().appendOffsetId().parseStrict().toFormatter();

    public TomlParserVisitor(Path path, @Nullable FileAttributes fileAttributes, EncodingDetectingInputStream source) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source.readFully();
        this.charset = source.getCharset();
        this.charsetBomMarked = source.isCharsetBomMarked();
    }

    public Toml visitChildren(RuleNode node) {
        Toml result = (Toml)this.defaultResult();
        int n = node.getChildCount();
        for (int i = 0; i < n && this.shouldVisitNextChild(node, result); ++i) {
            ParseTree c = node.getChild(i);
            if (c instanceof TomlParser.CommentContext) continue;
            Toml childResult = (Toml)c.accept((ParseTreeVisitor)this);
            result = (Toml)this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public Toml.Document visitDocument(TomlParser.DocumentContext ctx) {
        if (!ctx.children.isEmpty() && ctx.children.get(0) instanceof TerminalNode && ((TerminalNode)ctx.children.get(0)).getSymbol().getType() == -1) {
            new Toml.Document(Tree.randomId(), this.path, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, this.fileAttributes, Collections.emptyList(), Space.EMPTY);
        }
        ArrayList<TomlValue> elements = new ArrayList<TomlValue>();
        for (TomlParser.ExpressionContext expr : ctx.expression()) {
            TomlValue element = (TomlValue)this.visit((ParseTree)expr);
            if (element == null) continue;
            elements.add(element);
        }
        return new Toml.Document(Tree.randomId(), this.path, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, this.fileAttributes, elements, Space.format(this.source, this.cursor, this.source.length()));
    }

    @Override
    public Toml.Identifier visitKey(TomlParser.KeyContext ctx) {
        return (Toml.Identifier)super.visitKey(ctx);
    }

    @Override
    public Toml.Identifier visitSimpleKey(TomlParser.SimpleKeyContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Toml.Identifier(Tree.randomId(), (Space)prefix, Markers.EMPTY, c.getText(), c.getText()));
    }

    @Override
    public Toml.Identifier visitDottedKey(TomlParser.DottedKeyContext ctx) {
        Space prefix = this.prefix(ctx);
        StringBuilder text = new StringBuilder();
        StringBuilder key = new StringBuilder();
        for (ParseTree child : ctx.children) {
            Space space = this.sourceBefore(child.getText());
            text.append(space.getWhitespace()).append(child.getText());
            key.append(child.getText());
        }
        return new Toml.Identifier(Tree.randomId(), prefix, Markers.EMPTY, text.toString(), key.toString());
    }

    @Override
    public Toml.KeyValue visitKeyValue(TomlParser.KeyValueContext ctx) {
        return this.convert(ctx, (c, prefix) -> new Toml.KeyValue(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlRightPadded.build(this.visitKey(c.key())).withAfter(this.sourceBefore("=")), (Toml)this.visitValue(c.value())));
    }

    @Override
    public Toml visitString(TomlParser.StringContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String string = c.getText();
            return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.String, string, string.substring(1, string.length() - 1));
        });
    }

    @Override
    public Toml visitInteger(TomlParser.IntegerContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String rawNumber = c.getText();
            String number = rawNumber.replace("_", "");
            Long numberValue = rawNumber.startsWith("0x") ? Long.parseLong(number.substring(2), 16) : (rawNumber.startsWith("0o") ? Long.parseLong(number.substring(2), 8) : (rawNumber.startsWith("0b") ? Long.parseLong(number.substring(2), 2) : Long.parseLong(number)));
            return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.Integer, rawNumber, numberValue);
        });
    }

    @Override
    public Toml visitFloatingPoint(TomlParser.FloatingPointContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String rawNumber = c.getText();
            if (c.NAN() != null) {
                return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.Float, rawNumber, Double.NaN);
            }
            if (c.INF() != null) {
                return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.Float, rawNumber, this.source.charAt(this.cursor) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            String number = rawNumber.replace("_", "");
            Double numberValue = Double.parseDouble(number);
            return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.Float, rawNumber, numberValue);
        });
    }

    @Override
    public Toml visitBool(TomlParser.BoolContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String bool = c.getText();
            Boolean boolValue = Boolean.parseBoolean(bool);
            return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.Boolean, bool, boolValue);
        });
    }

    @Override
    public Toml visitDateTime(TomlParser.DateTimeContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            String dateTime = c.getText();
            if (c.OFFSET_DATE_TIME() != null) {
                return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.OffsetDateTime, dateTime, dateTime.contains("T") ? OffsetDateTime.parse(dateTime) : OffsetDateTime.parse(dateTime, RFC3339_OFFSET_DATE_TIME));
            }
            if (c.LOCAL_DATE_TIME() != null) {
                return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.LocalDateTime, dateTime, LocalDateTime.parse(dateTime));
            }
            if (c.LOCAL_DATE() != null) {
                return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.LocalDate, dateTime, LocalDate.parse(dateTime));
            }
            return new Toml.Literal(Tree.randomId(), (Space)prefix, Markers.EMPTY, TomlType.Primitive.LocalTime, dateTime, LocalTime.parse(dateTime));
        });
    }

    @Override
    public Toml visitArray(TomlParser.ArrayContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("[");
            List<TomlParser.ValueContext> values = c.value();
            ArrayList<TomlRightPadded<Toml>> elements = new ArrayList<TomlRightPadded<Toml>>();
            for (int i = 0; i < values.size(); ++i) {
                Toml element = (Toml)this.visit((ParseTree)values.get(i));
                if (i == values.size() - 1) {
                    if (this.positionOfNext(",", Character.valueOf(']')) >= 0) {
                        elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore(",")));
                        elements.add(TomlRightPadded.build(new Toml.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("]")));
                        continue;
                    }
                    elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore("]")));
                    continue;
                }
                elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore(",")));
            }
            if (values.isEmpty()) {
                elements.add(TomlRightPadded.build(new Toml.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("]")));
            }
            return new Toml.Array(Tree.randomId(), (Space)prefix, Markers.EMPTY, (List<TomlRightPadded<Toml>>)elements);
        });
    }

    @Override
    public Toml visitInlineTable(TomlParser.InlineTableContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("{");
            List<TomlParser.KeyValueContext> values = c.keyValue();
            ArrayList<TomlRightPadded<Toml>> elements = new ArrayList<TomlRightPadded<Toml>>();
            for (int i = 0; i < values.size(); ++i) {
                Toml element = (Toml)this.visit((ParseTree)values.get(i));
                if (i == values.size() - 1) {
                    if (this.positionOfNext(",", Character.valueOf('}')) >= 0) {
                        elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore(",")));
                        elements.add(TomlRightPadded.build(new Toml.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore("}")));
                        continue;
                    }
                    elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore("}")));
                    continue;
                }
                elements.add(TomlRightPadded.build(element).withAfter(this.sourceBefore(",")));
            }
            return new Toml.Table(Tree.randomId(), (Space)prefix, Markers.build(Collections.singletonList(new InlineTable(Tree.randomId()))), null, (List<TomlRightPadded<Toml>>)elements);
        });
    }

    @Override
    public Toml visitStandardTable(TomlParser.StandardTableContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("[");
            Toml.Identifier tableName = this.visitKey(c.key());
            TomlRightPadded<Toml.Identifier> nameRightPadded = TomlRightPadded.build(tableName).withAfter(this.sourceBefore("]"));
            List<TomlParser.KeyValueContext> values = c.keyValue();
            ArrayList<TomlRightPadded<Toml>> elements = new ArrayList<TomlRightPadded<Toml>>();
            for (TomlParser.KeyValueContext value : values) {
                elements.add(TomlRightPadded.build((Toml)this.visit((ParseTree)value)));
            }
            return new Toml.Table(Tree.randomId(), (Space)prefix, Markers.EMPTY, nameRightPadded, (List<TomlRightPadded<Toml>>)elements);
        });
    }

    @Override
    public Toml visitArrayTable(TomlParser.ArrayTableContext ctx) {
        return this.convert(ctx, (c, prefix) -> {
            this.sourceBefore("[[");
            Toml.Identifier tableName = this.visitKey(c.key());
            TomlRightPadded<Toml.Identifier> nameRightPadded = TomlRightPadded.build(tableName).withAfter(this.sourceBefore("]]"));
            List<TomlParser.KeyValueContext> values = c.keyValue();
            ArrayList<TomlRightPadded<Toml>> elements = new ArrayList<TomlRightPadded<Toml>>();
            for (TomlParser.KeyValueContext value : values) {
                elements.add(TomlRightPadded.build((Toml)this.visit((ParseTree)value)));
            }
            return new Toml.Table(Tree.randomId(), (Space)prefix, Markers.build(Collections.singletonList(new ArrayTable(Tree.randomId()))), nameRightPadded, (List<TomlRightPadded<Toml>>)elements);
        });
    }

    private Space prefix(ParserRuleContext ctx) {
        return this.prefix(ctx.getStart());
    }

    private Space prefix(Token token) {
        int start = token.getStartIndex();
        if (start < this.codePointCursor) {
            return Space.EMPTY;
        }
        return Space.format(this.source, this.cursor, this.advanceCursor(start));
    }

    public int advanceCursor(int newCodePointIndex) {
        if (newCodePointIndex <= this.codePointCursor) {
            return this.cursor;
        }
        this.cursor = this.source.offsetByCodePoints(this.cursor, newCodePointIndex - this.codePointCursor);
        this.codePointCursor = newCodePointIndex;
        return this.cursor;
    }

    private <C extends ParserRuleContext, T> T convert(C ctx, BiFunction<C, Space, T> conversion) {
        T t = conversion.apply(ctx, this.prefix(ctx));
        if (ctx.getStop() != null) {
            this.advanceCursor(ctx.getStop().getStopIndex() + 1);
        }
        return t;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim, null);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        Space space = Space.format(this.source, this.cursor, delimIndex);
        this.advanceCursor(this.codePointCursor + Character.codePointCount(this.source, this.cursor, delimIndex) + untilDelim.length());
        return space;
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.charAt(delimIndex) == '#') {
                inSingleLineComment = true;
                ++delimIndex;
            }
            if (inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }
}

