/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlKey;

public class TomlPathMatcher {
    private final List<PathSegment> segments;

    public TomlPathMatcher(String path) {
        this.segments = this.parsePath(path);
    }

    public boolean matches(Cursor cursor) {
        List<String> actualPath = this.buildPath(cursor);
        return this.matchesPath(actualPath);
    }

    private boolean matchesPath(List<String> actualPath) {
        if (this.segments.isEmpty()) {
            return actualPath.isEmpty();
        }
        int segmentIndex = 0;
        int pathIndex = 0;
        while (segmentIndex < this.segments.size() && pathIndex < actualPath.size()) {
            PathSegment segment = this.segments.get(segmentIndex);
            if (segment.isDoubleWildcard) {
                if (segmentIndex == this.segments.size() - 1) {
                    return true;
                }
                PathSegment nextSegment = this.segments.get(segmentIndex + 1);
                boolean foundMatch = false;
                for (int i = pathIndex; i <= actualPath.size(); ++i) {
                    if (i >= actualPath.size() || !nextSegment.matches(actualPath.get(i))) continue;
                    segmentIndex += 2;
                    pathIndex = i + 1;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                return false;
            }
            if (segment.matches(actualPath.get(pathIndex))) {
                ++segmentIndex;
                ++pathIndex;
                continue;
            }
            return false;
        }
        return segmentIndex == this.segments.size() && pathIndex == actualPath.size();
    }

    private List<String> buildPath(Cursor cursor) {
        ArrayList<String> path = new ArrayList<String>();
        for (Cursor current = cursor; current != null; current = current.getParent()) {
            Toml.KeyValue kv;
            TomlKey key;
            Object value = current.getValue();
            if (!(value instanceof Toml.KeyValue) || !((key = (kv = (Toml.KeyValue)value).getKey()) instanceof Toml.Identifier)) continue;
            String keyName = ((Toml.Identifier)key).getName();
            for (Cursor parent = current.getParent(); parent != null; parent = parent.getParent()) {
                Object parentValue = parent.getValue();
                if (!(parentValue instanceof Toml.Table)) continue;
                Toml.Table table = (Toml.Table)parentValue;
                if (table.getName() == null) break;
                String tableName = table.getName().getName();
                String[] parts = tableName.split("\\.");
                for (int i = parts.length - 1; i >= 0; --i) {
                    path.add(0, parts[i].trim());
                }
                break;
            }
            path.add(keyName);
            return path;
        }
        return path;
    }

    private List<PathSegment> parsePath(String path) {
        if ((path = path.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        if (path.startsWith("[") && path.endsWith("]")) {
            path = path.substring(1, path.length() - 1);
        }
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '\"' || path.charAt(i) == '\'') {
                char quote = path.charAt(i);
                int end = path.indexOf(quote, i + 1);
                if (end != -1) {
                    parts.add(path.substring(i + 1, end));
                    i = end + 1;
                    if (i >= path.length() || path.charAt(i) != '.') continue;
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            int nextDot = path.indexOf(46, i);
            if (nextDot == -1) {
                parts.add(path.substring(i).trim());
                break;
            }
            parts.add(path.substring(i, nextDot).trim());
            i = nextDot + 1;
        }
        ArrayList<PathSegment> result = new ArrayList<PathSegment>();
        Iterator iterator = parts.iterator();
        block11: while (iterator.hasNext()) {
            String part;
            switch (part = (String)iterator.next()) {
                case "": {
                    continue block11;
                }
                case "**": {
                    result.add(new PathSegment(null, false, true));
                    continue block11;
                }
                case "*": {
                    result.add(new PathSegment(null, true, false));
                    continue block11;
                }
            }
            result.add(new PathSegment(part, false, false));
        }
        return result;
    }

    private static class PathSegment {
        final @Nullable String literal;
        final boolean isSingleWildcard;
        final boolean isDoubleWildcard;
        final @Nullable Pattern pattern;

        PathSegment(@Nullable String literal, boolean isSingleWildcard, boolean isDoubleWildcard) {
            this.literal = literal;
            this.isSingleWildcard = isSingleWildcard;
            this.isDoubleWildcard = isDoubleWildcard;
            if (literal != null && !isSingleWildcard && !isDoubleWildcard) {
                String regex = literal.replace("*", ".*").replace("?", ".");
                this.pattern = Pattern.compile("^" + regex + "$");
            } else {
                this.pattern = null;
            }
        }

        boolean matches(String key) {
            if (this.isSingleWildcard || this.isDoubleWildcard) {
                return true;
            }
            if (this.pattern != null) {
                return this.pattern.matcher(key).matches();
            }
            return this.literal != null && this.literal.equals(key);
        }
    }
}

