/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.toml.TableRowMatcher;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlValue;

public final class DeleteTableRow
extends Recipe {
    @Option(displayName="Table name", description="The name of the TOML array table to delete (e.g., 'package.contributors').", example="package.contributors")
    private final String tableName;
    @Option(displayName="Key", description="The key within a table row to match on.", example="name")
    private final String identifyingKey;
    @Option(displayName="Value", description="The value to match. Can be a regular expression if useRegex is true.", example="example-*")
    private final String identifyingValue;
    @Option(displayName="Use regex", description="Whether to interpret the value as a regular expression. Default is false.", required=false)
    private final @Nullable Boolean useRegex;

    public String getDisplayName() {
        return "Delete TOML table row";
    }

    public String getDescription() {
        return "Delete a TOML table row when one of its values matches the specified matcher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TomlVisitor<ExecutionContext>(){

            @Override
            public Toml visitDocument(Toml.Document document, ExecutionContext ctx) {
                Toml.Document doc = (Toml.Document)super.visitDocument(document, ctx);
                if (doc != document && !doc.getValues().isEmpty()) {
                    doc = doc.withValues(ListUtils.mapFirst(doc.getValues(), first -> {
                        TomlValue originalFirst = document.getValues().get(0);
                        if (first != originalFirst) {
                            return (TomlValue)first.withPrefix(originalFirst.getPrefix());
                        }
                        return first;
                    }));
                }
                return doc;
            }

            @Override
            public @Nullable Toml visitTable(Toml.Table table, ExecutionContext ctx) {
                Toml.Table t = (Toml.Table)super.visitTable(table, ctx);
                if (t.getName() != null && DeleteTableRow.this.tableName.equals(t.getName().getName()) && TableRowMatcher.hasMatchingKeyValue(t, DeleteTableRow.this.identifyingKey, DeleteTableRow.this.identifyingValue, DeleteTableRow.this.useRegex)) {
                    return null;
                }
                return t;
            }
        };
    }

    @Generated
    public DeleteTableRow(String tableName, String identifyingKey, String identifyingValue, @Nullable Boolean useRegex) {
        this.tableName = tableName;
        this.identifyingKey = identifyingKey;
        this.identifyingValue = identifyingValue;
        this.useRegex = useRegex;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getIdentifyingKey() {
        return this.identifyingKey;
    }

    @Generated
    public String getIdentifyingValue() {
        return this.identifyingValue;
    }

    @Generated
    public @Nullable Boolean getUseRegex() {
        return this.useRegex;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteTableRow(tableName=" + this.getTableName() + ", identifyingKey=" + this.getIdentifyingKey() + ", identifyingValue=" + this.getIdentifyingValue() + ", useRegex=" + this.getUseRegex() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteTableRow)) {
            return false;
        }
        DeleteTableRow other = (DeleteTableRow)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useRegex = this.getUseRegex();
        Boolean other$useRegex = other.getUseRegex();
        if (this$useRegex == null ? other$useRegex != null : !((Object)this$useRegex).equals(other$useRegex)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$identifyingKey = this.getIdentifyingKey();
        String other$identifyingKey = other.getIdentifyingKey();
        if (this$identifyingKey == null ? other$identifyingKey != null : !this$identifyingKey.equals(other$identifyingKey)) {
            return false;
        }
        String this$identifyingValue = this.getIdentifyingValue();
        String other$identifyingValue = other.getIdentifyingValue();
        return !(this$identifyingValue == null ? other$identifyingValue != null : !this$identifyingValue.equals(other$identifyingValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteTableRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useRegex = this.getUseRegex();
        result = result * 59 + ($useRegex == null ? 43 : ((Object)$useRegex).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $identifyingKey = this.getIdentifyingKey();
        result = result * 59 + ($identifyingKey == null ? 43 : $identifyingKey.hashCode());
        String $identifyingValue = this.getIdentifyingValue();
        result = result * 59 + ($identifyingValue == null ? 43 : $identifyingValue.hashCode());
        return result;
    }
}

