/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.TomlIsoVisitor;
import org.openrewrite.toml.TomlPathMatcher;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlType;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="A TOML path expression to locate a key.", example="package.version")
    private final String keyPath;
    @Option(displayName="New value", description="The new value for the key.", example="\"2.0.0\"")
    private final String newValue;

    public String getDisplayName() {
        return "Change TOML value";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.keyPath, this.newValue);
    }

    public String getDescription() {
        return "Change the value of a TOML key.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TomlPathMatcher matcher = new TomlPathMatcher(this.keyPath);
        final int optionsHash = Objects.hash(this.keyPath, this.newValue);
        return new TomlIsoVisitor<ExecutionContext>(){

            @Override
            public Toml.KeyValue visitKeyValue(Toml.KeyValue keyValue, ExecutionContext ctx) {
                Toml kv = super.visitKeyValue(keyValue, ctx);
                if (matcher.matches(this.getCursor()) && !((Toml.KeyValue)kv).getMarkers().findFirst(Changed.class).map(c -> c.getRecipeOptionsHash() == optionsHash).orElse(false).booleanValue()) {
                    Toml newValueNode = this.parseValue(ChangeValue.this.newValue, ((Toml.KeyValue)kv).getValue().getPrefix());
                    kv = ((Toml.KeyValue)kv).withValue(newValueNode).withMarkers(((Toml.KeyValue)kv).getMarkers().add((Marker)new Changed(Tree.randomId(), optionsHash)));
                }
                return kv;
            }

            private Toml parseValue(String value, Space prefix) {
                if ((value = value.trim()).startsWith("[") && value.endsWith("]")) {
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, value, value);
                }
                if (value.startsWith("{") && value.endsWith("}")) {
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, value, value);
                }
                if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
                    String unquoted = value.substring(1, value.length() - 1);
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, value, unquoted);
                }
                if (value.startsWith("\"\"\"") && value.endsWith("\"\"\"")) {
                    String unquoted = value.substring(3, value.length() - 3);
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, value, unquoted);
                }
                if (value.startsWith("'''") && value.endsWith("'''")) {
                    String unquoted = value.substring(3, value.length() - 3);
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, value, unquoted);
                }
                if ("true".equals(value) || "false".equals(value)) {
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.Boolean, value, Boolean.parseBoolean(value));
                }
                if ("inf".equals(value) || "+inf".equals(value) || "-inf".equals(value) || "nan".equals(value) || "+nan".equals(value) || "-nan".equals(value)) {
                    Double doubleValue;
                    switch (value) {
                        case "inf": 
                        case "+inf": {
                            doubleValue = Double.POSITIVE_INFINITY;
                            break;
                        }
                        case "-inf": {
                            doubleValue = Double.NEGATIVE_INFINITY;
                            break;
                        }
                        default: {
                            doubleValue = Double.NaN;
                        }
                    }
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.Float, value, doubleValue);
                }
                if (value.contains("T") || value.contains(":")) {
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.OffsetDateTime, value, value);
                }
                try {
                    if (value.contains(".") || value.contains("e") || value.contains("E")) {
                        Double doubleValue = Double.parseDouble(value.replace("_", ""));
                        return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.Float, value, doubleValue);
                    }
                    Long longValue = value.startsWith("0x") || value.startsWith("0X") ? Long.valueOf(Long.parseLong(value.substring(2).replace("_", ""), 16)) : (value.startsWith("0o") || value.startsWith("0O") ? Long.valueOf(Long.parseLong(value.substring(2).replace("_", ""), 8)) : (value.startsWith("0b") || value.startsWith("0B") ? Long.valueOf(Long.parseLong(value.substring(2).replace("_", ""), 2)) : Long.valueOf(Long.parseLong(value.replace("_", "")))));
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.Integer, value, longValue);
                }
                catch (NumberFormatException e) {
                    return new Toml.Literal(Tree.randomId(), prefix, Markers.EMPTY, TomlType.Primitive.String, "\"" + value + "\"", value);
                }
            }
        };
    }

    @Generated
    public ChangeValue(String keyPath, String newValue) {
        this.keyPath = keyPath;
        this.newValue = newValue;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeValue(keyPath=" + this.getKeyPath() + ", newValue=" + this.getNewValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }

    static final class Changed
    implements Marker {
        private final UUID id;
        private final int recipeOptionsHash;

        @Generated
        public Changed(UUID id, int recipeOptionsHash) {
            this.id = id;
            this.recipeOptionsHash = recipeOptionsHash;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public int getRecipeOptionsHash() {
            return this.recipeOptionsHash;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Changed)) {
                return false;
            }
            Changed other = (Changed)o;
            if (this.getRecipeOptionsHash() != other.getRecipeOptionsHash()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRecipeOptionsHash();
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ChangeValue.Changed(id=" + this.getId() + ", recipeOptionsHash=" + this.getRecipeOptionsHash() + ")";
        }

        @NonNull
        @Generated
        public Changed withId(UUID id) {
            return this.id == id ? this : new Changed(id, this.recipeOptionsHash);
        }

        @NonNull
        @Generated
        public Changed withRecipeOptionsHash(int recipeOptionsHash) {
            return this.recipeOptionsHash == recipeOptionsHash ? this : new Changed(this.id, recipeOptionsHash);
        }
    }
}

