/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlValue;

public final class DeleteTable
extends Recipe {
    @Option(displayName="Table name", description="The name of the TOML table to delete.", example="dependencies")
    private final String tableName;

    public String getDisplayName() {
        return "Delete TOML table";
    }

    public String getDescription() {
        return "Delete a TOML table.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TomlVisitor<ExecutionContext>(){

            @Override
            public Toml visitDocument(Toml.Document document, ExecutionContext ctx) {
                Toml.Document doc = (Toml.Document)super.visitDocument(document, ctx);
                if (doc != document) {
                    doc = doc.withValues(ListUtils.mapFirst(doc.getValues(), first -> {
                        TomlValue originalFirst = document.getValues().get(0);
                        if (first != originalFirst) {
                            return (TomlValue)first.withPrefix(originalFirst.getPrefix());
                        }
                        return first;
                    }));
                }
                return doc;
            }

            @Override
            public @Nullable Toml visitTable(Toml.Table table, ExecutionContext ctx) {
                Toml.Table t = (Toml.Table)super.visitTable(table, ctx);
                if (t.getName() != null && DeleteTable.this.tableName.equals(t.getName().getName())) {
                    return null;
                }
                return t;
            }
        };
    }

    @Generated
    public DeleteTable(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteTable(tableName=" + this.getTableName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteTable)) {
            return false;
        }
        DeleteTable other = (DeleteTable)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }
}

