/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.marker.ArrayTable;
import org.openrewrite.toml.marker.InlineTable;
import org.openrewrite.toml.tree.Comment;
import org.openrewrite.toml.tree.Space;
import org.openrewrite.toml.tree.Toml;
import org.openrewrite.toml.tree.TomlRightPadded;

public class TomlPrinter<P>
extends TomlVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> TOML_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public Toml visitArray(Toml.Array array, PrintOutputCapture<P> p) {
        this.beforeSyntax(array, p);
        p.append("[");
        this.visitRightPadded(array.getPadding().getValues(), ",", p);
        p.append("]");
        this.afterSyntax(array, p);
        return array;
    }

    @Override
    public Toml visitDocument(Toml.Document document, PrintOutputCapture<P> p) {
        this.beforeSyntax(document, p);
        this.visit(document.getValues(), p);
        this.visitSpace(document.getEof(), p);
        this.afterSyntax(document, p);
        return document;
    }

    @Override
    public Toml visitEmpty(Toml.Empty empty, PrintOutputCapture<P> p) {
        this.beforeSyntax(empty, p);
        this.afterSyntax(empty, p);
        return empty;
    }

    @Override
    public Toml visitIdentifier(Toml.Identifier identifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(identifier, p);
        p.append(identifier.getSource());
        this.afterSyntax(identifier, p);
        return identifier;
    }

    @Override
    public Toml visitKeyValue(Toml.KeyValue keyValue, PrintOutputCapture<P> p) {
        this.beforeSyntax(keyValue, p);
        this.visitRightPadded(keyValue.getPadding().getKey(), p);
        p.append("=");
        this.visit(keyValue.getValue(), p);
        this.afterSyntax(keyValue, p);
        return keyValue;
    }

    @Override
    public Toml visitLiteral(Toml.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, p);
        p.append(literal.getSource());
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public Space visitSpace(Space space, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            p.append("#").append(comment.getText()).append(comment.getSuffix());
        }
        return space;
    }

    @Override
    public Toml visitTable(Toml.Table table, PrintOutputCapture<P> p) {
        this.beforeSyntax(table, p);
        if (table.getMarkers().findFirst(InlineTable.class).isPresent()) {
            p.append("{");
            this.visitRightPadded(table.getPadding().getValues(), ",", p);
            p.append("}");
        } else if (table.getMarkers().findFirst(ArrayTable.class).isPresent()) {
            p.append("[[");
            this.visitRightPadded(table.getName(), p);
            p.append("]]");
            this.visitRightPadded(table.getPadding().getValues(), "", p);
        } else {
            p.append("[");
            this.visitRightPadded(table.getName(), p);
            p.append("]");
            this.visitRightPadded(table.getPadding().getValues(), "", p);
        }
        this.afterSyntax(table, p);
        return table;
    }

    protected void visitRightPadded(List<? extends TomlRightPadded<? extends Toml>> nodes, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            TomlRightPadded<? extends Toml> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void beforeSyntax(Toml t, PrintOutputCapture<P> p) {
        this.beforeSyntax(t.getPrefix(), t.getMarkers(), p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), TOML_MARKER_WRAPPER));
        }
        this.visitSpace(prefix, p);
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), TOML_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(Toml t, PrintOutputCapture<P> p) {
        this.afterSyntax(t.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), TOML_MARKER_WRAPPER));
        }
    }
}

