/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.test.SourceSpec;

class RewriteTestUtils {
    RewriteTestUtils() {
    }

    static boolean isKotlinRecipeWithRequiredOptions(Class<?> recipeClass) {
        for (Annotation a : recipeClass.getDeclaredAnnotations()) {
            if (!"kotlin.Metadata".equals(a.annotationType().getName())) continue;
            for (Field field : recipeClass.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null || !option.required()) continue;
                return true;
            }
        }
        return false;
    }

    static boolean groupSourceSpecsByParser(List<Parser.Builder> parserBuilders, Map<Parser.Builder, List<SourceSpec<?>>> sourceSpecsByParser, SourceSpec<?> sourceSpec) {
        for (Map.Entry<Parser.Builder, List<SourceSpec<?>>> entry : sourceSpecsByParser.entrySet()) {
            if (!entry.getKey().getSourceFileType().equals(sourceSpec.sourceFileType) || !sourceSpec.getParser().getClass().isAssignableFrom(entry.getKey().getClass())) continue;
            entry.getValue().add(sourceSpec);
            return true;
        }
        for (Parser.Builder parser : parserBuilders) {
            if (!parser.getSourceFileType().equals(sourceSpec.sourceFileType)) continue;
            sourceSpecsByParser.computeIfAbsent(parser, p -> new ArrayList()).add(sourceSpec);
            return true;
        }
        return false;
    }
}

