/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.InMemoryLargeSourceSet;

class LargeSourceSetCheckingExpectedCycles
extends InMemoryLargeSourceSet {
    private final int expectedCyclesThatMakeChanges;
    private int cyclesThatResultedInChanges = 0;
    private Map<SourceFile, SourceFile> lastCycleEdits = Collections.emptyMap();
    private Set<SourceFile> lastCycleGenerated = Collections.emptySet();
    private Set<SourceFile> lastCycleDeleted = Collections.emptySet();

    LargeSourceSetCheckingExpectedCycles(int expectedCyclesThatMakeChanges, List<SourceFile> ls) {
        super(ls);
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
    }

    private LargeSourceSetCheckingExpectedCycles(LargeSourceSetCheckingExpectedCycles from, @Nullable Map<SourceFile, List<Recipe>> deletions, List<SourceFile> mapped) {
        super(from.getInitialState(), deletions, mapped, null);
        this.expectedCyclesThatMakeChanges = from.expectedCyclesThatMakeChanges;
        this.cyclesThatResultedInChanges = from.cyclesThatResultedInChanges;
        this.lastCycleEdits = from.lastCycleEdits;
        this.lastCycleGenerated = from.lastCycleGenerated;
        this.lastCycleDeleted = from.lastCycleDeleted;
    }

    protected InMemoryLargeSourceSet withChanges(@Nullable Map<SourceFile, List<Recipe>> deletions, List<SourceFile> mapped) {
        return new LargeSourceSetCheckingExpectedCycles(this, deletions, mapped);
    }

    public void afterCycle(boolean lastCycle) {
        boolean detectedChangeInThisCycle = false;
        HashMap<SourceFile, SourceFile> thisCycleEdits = new HashMap<SourceFile, SourceFile>();
        HashSet<SourceFile> thisCycleGenerated = new HashSet<SourceFile>();
        HashSet<SourceFile> thisCycleDeleted = new HashSet<SourceFile>();
        for (Result result : this.getChangeset().getAllResults()) {
            SourceFile before = null;
            SourceFile after = result.getAfter();
            if (result.getBefore() == null) {
                before = after == null ? null : (SourceFile)this.lastCycleGenerated.stream().filter(it -> Objects.equals(it.getId(), result.getAfter().getId())).findFirst().orElse(null);
            } else {
                if (after == null && this.lastCycleDeleted.contains(result.getBefore())) {
                    after = before = result.getBefore();
                }
                if (before == null) {
                    before = this.lastCycleEdits.getOrDefault(result.getBefore(), result.getBefore());
                }
            }
            if (before != null && after != null) {
                thisCycleEdits.put(before, after);
                if (!detectedChangeInThisCycle && before != after) {
                    detectedChangeInThisCycle = true;
                    ++this.cyclesThatResultedInChanges;
                }
                if (this.cyclesThatResultedInChanges <= this.expectedCyclesThatMakeChanges) continue;
                ((AbstractStringAssert)Assertions.assertThat((String)after.printAllTrimmed()).as("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges == 1 ? "" : "s") + ", but took at least one more cycle. Between the last two executed cycles there were changes to \"" + before.getSourcePath() + "\"", new Object[0])).isEqualTo(before.printAllTrimmed());
                continue;
            }
            if (before == null && after != null) {
                thisCycleGenerated.add(after);
                if (detectedChangeInThisCycle) continue;
                detectedChangeInThisCycle = true;
                ++this.cyclesThatResultedInChanges;
                continue;
            }
            if (before == null) continue;
            thisCycleDeleted.add(before);
            if (detectedChangeInThisCycle) continue;
            detectedChangeInThisCycle = true;
            ++this.cyclesThatResultedInChanges;
        }
        this.lastCycleEdits = thisCycleEdits;
        this.lastCycleGenerated = thisCycleGenerated;
        this.lastCycleDeleted = thisCycleDeleted;
        if (lastCycle) {
            if (this.cyclesThatResultedInChanges == 0 && this.expectedCyclesThatMakeChanges > 0) {
                Assertions.fail((String)"Recipe was expected to make a change but made no changes.");
            } else if (this.cyclesThatResultedInChanges != this.expectedCyclesThatMakeChanges) {
                Assertions.fail((String)("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges > 1 ? "s" : "") + ", but took " + this.cyclesThatResultedInChanges + " cycle" + (this.cyclesThatResultedInChanges > 1 ? "s" : "") + ". This usually indicates the recipe is making changes after it should have stabilized.\nhttps://docs.openrewrite.org/authoring-recipes/recipe-conventions-and-best-practices#stay-single-cycle"));
            }
        }
    }
}

