/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.Quark;

class RecipeSchedulerCheckingExpectedCycles
extends RecipeScheduler {
    private final int expectedCyclesThatMakeChanges;
    private int cyclesThatResultedInChanges = 0;
    @Nullable
    private LargeSourceSet previousSourceSet;

    public void afterCycle(LargeSourceSet sourceSet) {
        if (sourceSet != this.previousSourceSet && sourceSet.getChangeset().size() > 0) {
            ++this.cyclesThatResultedInChanges;
            if (this.cyclesThatResultedInChanges > this.expectedCyclesThatMakeChanges) {
                for (Result result : sourceSet.getChangeset().getAllResults()) {
                    SourceFile before = result.getBefore();
                    SourceFile after = result.getAfter();
                    if (before == null || after == null || after instanceof Quark) continue;
                    ((AbstractStringAssert)Assertions.assertThat((String)after.printAllTrimmed()).as("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges == 1 ? "" : "s") + ", but took at least one more cycle. Between the last two executed cycles there were changes to \"" + before.getSourcePath() + "\"", new Object[0])).isEqualTo(before.printAllTrimmed());
                }
            }
        }
        this.previousSourceSet = sourceSet;
    }

    public void verify() {
        if (this.cyclesThatResultedInChanges != this.expectedCyclesThatMakeChanges) {
            Assertions.fail((String)("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges > 1 ? "s" : "") + ", but took " + this.cyclesThatResultedInChanges + " cycle" + (this.cyclesThatResultedInChanges > 1 ? "s" : "") + "."));
        }
    }

    public RecipeSchedulerCheckingExpectedCycles(int expectedCyclesThatMakeChanges) {
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
    }
}

