/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeSerializer;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaParserTestUtil;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public interface JavaTreeTest {
    default public ExecutionContext getExecutionContext() {
        return new InMemoryExecutionContext(t -> Assertions.fail((String)"Failed to parse", (Throwable)t));
    }

    default public void assertParsePrintAndProcess(JavaParser parser, NestingLevel nestingLevel, String code, String ... imports) {
        String source = Arrays.stream(imports).map(i -> "import " + i + ";").collect(Collectors.joining(""));
        switch (nestingLevel) {
            case Block: {
                source = source + "class A" + System.nanoTime() + "{{\n" + code + "\n}}";
                break;
            }
            case Class: {
                source = source + "class A" + System.nanoTime() + "{\n" + code + "\n}";
                break;
            }
            case CompilationUnit: {
                source = source + "/*<START>*/\n" + code;
            }
        }
        J.CompilationUnit cu = (J.CompilationUnit)parser.parse(this.getExecutionContext(), new String[]{source}).iterator().next();
        J processed = (J)new JavaVisitor().visit((Tree)cu, new Object());
        ((ObjectAssert)Assertions.assertThat((Object)processed).as("Processing is idempotent", new Object[0])).isSameAs((Object)cu);
        TreeSerializer treeSerializer = new TreeSerializer();
        J.CompilationUnit roundTripCu = (J.CompilationUnit)treeSerializer.read(treeSerializer.write((SourceFile)cu));
        ((AbstractStringAssert)Assertions.assertThat((String)JavaParserTestUtil.print(nestingLevel, cu)).as("Source code is printed the same after parsing", new Object[0])).isEqualTo(StringUtils.trimIndent((String)code));
        ((AbstractStringAssert)Assertions.assertThat((String)JavaParserTestUtil.print(nestingLevel, roundTripCu)).as("Source code is printed the same after round trip serialization", new Object[0])).isEqualTo(StringUtils.trimIndent((String)code));
    }

    public static enum NestingLevel {
        Block,
        Class,
        CompilationUnit;

    }
}

