/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.UnnecessaryThrows;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/cleanup/UnnecessaryThrowsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "abstractMethods", "", "jp", "Lorg/openrewrite/java/JavaParser;", "interfaces", "necessaryThrows", "necessaryThrowsFromCloseable", "unnecessaryThrows", "rewrite-test"})
public interface UnnecessaryThrowsTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void unnecessaryThrows(@NotNull JavaParser var1);

    @Disabled
    @Test
    public void necessaryThrowsFromCloseable(@NotNull JavaParser var1);

    @Test
    public void necessaryThrows(@NotNull JavaParser var1);

    @Test
    public void interfaces(@NotNull JavaParser var1);

    @Test
    public void abstractMethods(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull UnnecessaryThrowsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new UnnecessaryThrows();
        }

        @Test
        public static void unnecessaryThrows(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            import java.io.FileInputStream;\n            import java.io.FileNotFoundException;\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            \n            class Test {\n                void test() throws FileNotFoundException, UncheckedIOException {\n                }\n            \n                void test() throws IOException, UncheckedIOException {\n                    new FileInputStream(\"test\");\n                }\n            }\n        ", null, "\n            import java.io.FileInputStream;\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            \n            class Test {\n                void test() throws UncheckedIOException {\n                }\n            \n                void test() throws IOException, UncheckedIOException {\n                    new FileInputStream(\"test\");\n                }\n            }\n        ", 0, 0, null, 234, null);
        }

        @Disabled
        @Test
        public static void necessaryThrowsFromCloseable(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, null, null, "\n        import java.io.IOException;\n        import java.net.URL;\n        import java.net.URLClassLoader;\n        \n        class Test {\n            public void testLookupWithExtendedClasspath() throws IOException{\n                URL url = getClass().getResource(\"foo.jar\");\n                assertNotNull(url);\n                // URLClassLoader implements Closeable and throws IOException from its close() method\n                try (URLClassLoader cl = new URLClassLoader(new URL[] {url})) {\n                }\n            }\n        }\n        ", null, 11, null);
        }

        @Test
        public static void necessaryThrows(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, null, null, "\n            import java.io.IOException;\n            \n            class Test {\n                \n                void test() throws IOException {\n                    throw new IOException();\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void interfaces(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, null, null, "\n            import java.io.IOException;\n            \n            interface Test {\n                void test() throws IOException;\n            }\n        ", null, 11, null);
        }

        @Test
        public static void abstractMethods(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, null, null, "\n            import java.io.IOException;\n            \n            abstract class Test {\n                abstract void test() throws IOException;\n            }\n        ", null, 11, null);
        }

        public static void assertChangedBase(@NotNull UnnecessaryThrowsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull UnnecessaryThrowsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UnnecessaryThrowsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UnnecessaryThrowsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UnnecessaryThrowsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull UnnecessaryThrowsTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static JavaParser getParser(@NotNull UnnecessaryThrowsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull UnnecessaryThrowsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

