/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/RemoveUnusedImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "dontRemoveStaticReferenceToPrimitiveField", "", "jp", "Lorg/openrewrite/java/JavaParser;", "leaveImportForStaticImportEnumInAnnotation", "leaveImportIfRemovedTypeIsStillReferredTo", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfThreeOrMoreTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "removeImport", "Lorg/openrewrite/RecipeTest$AdHocRecipe;", "type", "", "removeNamedImport", "removePackageInfoImports", "removePackageInfoStarImports", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStaticImportIfNotReferenced", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "resultSetType", "rewrite-test"})
public interface RemoveUnusedImportsTest
extends JavaRecipeTest {
    @NotNull
    public RecipeTest.AdHocRecipe removeImport(@NotNull String var1);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void leaveImportForStaticImportEnumInAnnotation(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfThreeOrMoreTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removePackageInfoImports(@NotNull JavaParser var1);

    @Test
    public void removePackageInfoStarImports(@NotNull JavaParser var1);

    @Test
    public void dontRemoveStaticReferenceToPrimitiveField(@NotNull JavaParser var1);

    @Test
    public void resultSetType();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static RecipeTest.AdHocRecipe removeImport(@NotNull RemoveUnusedImportsTest this_, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this_.toRecipe((TreeVisitor)new RemoveImport(type));
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {}\n        ", null, "class A {}", 0, 0, null, 232, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.List;\n            class A {\n               List<Integer> list;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void leaveImportForStaticImportEnumInAnnotation(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImports removeUnusedImports = new RemoveUnusedImports();
            String[] stringArray = new String[]{"\n            package org.openrewrite.test;\n            \n            public @interface YesOrNo {\n                Status status();\n                enum Status {\n                    YES, NO\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)removeUnusedImports, "\n            package org.openrewrite.test;\n            \n            import static org.openrewrite.test.YesOrNo.Status.YES;\n            \n            @YesOrNo(status = YES)\n            public class Foo {}\n        ", stringArray2);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.*;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfThreeOrMoreTypesStillReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.List"), "\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, 232, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStaticImportIfNotReferenced(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.time.DayOfWeek.MONDAY"), "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, "\n            import java.time.DayOfWeek;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.removeImport("java.util.Collections"), "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImports removeUnusedImports = new RemoveUnusedImports[]{"\n                package foo;\n                public class B {\n                    public static final String STRING = \"string\";\n                    public static final String STRING2 = \"string2\";\n                }\n            ", "\n                package foo;\n                public class C {\n                    public static final String ANOTHER = \"string\";\n                }\n            "};
            RemoveUnusedImports removeUnusedImports2 = removeUnusedImports;
            removeUnusedImports = new RemoveUnusedImports();
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)removeUnusedImports, "\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", (String[])removeUnusedImports2, "\n            import static foo.B.STRING;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", 0, 0, null, 224, null);
        }

        @Test
        public static void removePackageInfoImports(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImports removeUnusedImports = new RemoveUnusedImports();
            String[] stringArray = new String[]{"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)removeUnusedImports, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n            import foo.FooAnnotation;\n        ", stringArray2, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ", 0, 0, null, 224, null);
        }

        @Test
        public static void removePackageInfoStarImports(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveUnusedImports removeUnusedImports = new RemoveUnusedImports();
            String[] stringArray = new String[]{"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)removeUnusedImports, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.*;\n        ", stringArray2, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ", 0, 0, null, 224, null);
        }

        @Test
        public static void dontRemoveStaticReferenceToPrimitiveField(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, (Recipe)new RemoveUnusedImports(), "\n            import static java.sql.ResultSet.TYPE_FORWARD_ONLY;\n            public class A {\n                int t = TYPE_FORWARD_ONLY;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void resultSetType(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, null, (Recipe)new RemoveUnusedImports(), "\n            import java.sql.ResultSet;\n            public class A {\n                int t = ResultSet.TYPE_FORWARD_ONLY;\n            }\n        ", null, 9, null);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull RemoveUnusedImportsTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

