/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.HiddenField;
import org.openrewrite.java.cleanup.HiddenFieldStyle;
import org.openrewrite.java.cleanup.HiddenFieldTest;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u0017\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0018\u0010\u0018\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013H\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006%"}, d2={"Lorg/openrewrite/java/cleanup/HiddenFieldTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "constructorParameter", "", "jp", "Lorg/openrewrite/java/JavaParser;", "forLoops", "hiddenFieldStyle", "", "Lorg/openrewrite/style/NamedStyles;", "with", "Lkotlin/Function1;", "Lorg/openrewrite/java/cleanup/HiddenFieldStyle;", "Lkotlin/ExtensionFunctionType;", "ignoreAbstractMethodParameters", "Lorg/openrewrite/java/JavaParser$Builder;", "ignoreConstructorParameter", "ignoreEnums", "ignoreInterfaces", "ignoreSetter", "ignoreSetterThatReturnsItsClass", "ignoreStaticMethodsAndInitializers", "ignoreUnaffectedVariables", "incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse", "incrementRenamedVariableNameUntilUnique", "lambdaWithTypedParameterHides", "methodBodyLocalVariable", "methodParameter", "nestedClasses", "renameHiddenFields", "renamesAbstractMethodParameters", "renamesSetters", "renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount", "rewrite-test"})
public interface HiddenFieldTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @NotNull
    public List<NamedStyles> hiddenFieldStyle(@NotNull Function1<? super HiddenFieldStyle, HiddenFieldStyle> var1);

    @Test
    public void ignoreUnaffectedVariables(@NotNull JavaParser var1);

    @Test
    public void renameHiddenFields(@NotNull JavaParser var1);

    @Test
    public void constructorParameter(@NotNull JavaParser var1);

    @Test
    public void ignoreConstructorParameter(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void methodParameter(@NotNull JavaParser var1);

    @Test
    public void methodBodyLocalVariable(@NotNull JavaParser var1);

    @Test
    public void forLoops(@NotNull JavaParser var1);

    @Test
    public void lambdaWithTypedParameterHides(@NotNull JavaParser var1);

    @Test
    public void nestedClasses(@NotNull JavaParser var1);

    @Test
    public void incrementRenamedVariableNameUntilUnique(@NotNull JavaParser var1);

    @Test
    public void incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse(@NotNull JavaParser var1);

    @Test
    public void ignoreEnums(@NotNull JavaParser var1);

    @Test
    public void ignoreStaticMethodsAndInitializers(@NotNull JavaParser var1);

    @Test
    public void ignoreInterfaces(@NotNull JavaParser var1);

    @Test
    public void renamesSetters(@NotNull JavaParser var1);

    @Test
    public void ignoreSetter(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void ignoreSetterThatReturnsItsClass(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void renamesAbstractMethodParameters(@NotNull JavaParser var1);

    @Test
    public void ignoreAbstractMethodParameters(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull HiddenFieldTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new HiddenField();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<NamedStyles> hiddenFieldStyle(@NotNull HiddenFieldTest this_, @NotNull Function1<? super HiddenFieldStyle, HiddenFieldStyle> with) {
            void receiver;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(with, (String)"with");
            HiddenFieldStyle hiddenFieldStyle2 = HiddenFieldStyle.hiddenFieldStyle();
            boolean bl = false;
            boolean bl2 = false;
            HiddenFieldStyle hiddenFieldStyle3 = hiddenFieldStyle2;
            Set set = SetsKt.emptySet();
            String string = "test";
            String string2 = "test";
            String string3 = "test";
            UUID uUID = Tree.randomId();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)receiver, (String)"this");
            HiddenFieldStyle hiddenFieldStyle4 = (HiddenFieldStyle)with.invoke((Object)receiver);
            Collection collection = CollectionsKt.listOf((Object)hiddenFieldStyle4);
            Set set2 = set;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            UUID uUID2 = uUID;
            return CollectionsKt.listOf((Object)new NamedStyles(uUID2, string6, string5, string4, set2, collection));
        }

        public static /* synthetic */ List hiddenFieldStyle$default(HiddenFieldTest hiddenFieldTest, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hiddenFieldStyle");
            }
            if ((n & 1) != 0) {
                function1 = hiddenFieldStyle.1.INSTANCE;
            }
            return hiddenFieldTest.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)function1);
        }

        @Test
        public static void ignoreUnaffectedVariables(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public A(String someField) {\n                }\n\n                public void method(String someField) {\n                    String localVariable = someField;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void renameHiddenFields(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n\n            public class B {\n                protected int n2;\n                int n3;\n                private int n4;\n            }\n            "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A extends B {\n                int n;\n                int n1;\n\n                class C {\n                    public void method(int n) {\n                        int n1 = n;\n                    }\n                }\n\n                static class D {\n                    public void method(int n) {\n                    }\n                }\n            }\n        ", stringArray2, "\n            package org.openrewrite;\n\n            public class A extends B {\n                int n;\n                int n1;\n\n                class C {\n                    public void method(int n2) {\n                        int n3 = n2;\n                    }\n                }\n\n                static class D {\n                    public void method(int n) {\n                    }\n                }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void constructorParameter(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public A(String field) {\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public A(String field1) {\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void ignoreConstructorParameter(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreConstructorParameter.1.INSTANCE))).build(), null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public A(String field) {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void methodParameter(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public void method(String field) {\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public void method(String field1) {\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void methodBodyLocalVariable(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public void method(String param) {\n                    String field = param;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                private String field;\n\n                public void method(String param) {\n                    String field1 = param;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void forLoops(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                int n;\n\n                public void standardForLoop() {\n                    for (int n = 0; n < 1; n++) {\n                        int x = n;\n                    }\n                }\n\n                public void enhancedForLoop(int[] arr) {\n                    for (int n : arr) {\n                        int x = n;\n                    }\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                int n;\n\n                public void standardForLoop() {\n                    for (int n1 = 0; n1 < 1; n1++) {\n                        int x = n1;\n                    }\n                }\n\n                public void enhancedForLoop(int[] arr) {\n                    for (int n1 : arr) {\n                        int x = n1;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void lambdaWithTypedParameterHides(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                List<Integer> numbers = Arrays.asList(1, 2, 3);\n                Integer value = 0;\n                {\n                    numbers.forEach((Integer value) -> String.valueOf(value));\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                List<Integer> numbers = Arrays.asList(1, 2, 3);\n                Integer value = 0;\n                {\n                    numbers.forEach((Integer value1) -> String.valueOf(value1));\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void nestedClasses(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class Outer {\n                int outer;\n\n                public class Inner {\n                    int inner;\n\n                    public Inner() {\n                        int inner = 0;\n                    }\n\n                    public Inner(int inner) {\n                    }\n\n                    public void method() {\n                        int outer = 0;\n                    }\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class Outer {\n                int outer;\n\n                public class Inner {\n                    int inner;\n\n                    public Inner() {\n                        int inner1 = 0;\n                    }\n\n                    public Inner(int inner1) {\n                    }\n\n                    public void method() {\n                        int outer1 = 0;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void incrementRenamedVariableNameUntilUnique(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                int n, n1;\n\n                public void method(int n) {\n                    int n1 = 0;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                int n, n1;\n\n                public void method(int n2) {\n                    int n3 = 0;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void incrementRenamedVariableNameShouldNotCollideWithExistingVariablesInUse(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A {\n                int n, n1;\n\n                public void method(int n) {\n                    int n2 = 0;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public class A {\n                int n, n1;\n\n                public void method(int n3) {\n                    int n2 = 0;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void ignoreEnums(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            enum ExampleEnum {\n                A(0),\n                B(1),\n                C(2) {\n                    int hidden;\n\n                    public void method() {\n                        int hidden = 0;\n                    }\n                };\n\n                int hidden;\n                static int hiddenStatic;\n\n                ExampleEnum(int hidden) {\n                }\n\n                public void method() {\n                    int hidden = 0;\n                }\n\n                public static void methodStatic() {\n                    int hiddenStatic = 0;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void ignoreStaticMethodsAndInitializers(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class StaticMethods {\n                private int notHidden;\n\n                public static void method() {\n                    // local variables of static methods don't hide instance fields.\n                    int notHidden;\n                }\n\n                static {\n                    // local variables of static initializers don't hide instance fields.\n                    int notHidden;\n                }\n\n                private int x;\n                private static int y;\n\n                static class Inner {\n                    void useX(int x) {\n                        x++;\n                    }\n\n                    void useY(int y) {\n                        y++;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void ignoreInterfaces(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            interface A {\n                int n = 0;\n\n                void method(int n);\n            }\n        ", null, 10, null);
        }

        @Test
        public static void renamesSetters(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            class A {\n                int n;\n\n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n    \n            class B {\n                int n;\n\n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            class A {\n                int n;\n\n                public void setN(int n1) {\n                    this.n = n1;\n                }\n            }\n    \n            class B {\n                int n;\n\n                public B setN(int n1) {\n                    this.n = n1;\n                    return this;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void ignoreSetter(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreSetter.1.INSTANCE))).build(), null, "\n            package org.openrewrite;\n\n            class A {\n                int n;\n\n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n    \n            class B {\n                int n;\n\n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n        ", null, "\n            package org.openrewrite;\n\n            class A {\n                int n;\n\n                public void setN(int n) {\n                    this.n = n;\n                }\n            }\n\n            class B {\n                int n;\n\n                public B setN(int n1) {\n                    this.n = n1;\n                    return this;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void ignoreSetterThatReturnsItsClass(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreSetterThatReturnsItsClass.1.INSTANCE))).build(), null, "\n            package org.openrewrite;\n\n            class B {\n                int n;\n\n                public B setN(int n) {\n                    this.n = n;\n                    return this;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void renamesAbstractMethodParameters(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public abstract class A {\n                int n;\n\n                public abstract void method(int n);\n            }\n        ", null, "\n            package org.openrewrite;\n\n            public abstract class A {\n                int n;\n\n                public abstract void method(int n1);\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void ignoreAbstractMethodParameters(@NotNull HiddenFieldTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.hiddenFieldStyle((Function1<? super HiddenFieldStyle, HiddenFieldStyle>)((Function1)ignoreAbstractMethodParameters.1.INSTANCE))).build(), null, "\n            package org.openrewrite;\n\n            public abstract class A {\n                int n;\n\n                public abstract void method(int n);\n            }\n        ", null, 10, null);
        }

        @Test
        public static void renamingVariableInSubclassShouldNotTakeSuperclassFieldsIntoAccount(@NotNull HiddenFieldTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n\n            public class B {\n                protected Integer n2;\n                Integer n3;\n                private Integer n4;\n            }\n        "};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            package org.openrewrite;\n\n            public class A extends B {\n                Integer n;\n                Integer n1;\n\n                class C {\n                    public void method(Integer n) {\n                        Integer n1 = n;\n                    }\n                }\n            }\n        ", stringArray2, "\n            package org.openrewrite;\n\n            public class A extends B {\n                Integer n;\n                Integer n1;\n\n                class C {\n                    public void method(Integer n2) {\n                        Integer n3 = n2;\n                    }\n                }\n            }\n        ", 0, 34, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull HiddenFieldTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull HiddenFieldTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull HiddenFieldTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull HiddenFieldTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

