/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/tree/ClassDeclarationTest;", "Lorg/openrewrite/java/JavaTreeTest;", "extends", "", "jp", "Lorg/openrewrite/java/JavaParser;", "hasModifier", "implements", "innerClass", "modifierOrdering", "multipleClassDeclarationsInOneCompilationUnit", "singleLineCommentBeforeModifier", "strictfp", "typeArgumentsAndAnnotation", "rewrite-test"})
public interface ClassDeclarationTest
extends JavaTreeTest {
    @Test
    public void singleLineCommentBeforeModifier(@NotNull JavaParser var1);

    @Test
    public void multipleClassDeclarationsInOneCompilationUnit(@NotNull JavaParser var1);

    @Test
    public void implements(@NotNull JavaParser var1);

    @Test
    public void extends(@NotNull JavaParser var1);

    @Test
    public void typeArgumentsAndAnnotation(@NotNull JavaParser var1);

    @Test
    public void modifierOrdering(@NotNull JavaParser var1);

    @Test
    public void innerClass(@NotNull JavaParser var1);

    @Test
    public void strictfp(@NotNull JavaParser var1);

    @Test
    public void hasModifier(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void singleLineCommentBeforeModifier(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            @Deprecated\n            // Some comment\n            public final class A {}\n        ", new String[0]);
        }

        @Test
        public static void multipleClassDeclarationsInOneCompilationUnit(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class A {}\n            class B {}\n        ", new String[0]);
        }

        @Test
        public static void implements(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public interface B {}\n            class A implements B {}\n        ", new String[0]);
        }

        @Test
        public static void extends(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public interface B {}\n            class A extends B {}\n        ", new String[0]);
        }

        @Test
        public static void typeArgumentsAndAnnotation(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class B<T> {}\n            @Deprecated public class A < T > extends B < T > {}\n        ", new String[0]);
        }

        @Test
        public static void modifierOrdering(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public /* abstract */ final abstract class A {}\n        ", new String[0]);
        }

        @Test
        public static void innerClass(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public class A {\n                public enum B {\n                    ONE,\n                    TWO\n                }\n            \n                private B b;\n            }\n        ", new String[0]);
        }

        @Test
        public static void strictfp(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            public strictfp class A {}\n        ", new String[0]);
        }

        @Test
        public static void hasModifier(@NotNull ClassDeclarationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public strictfp class A {}\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            J.ClassDeclaration inv = (J.ClassDeclaration)a.getClasses().get(0);
            Assertions.assertThat((List)inv.getModifiers()).hasSize(2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Public));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Strictfp));
        }
    }
}

