/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/ImportTest;", "Lorg/openrewrite/java/JavaTreeTest;", "classImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "compare", "compareSamePackageDifferentNameLengths", "starImport", "rewrite-test"})
public interface ImportTest
extends JavaTreeTest {
    @Test
    public void classImport(@NotNull JavaParser var1);

    @Test
    public void starImport(@NotNull JavaParser var1);

    @Test
    public void compare(@NotNull JavaParser var1);

    @Test
    public void compareSamePackageDifferentNameLengths(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void classImport(@NotNull ImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            public class A {}\n        ", new String[0]);
        }

        @Test
        public static void starImport(@NotNull ImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.*;\n            public class A {}\n        ", new String[0]);
        }

        @Test
        public static void compare(@NotNull ImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"import b.B;\nimport c.c.C;"};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            object = a.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imports");
            Object object2 = object;
            boolean bl = false;
            J.Import b = (J.Import)object2.get(0);
            Object object3 = object;
            boolean bl2 = false;
            J.Import c = (J.Import)object3.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo(b) > 0 ? 1 : 0) != 0);
        }

        @Test
        public static void compareSamePackageDifferentNameLengths(@NotNull ImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"import org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Configuration;"};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            object = a.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imports");
            Object object2 = object;
            boolean bl = false;
            J.Import b = (J.Import)object2.get(0);
            Object object3 = object;
            boolean bl2 = false;
            J.Import c = (J.Import)object3.get(1);
            Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            Assertions.assertTrue((c.compareTo(b) > 0 ? 1 : 0) != 0);
        }
    }
}

