/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SourceSet;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.scheduling.DirectScheduler;
import org.openrewrite.test.AdHocRecipe;
import org.openrewrite.test.RecipeSchedulerCheckingExpectedCycles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTestUtils;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.UncheckedConsumer;

public interface RewriteTest
extends SourceSpecs {
    public static AdHocRecipe toRecipe(Supplier<TreeVisitor<?, ExecutionContext>> visitor) {
        return new AdHocRecipe(null, null, null, visitor, null, null, null, Collections.emptyList());
    }

    public static AdHocRecipe toRecipe() {
        return new AdHocRecipe(null, null, null, () -> Recipe.NOOP, null, null, null, Collections.emptyList());
    }

    public static AdHocRecipe toRecipe(Function<Recipe, TreeVisitor<?, ExecutionContext>> visitor) {
        AdHocRecipe r = RewriteTest.toRecipe();
        return r.withGetVisitor(() -> (TreeVisitor)visitor.apply(r));
    }

    public static Recipe fromRuntimeClasspath(String recipe) {
        return Environment.builder().scanRuntimeClasspath(new String[0]).build().activateRecipes(new String[]{recipe});
    }

    default public void assertRecipesConfigure(String packageName) {
        SoftAssertions softly = new SoftAssertions();
        for (Recipe recipe : Environment.builder().scanRuntimeClasspath(new String[]{packageName}).build().listRecipes()) {
            if (!recipe.getName().startsWith(packageName)) continue;
            softly.assertThatCode(() -> {
                try {
                    this.rewriteRun((RecipeSpec spec) -> spec.recipe(recipe), new SourceSpecs[0]);
                }
                catch (Throwable t) {
                    Assertions.fail((String)("Recipe " + recipe.getName() + " failed to configure"), (Throwable)t);
                }
            }).doesNotThrowAnyException();
        }
        softly.assertAll();
    }

    default public void assertRecipesConfigure() {
        this.assertRecipesConfigure(this.getClass().getPackage().getName());
    }

    @Nullable
    default public String doesNotExist() {
        return null;
    }

    default public void defaults(RecipeSpec spec) {
        spec.recipe(Recipe.noop());
    }

    default public void rewriteRun(SourceSpecs ... sourceSpecs) {
        this.rewriteRun((RecipeSpec spec) -> {}, sourceSpecs);
    }

    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpecs ... sourceSpecs) {
        this.rewriteRun(spec, (SourceSpec[])Arrays.stream(sourceSpecs).flatMap(specGroup -> StreamSupport.stream(specGroup.spliterator(), false)).toArray(SourceSpec[]::new));
    }

    /*
     * Could not resolve type clashes
     */
    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpec<?> ... sourceSpecs) {
        int cycles;
        RecipeSpec testClassSpec = RecipeSpec.defaults();
        this.defaults(testClassSpec);
        RecipeSpec testMethodSpec = RecipeSpec.defaults();
        spec.accept(testMethodSpec);
        PrintOutputCapture.MarkerPrinter markerPrinter = testMethodSpec.getMarkerPrinter() != null ? testMethodSpec.getMarkerPrinter() : (testClassSpec.getMarkerPrinter() != null ? testClassSpec.getMarkerPrinter() : PrintOutputCapture.MarkerPrinter.DEFAULT);
        PrintOutputCapture out = new PrintOutputCapture((Object)0, markerPrinter);
        Recipe recipe = testMethodSpec.recipe == null ? testClassSpec.recipe : testMethodSpec.recipe;
        ((ObjectAssert)Assertions.assertThat((Object)recipe).as("A recipe must be specified", new Object[0])).isNotNull();
        ((ListAssert)Assertions.assertThat((List)recipe.validate().failures()).as("Recipe validation must have no failures", new Object[0])).isEmpty();
        if (!(recipe instanceof AdHocRecipe) && testClassSpec.serializationValidation && testMethodSpec.serializationValidation) {
            RecipeSerializer recipeSerializer = new RecipeSerializer();
            ((ObjectAssert)Assertions.assertThat((Object)recipeSerializer.read(recipeSerializer.write(recipe))).as("Recipe must be serializable/deserializable", new Object[0])).isEqualTo((Object)recipe);
            this.validateRecipeNameAndDescription(recipe);
            this.validateRecipeOptions(recipe);
        }
        int n = cycles = testMethodSpec.cycles == null ? testClassSpec.getCycles() : testMethodSpec.getCycles();
        int expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? (testClassSpec.expectedCyclesThatMakeChanges == null ? 0 : testClassSpec.expectedCyclesThatMakeChanges) : testMethodSpec.expectedCyclesThatMakeChanges;
        for (SourceSpec<?> s : sourceSpecs) {
            if (s.after == null) continue;
            expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? testClassSpec.getExpectedCyclesThatMakeChanges(cycles) : testMethodSpec.getExpectedCyclesThatMakeChanges(cycles);
            break;
        }
        RecipeSchedulerCheckingExpectedCycles recipeSchedulerCheckingExpectedCycles = new RecipeSchedulerCheckingExpectedCycles(DirectScheduler.common(), expectedCyclesThatMakeChanges);
        ExecutionContext executionContext = testMethodSpec.getExecutionContext() != null ? testMethodSpec.getExecutionContext() : (testClassSpec.getExecutionContext() != null ? testClassSpec.getExecutionContext() : this.defaultExecutionContext(sourceSpecs));
        for (SourceSpec<?>[] s : sourceSpecs) {
            s.customizeExecutionContext.accept((Object)executionContext);
        }
        HashMap sourceSpecsByParser = new HashMap();
        List<Parser.Builder> methodSpecParsers = testMethodSpec.parsers;
        List<Parser.Builder> testClassSpecParsers = testClassSpec.parsers.stream().map(Parser.Builder::clone).collect(Collectors.toList());
        for (SourceSpec<?> sourceSpec : sourceSpecs) {
            if (RewriteTestUtils.groupSourceSpecsByParser(methodSpecParsers, sourceSpecsByParser, sourceSpec) || RewriteTestUtils.groupSourceSpecsByParser(testClassSpecParsers, sourceSpecsByParser, sourceSpec)) continue;
            sourceSpecsByParser.computeIfAbsent(sourceSpec.getParser().clone(), p -> new ArrayList()).add(sourceSpec);
        }
        HashMap<SourceFile, SourceSpec> specBySourceFile = new HashMap<SourceFile, SourceSpec>(sourceSpecs.length);
        for (Map.Entry sourceSpecsForParser : sourceSpecsByParser.entrySet()) {
            LinkedHashMap<SourceSpec, Parser.Input> inputs = new LinkedHashMap<SourceSpec, Parser.Input>(((List)sourceSpecsForParser.getValue()).size());
            Parser parser = ((Parser.Builder)sourceSpecsForParser.getKey()).build();
            for (SourceSpec sourceSpec : (List)sourceSpecsForParser.getValue()) {
                if (sourceSpec.before == null) continue;
                String beforeTrimmed = sourceSpec.noTrim ? sourceSpec.before : StringUtils.trimIndentPreserveCRLF((String)sourceSpec.before);
                Path sourcePath = sourceSpec.sourcePath != null ? sourceSpec.dir.resolve(sourceSpec.sourcePath) : parser.sourcePathFromSourceText(sourceSpec.dir, beforeTrimmed);
                for (UncheckedConsumer<SourceSpec<?>> consumer : testMethodSpec.allSources) {
                    consumer.accept(sourceSpec);
                }
                for (UncheckedConsumer<SourceSpec<?>> consumer : testClassSpec.allSources) {
                    consumer.accept(sourceSpec);
                }
                inputs.put(sourceSpec, new Parser.Input(sourcePath, () -> new ByteArrayInputStream(beforeTrimmed.getBytes(parser.getCharset(executionContext)))));
            }
            Iterator<UncheckedConsumer<RecipeRun>> relativeTo = testMethodSpec.relativeTo == null ? testClassSpec.relativeTo : testMethodSpec.relativeTo;
            Iterator sourceSpecIter = inputs.keySet().iterator();
            SourceSpec<?>[] sourceFiles = parser.parseInputs(inputs.values(), (Path)((Object)relativeTo), executionContext);
            ((AbstractIntegerAssert)Assertions.assertThat((int)sourceFiles.size()).as("Every input should be parsed into a SourceFile.", new Object[0])).isEqualTo(inputs.size());
            for (int i = 0; i < sourceFiles.size(); ++i) {
                Object marker2;
                SourceFile sourceFile = (SourceFile)sourceFiles.get(i);
                Markers markers = sourceFile.getMarkers();
                SourceSpec nextSpec = (SourceSpec)sourceSpecIter.next();
                for (Object marker2 : nextSpec.getMarkers()) {
                    markers = markers.setByType((Marker)marker2);
                }
                sourceFile = (SourceFile)sourceFile.withMarkers(markers);
                if (nextSpec.sourceSetName != null) {
                    sourceFile = (SourceFile)sourceFile.withMarkers(markers.withMarkers(ListUtils.map((List)markers.getMarkers(), m -> {
                        if (m instanceof SourceSet) {
                            m = ((SourceSet)m).withName(nextSpec.sourceSetName);
                        }
                        return m;
                    })));
                }
                int j = 0;
                marker2 = inputs.values().iterator();
                while (marker2.hasNext()) {
                    Parser.Input input = (Parser.Input)marker2.next();
                    if (j++ != i || sourceFile instanceof Quark) continue;
                    ((AbstractStringAssert)Assertions.assertThat((String)sourceFile.printAll(out.clone())).as("When parsing and printing the source code back to text without modifications, the printed source didn't match the original source code. This means there is a bug in the parser implementation itself. Please open an issue to report this, providing a sample of the code that generated this error!", new Object[0])).isEqualTo(StringUtils.readFully((InputStream)input.getSource(executionContext), (Charset)parser.getCharset(executionContext)));
                }
                SourceFile mapped = (SourceFile)nextSpec.beforeRecipe.apply(sourceFile);
                specBySourceFile.put(mapped, nextSpec);
            }
        }
        ArrayList beforeSourceFiles = new ArrayList(specBySourceFile.keySet());
        for (Object beforeRecipe : testClassSpec.beforeRecipes) {
            beforeRecipe.accept(beforeSourceFiles);
        }
        for (Object beforeRecipe : testMethodSpec.beforeRecipes) {
            beforeRecipe.accept(beforeSourceFiles);
        }
        ArrayList<SourceFile> runnableSourceFiles = new ArrayList<SourceFile>(beforeSourceFiles.size());
        for (Map.Entry sourceFileSpec : specBySourceFile.entrySet()) {
            if (((SourceSpec)sourceFileSpec.getValue()).isSkip()) continue;
            runnableSourceFiles.add((SourceFile)sourceFileSpec.getKey());
        }
        ExecutionContext recipeExecutionContext = executionContext;
        if (testMethodSpec.getRecipeExecutionContext() != null) {
            recipeExecutionContext = testMethodSpec.getRecipeExecutionContext();
        } else if (testClassSpec.getRecipeExecutionContext() != null) {
            recipeExecutionContext = testClassSpec.getRecipeExecutionContext();
        }
        RecipeRun recipeRun = recipe.run(runnableSourceFiles, recipeExecutionContext, (RecipeScheduler)recipeSchedulerCheckingExpectedCycles, cycles, expectedCyclesThatMakeChanges + 1);
        for (Consumer afterRecipe : testClassSpec.afterRecipes) {
            afterRecipe.accept(recipeRun);
        }
        for (Consumer afterRecipe : testMethodSpec.afterRecipes) {
            afterRecipe.accept(recipeRun);
        }
        Collection expectedNewSources = Collections.newSetFromMap(new IdentityHashMap());
        Set expectedNewResults = Collections.newSetFromMap(new IdentityHashMap());
        for (SourceSpec<?> sourceSpec : sourceSpecs) {
            if (sourceSpec.before != null) continue;
            expectedNewSources.add(sourceSpec);
        }
        expectedNewSources = new CopyOnWriteArrayList(expectedNewSources);
        block18: for (SourceSpec sourceSpec : expectedNewSources) {
            String expected;
            String actual;
            ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
            if (sourceSpec.getSourcePath() != null) {
                for (Result result : recipeRun.getResults()) {
                    if (result.getAfter() == null || !sourceSpec.getSourcePath().equals(result.getAfter().getSourcePath())) continue;
                    expectedNewSources.remove(sourceSpec);
                    expectedNewResults.add(result);
                    ((ObjectAssert)Assertions.assertThat((Object)result.getBefore()).as("Expected a new file for the source path but there was an existing file already present: " + sourceSpec.getSourcePath(), new Object[0])).isNull();
                    actual = result.getAfter().printAll(out.clone()).trim();
                    expected = sourceSpec.noTrim ? (String)sourceSpec.after.apply(actual) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual)));
                    ((AbstractStringAssert)Assertions.assertThat((String)actual).as("Unexpected result in \"" + result.getAfter().getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
                    continue block18;
                }
                Assertions.fail((String)("Expected a new source file with the source path " + sourceSpec.getSourcePath()));
            }
            for (Result result : recipeRun.getResults()) {
                if (result.getAfter() == null || result.getAfter() instanceof Remote) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                actual = result.getAfter().printAll(out.clone()).trim();
                if (!actual.equals(expected = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual))))) continue;
                expectedNewSources.remove(sourceSpec);
                expectedNewResults.add(result);
                sourceSpec.afterRecipe.accept(result.getAfter());
                if (sourceSpec.sourcePath == null) break;
                Assertions.assertThat((Path)result.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                break;
            }
            for (Result result : recipeRun.getResults()) {
                if (!(result.getAfter() instanceof Remote)) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                actual = result.getAfter().printAll(out.clone());
                if (!actual.equals(expected = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(actual))))) continue;
                expectedNewSources.remove(sourceSpec);
                sourceSpec.afterRecipe.accept(result.getAfter());
                if (sourceSpec.sourcePath == null) continue block18;
                Assertions.assertThat((Path)result.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                continue block18;
            }
        }
        block22: for (Map.Entry specForSourceFile : specBySourceFile.entrySet()) {
            SourceSpec sourceSpec = (SourceSpec)specForSourceFile.getValue();
            for (Result result : recipeRun.getResults()) {
                if (result.getBefore() == specForSourceFile.getKey()) {
                    if (result.getAfter() != null) {
                        String expectedAfter;
                        String string = expectedAfter = sourceSpec.after == null ? null : (String)sourceSpec.after.apply(result.getAfter().printAll(out.clone()));
                        if (expectedAfter != null) {
                            String actual = result.getAfter().printAll(out.clone());
                            String expected = sourceSpec.noTrim ? expectedAfter : StringUtils.trimIndentPreserveCRLF((String)expectedAfter);
                            ((AbstractStringAssert)Assertions.assertThat((String)actual).as("Unexpected result in \"" + result.getAfter().getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
                            sourceSpec.eachResult.accept(result.getAfter(), testMethodSpec, testClassSpec);
                        } else {
                            if (result.diff().isEmpty() && !(result.getAfter() instanceof Remote)) {
                                Assertions.fail((String)"An empty diff was generated. The recipe incorrectly changed a reference without changing its contents.");
                            }
                            if (!2.$assertionsDisabled && result.getBefore() == null) {
                                throw new AssertionError();
                            }
                            ((AbstractStringAssert)Assertions.assertThat((String)result.getAfter().printAll(out.clone())).as("The recipe must not make changes to \"" + result.getBefore().getSourcePath() + "\"", new Object[0])).isEqualTo(result.getBefore().printAll(out.clone()));
                        }
                    } else if (result.getAfter() == null) {
                        if (sourceSpec.after == null) {
                            if (!2.$assertionsDisabled && result.getBefore() == null) {
                                throw new AssertionError();
                            }
                            Assertions.fail((String)("The recipe deleted a source file \"" + result.getBefore().getSourcePath() + "\" that was not expected to change"));
                        } else {
                            String expected = (String)sourceSpec.after.apply(null);
                            if (expected != null) {
                                if (!2.$assertionsDisabled && result.getBefore() == null) {
                                    throw new AssertionError();
                                }
                                ((AbstractStringAssert)Assertions.assertThat((String)null).as("The recipe deleted a source file \"" + result.getBefore().getSourcePath() + "\" but should have changed it instead", new Object[0])).isEqualTo(expected);
                            }
                        }
                    }
                    try {
                        sourceSpec.afterRecipe.accept(result.getAfter());
                    }
                    catch (ClassCastException classCastException) {}
                    continue block22;
                }
                if (result.getBefore() != null || result.getAfter() instanceof Remote || expectedNewResults.contains(result) || !testMethodSpec.afterRecipes.isEmpty()) continue;
                Assertions.fail((String)("The recipe added a source file \"" + result.getAfter().getSourcePath() + "\" that was not expected."));
            }
            if (sourceSpec.after != null) {
                String before = sourceSpec.noTrim ? ((SourceFile)specForSourceFile.getKey()).printAll(out.clone()) : StringUtils.trimIndentPreserveCRLF((String)((SourceFile)specForSourceFile.getKey()).printAll(out.clone()));
                String expected = sourceSpec.noTrim ? (String)sourceSpec.after.apply(null) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(null)));
                ((AbstractStringAssert)Assertions.assertThat((String)expected).as("To assert that a Recipe makes no change, supply only \"before\" source.", new Object[0])).isNotEqualTo((Object)before);
                ((AbstractStringAssert)Assertions.assertThat((String)before).as("The recipe should have made the following change to \"" + ((SourceFile)specForSourceFile.getKey()).getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
            }
            sourceSpec.afterRecipe.accept((SourceFile)specForSourceFile.getKey());
        }
        SoftAssertions newFilesGenerated = new SoftAssertions();
        for (SourceSpec expectedNewSource : expectedNewSources) {
            ((StringAssert)newFilesGenerated.assertThat(expectedNewSource.after == null ? null : (String)expectedNewSource.after.apply(null)).as("No new source file was generated that matched.", new Object[0])).isEmpty();
        }
        newFilesGenerated.assertAll();
        recipeSchedulerCheckingExpectedCycles.verify();
    }

    default public void rewriteRun(SourceSpec<?> ... sources) {
        this.rewriteRun((RecipeSpec spec) -> {}, sources);
    }

    default public ExecutionContext defaultExecutionContext(SourceSpec<?>[] sourceSpecs) {
        return new InMemoryExecutionContext(t -> Assertions.fail((String)"Failed to parse sources or run recipe", (Throwable)t));
    }

    @Override
    @NonNull
    default public Iterator<SourceSpec<?>> iterator() {
        return new Iterator<SourceSpec<?>>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public SourceSpec<?> next() {
                throw new UnsupportedOperationException("RewriteTest is not intended to be iterated.");
            }
        };
    }

    default public void validateRecipeNameAndDescription(Recipe recipe) {
        if (recipe instanceof CompositeRecipe) {
            for (Recipe childRecipe : recipe.getRecipeList()) {
                this.validateRecipeNameAndDescription(childRecipe);
            }
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)recipe.getDisplayName().endsWith(".")).as("%s Display Name should not end with a period.", new Object[]{recipe.getName()})).isFalse();
            ((AbstractStringAssert)Assertions.assertThat((String)recipe.getDescription()).as("%s Description should not be null or empty", new Object[]{recipe.getName()})).isNotEmpty();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)recipe.getDescription().endsWith(".")).as("%s Description should end with a period.", new Object[]{recipe.getName()})).isTrue();
        }
    }

    default public void validateRecipeOptions(Recipe recipe) {
        for (OptionDescriptor option : recipe.getDescriptor().getOptions()) {
            if (!option.getName().equals("name")) continue;
            Assertions.fail((String)"Recipe option `name` conflicts with the recipe's name. Please use a different field name for this option.");
        }
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

