/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;

public class RecipeSpec {
    @Nullable
    Recipe recipe;
    List<Parser.Builder> parsers = new ArrayList<Parser.Builder>();
    @Nullable
    ExecutionContext executionContext;
    @Nullable
    ExecutionContext recipeExecutionContext;
    @Nullable
    Path relativeTo;
    @Nullable
    Integer cycles;
    @Nullable
    Integer expectedCyclesThatMakeChanges;
    @Nullable
    TypeValidation typeValidation;
    boolean serializationValidation = true;
    @Nullable
    PrintOutputCapture.MarkerPrinter markerPrinter;
    List<UncheckedConsumer<List<SourceFile>>> beforeRecipes = new ArrayList<UncheckedConsumer<List<SourceFile>>>();
    List<UncheckedConsumer<RecipeRun>> afterRecipes = new ArrayList<UncheckedConsumer<RecipeRun>>();
    SourceSpec<SourceFile> allSources = new SourceSpec<SourceFile>(SourceFile.class, null, (Parser.Builder)QuarkParser.builder(), "", null);

    public static RecipeSpec defaults() {
        return new RecipeSpec();
    }

    public SourceSpec<SourceFile> allSources() {
        return this.allSources;
    }

    public RecipeSpec recipe(Recipe recipe) {
        this.recipe = recipe;
        return this;
    }

    public RecipeSpec recipe(InputStream yaml, String ... recipes) {
        return this.recipe(Environment.builder().load((ResourceLoader)new YamlResourceLoader(yaml, URI.create("rewrite.yml"), new Properties())).build().activateRecipes(recipes));
    }

    public RecipeSpec recipe(String yamlResource, String ... recipes) {
        return this.recipe(Objects.requireNonNull(RecipeSpec.class.getResourceAsStream(yamlResource)), recipes);
    }

    public RecipeSpec parser(Parser.Builder parser) {
        this.parsers.add(parser);
        return this;
    }

    public RecipeSpec executionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public RecipeSpec recipeExecutionContext(ExecutionContext executionContext) {
        this.recipeExecutionContext = executionContext;
        return this;
    }

    public RecipeSpec markerPrinter(PrintOutputCapture.MarkerPrinter markerPrinter) {
        this.markerPrinter = markerPrinter;
        return this;
    }

    public RecipeSpec relativeTo(@Nullable Path relativeTo) {
        this.relativeTo = relativeTo;
        return this;
    }

    public RecipeSpec cycles(int cycles) {
        this.cycles = cycles;
        return this;
    }

    public RecipeSpec beforeRecipe(UncheckedConsumer<List<SourceFile>> beforeRecipe) {
        this.beforeRecipes.add(beforeRecipe);
        return this;
    }

    public RecipeSpec afterRecipe(UncheckedConsumer<RecipeRun> afterRecipe) {
        this.afterRecipes.add(afterRecipe);
        return this;
    }

    @Incubating(since="7.35.0")
    public <E> RecipeSpec dataTable(Class<E> rowType, UncheckedConsumer<List<E>> extract) {
        return this.afterRecipe(run -> {
            for (Map.Entry dataTableListEntry : run.getDataTables().entrySet()) {
                if (!((DataTable)dataTableListEntry.getKey()).getType().equals(rowType)) continue;
                List rows = (List)dataTableListEntry.getValue();
                Assertions.assertThat((List)rows).isNotNull();
                Assertions.assertThat((List)rows).isNotEmpty();
                extract.accept(rows);
            }
        });
    }

    @Incubating(since="7.35.0")
    public <E, V> RecipeSpec dataTableAsCsv(Class<DataTable<?>> dataTableClass, String expect) {
        return this.dataTableAsCsv(dataTableClass.getName(), expect);
    }

    @Incubating(since="7.35.0")
    public <E, V> RecipeSpec dataTableAsCsv(String name, String expect) {
        this.afterRecipe(run -> {
            DataTable dataTable = run.getDataTable(name);
            Assertions.assertThat((Object)dataTable).isNotNull();
            List rows = run.getDataTableRows(name);
            StringWriter writer = new StringWriter();
            CsvMapper mapper = (CsvMapper)((CsvMapper.Builder)CsvMapper.builder().disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
            CsvSchema schema = mapper.schemaFor(dataTable.getType()).withHeader();
            mapper.writerFor(dataTable.getType()).with((FormatSchema)schema).writeValues((Writer)writer).writeAll((Collection)rows);
            Assertions.assertThat((String)writer.toString()).isEqualTo(expect);
        });
        return this;
    }

    @Incubating(since="7.35.0")
    public RecipeSpec validateRecipeSerialization(boolean validate) {
        this.serializationValidation = validate;
        return this;
    }

    public RecipeSpec expectedCyclesThatMakeChanges(int expectedCyclesThatMakeChanges) {
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
        return this;
    }

    int getCycles() {
        return this.cycles == null ? 2 : this.cycles;
    }

    int getExpectedCyclesThatMakeChanges(int cycles) {
        return this.expectedCyclesThatMakeChanges == null ? cycles - 1 : this.expectedCyclesThatMakeChanges;
    }

    public RecipeSpec typeValidationOptions(TypeValidation typeValidation) {
        this.typeValidation = typeValidation;
        return this;
    }

    @Nullable
    ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Nullable
    public Recipe getRecipe() {
        return this.recipe;
    }

    public List<Parser.Builder> getParsers() {
        return this.parsers;
    }

    @Nullable
    public ExecutionContext getRecipeExecutionContext() {
        return this.recipeExecutionContext;
    }

    @Nullable
    public Path getRelativeTo() {
        return this.relativeTo;
    }

    @Nullable
    public Integer getExpectedCyclesThatMakeChanges() {
        return this.expectedCyclesThatMakeChanges;
    }

    @Nullable
    public TypeValidation getTypeValidation() {
        return this.typeValidation;
    }

    public boolean isSerializationValidation() {
        return this.serializationValidation;
    }

    @Nullable
    public PrintOutputCapture.MarkerPrinter getMarkerPrinter() {
        return this.markerPrinter;
    }

    public List<UncheckedConsumer<List<SourceFile>>> getBeforeRecipes() {
        return this.beforeRecipes;
    }

    public List<UncheckedConsumer<RecipeRun>> getAfterRecipes() {
        return this.afterRecipes;
    }

    public SourceSpec<SourceFile> getAllSources() {
        return this.allSources;
    }
}

