/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.RecipeScheduler;
import org.openrewrite.SourceFile;
import org.openrewrite.quark.Quark;

class RecipeSchedulerCheckingExpectedCycles
implements RecipeScheduler {
    private final RecipeScheduler delegate;
    private final int expectedCyclesThatMakeChanges;
    private int cyclesThatResultedInChanges = 0;

    public <T> CompletableFuture<T> schedule(Callable<T> fn) {
        return this.delegate.schedule(fn);
    }

    public <S extends SourceFile> List<S> scheduleVisit(RecipeRunStats runStats, Stack<Recipe> recipeStack, List<S> before, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile) {
        ctx.putMessage("cyclesThatResultedInChanges", (Object)this.cyclesThatResultedInChanges);
        List afterList = this.delegate.scheduleVisit(runStats, recipeStack, before, ctx, recipeThatAddedOrDeletedSourceFile);
        if (afterList != before) {
            ++this.cyclesThatResultedInChanges;
            if (this.cyclesThatResultedInChanges > this.expectedCyclesThatMakeChanges && !before.isEmpty() && !afterList.isEmpty()) {
                for (int i = 0; i < before.size(); ++i) {
                    if (afterList.get(i) instanceof Quark) continue;
                    ((AbstractStringAssert)Assertions.assertThat((String)((SourceFile)afterList.get(i)).printAllTrimmed()).as("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges == 1 ? "" : "s") + ", but took at least one more cycle. Between the last two executed cycles there were changes to \"" + ((SourceFile)before.get(i)).getSourcePath() + "\"", new Object[0])).isEqualTo(((SourceFile)before.get(i)).printAllTrimmed());
                }
            }
        }
        return afterList;
    }

    public void verify() {
        if (this.cyclesThatResultedInChanges != this.expectedCyclesThatMakeChanges) {
            Assertions.fail((String)("Expected recipe to complete in " + this.expectedCyclesThatMakeChanges + " cycle" + (this.expectedCyclesThatMakeChanges > 1 ? "s" : "") + ", but took " + this.cyclesThatResultedInChanges + " cycle" + (this.cyclesThatResultedInChanges > 1 ? "s" : "") + "."));
        }
    }

    public RecipeSchedulerCheckingExpectedCycles(RecipeScheduler delegate, int expectedCyclesThatMakeChanges) {
        this.delegate = delegate;
        this.expectedCyclesThatMakeChanges = expectedCyclesThatMakeChanges;
    }
}

