/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0001!J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J-\u0010\u0006\u001a\u00020\u00072\u001e\u0010\b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\"\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u001a\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\""}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addImportIfReferenced", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addImports", "Lorg/openrewrite/Recipe;", "adds", "", "Lorg/openrewrite/java/AddImport;", "Lorg/openrewrite/ExecutionContext;", "([Lorg/openrewrite/java/AddImport;)Lorg/openrewrite/Recipe;", "addMultipleImports", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticImportField", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "dontAddImportForPrimitive", "dontAddImportForStaticImportsIndirectlyReferenced", "Lorg/openrewrite/java/JavaParser$Builder;", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "FixEmptyListMethodType", "rewrite-test"})
public interface AddImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe addImports(AddImport<ExecutionContext> ... var1);

    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addImportIfReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void addStaticImportField(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/Recipe;", "()V", "getDisplayName", "", "getVisitor", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-test"})
    private static final class FixEmptyListMethodType
    extends Recipe {
        @NotNull
        public String getDisplayName() {
            return "Fix Empty List";
        }

        @NotNull
        protected TreeVisitor<?, ExecutionContext> getVisitor() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.MethodInvocation methodInvocation = super.visitMethodInvocation(method, (Object)ctx);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation, (String)"super.visitMethodInvocation(method, ctx)");
                    J.MethodInvocation original = methodInvocation;
                    if (Intrinsics.areEqual((Object)original.getName().getSimpleName(), (Object)"emptyList")) {
                        methodInvocation = original.withSelect(null);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation, (String)"original.withSelect(null)");
                        return methodInvocation;
                    }
                    return original;
                }
            };
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Recipe addImports(@NotNull AddImportTest this_, AddImport<ExecutionContext> ... adds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            AddImport<ExecutionContext>[] $this$map$iv = adds;
            boolean $i$f$map = false;
            AddImport<ExecutionContext>[] addImportArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo2 = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void add;
                void item$iv$iv;
                void var11_13 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                RecipeTest.AdHocRecipe adHocRecipe = this_.toRecipe((TreeVisitor)add);
                collection.add(adHocRecipe);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                void r2;
                RecipeTest.AdHocRecipe $i$f$mapTo2 = (RecipeTest.AdHocRecipe)((Object)iterator$iv.next());
                RecipeTest.AdHocRecipe r1 = (RecipeTest.AdHocRecipe)((Object)accumulator$iv);
                Recipe recipe2 = r1.doNext((Recipe)r2);
                Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"r1.doNext(r2)");
                return recipe2;
            }
            return (Recipe)accumulator$iv;
        }

        @Test
        public static void addMultipleImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false), new AddImport("java.util.Set", null, false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "\n            class A {}\n        ", null, "\n            import java.util.List;\n            import java.util.Set;\n\n            class A {}\n        ", 0, 40, null);
        }

        @Test
        public static void addNamedImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "class A {}", null, "\n            import java.util.List;\n            \n            class A {}\n        ", 0, 40, null);
        }

        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, true)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ");
        }

        @Test
        public static void addImportIfReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)p);
                    J.Block b = c.getBody();
                    String[] stringArray = new String[]{"java.math.BigDecimal", "java.math.RoundingMode"};
                    b = (J.Block)b.withTemplate(this.template("BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);").imports(stringArray).build(), b.getCoordinates().lastStatement(), new Object[0]);
                    this.maybeAddImport("java.math.BigDecimal");
                    this.maybeAddImport("java.math.RoundingMode");
                    stringArray = c.withBody(b);
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"c.withBody(b)");
                    return stringArray;
                }
            }), "\n            package a;\n\n            class A {\n            }\n        ", null, "\n            package a;\n            \n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.*", null, true)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ");
        }

        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "\n            import java.util.List;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", 0, 40, null);
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 40, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Iterable pkg;
            Object object;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new String[]{"c", "c.c", "c.c.c"};
            List otherPackages = CollectionsKt.listOf((Object[])objectArray);
            Object[] $this$mapIndexed$iv = (Object[])otherPackages;
            boolean $i$f$mapIndexed = false;
            Object[] objectArray2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (AddImport[])item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                String string = "package " + (String)((Object)pkg) + ";\npublic class C" + (int)i + " {}";
                collection.add(string);
            }
            List otherImports = (List)destination$iv$iv;
            $this$mapIndexed$iv = new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])$this$mapIndexed$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapIndexedTo$iv$iv2;
                Pair it;
                Pair pair = it = (Pair)element$iv;
                String pkg2 = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                pkg = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void i;
                    void otherPkg;
                    int n = index$iv$iv2++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv$iv;
                    int n3 = n;
                    Collection collection = destination$iv$iv2;
                    String string2 = (String)otherPkg + ".C" + (int)i;
                    collection.add(string2);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, Intrinsics.stringPlus((String)pkg2, (Object)".B"));
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                spreadBuilder.addSpread((Object)stringArray);
                spreadBuilder.add((Object)("\n                            package " + pkg2 + ";\n                            public class B {}\n                        "));
                String[] stringArray2 = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
                object = new AddImport[]{new AddImport(Intrinsics.stringPlus((String)pkg2, (Object)".B"), null, false)};
                spreadBuilder = this_.addImports((AddImport<ExecutionContext>)object);
                object = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.1.INSTANCE, (int)30, null) + "\n\nclass A {}";
                RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)spreadBuilder, "\n                    package a;\n        \n                    import c.C0;\n                    import c.c.C1;\n                    import c.c.c.C2;\n        \n                    class A {}\n                ", stringArray2, (String)object, 0, 32, null);
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ");
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ");
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("C", null, false)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "class A {}");
        }

        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("int", null, false)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "class A {}");
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.List", null, false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n            \n            class A {}\n        ", 0, 40, null);
        }

        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", false)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, this_.addImports(addImportArray), "\n            import java.util.*;\n            class A {}\n        ", null, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {}\n        ", 0, 40, null);
        }

        @Test
        public static void addStaticImportField(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new AddImport[]{new AddImport("mycompany.Type", "FIELD", false)};
            Recipe recipe2 = this_.addImports((AddImport<ExecutionContext>[])objectArray);
            String[] stringArray = new String[]{"\n                package mycompany;\n                public class Type {\n                    public static String FIELD;\n                }\n            "};
            objectArray = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, recipe2, "class A {}", (String[])objectArray, "\n            import static mycompany.Type.FIELD;\n            \n            class A {}\n        ", 0, 32, null);
        }

        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", true)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ");
        }

        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", true)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, new Recipe(){

                @NotNull
                public String getDisplayName() {
                    return "Test";
                }

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation m, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return m.withSelect(null);
                        }
                    };
                }
            }.doNext(this_.addImports(addImportArray)), "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "emptyList", true)};
            this_.assertUnchanged((Parser)jp, this_.addImports(addImportArray), "\n            package a;\n            \n            class A {}\n        ");
        }

        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            AddImport[] addImportArray = new AddImport[]{new AddImport("java.util.Collections", "*", true)};
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, new FixEmptyListMethodType().doNext(this_.addImports(addImportArray)), "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull AddImportTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Object object = new String[]{"jackson-databind"};
            JavaParser javaParser = jp.classpath(object).build();
            object = this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.CompilationUnit visitCompilationUnit(@NotNull J.CompilationUnit cu2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)cu2, (String)"cu");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.maybeAddImport("com.fasterxml.jackson.databind.ObjectMapper");
                    J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu2, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"super.visitCompilationUnit(cu, p)");
                    return compilationUnit;
                }
            });
            String[] stringArray = new String[]{"\n                import com.fasterxml.jackson.databind.ObjectMapper;\n                class Helper {\n                    static ObjectMapper OBJECT_MAPPER;\n                }\n            "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged((Parser)javaParser, (Recipe)object, "\n            class Test {\n                void test() {\n                    Helper.OBJECT_MAPPER.writer();\n                }\n            }\n        ", stringArray2);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull AddImportTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull AddImportTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

