/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u001e\u001a\u00020\u0007H\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006!"}, d2={"Lorg/openrewrite/java/RemoveUnusedImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "doNotRemoveInnerClassImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "doNotUnfoldStaticValidWildCard", "doesNotAffectClassBodyFormatting", "doesNotRemoveStaticReferenceToNewClass", "dontRemoveStaticReferenceToPrimitiveField", "ensuresWhitespaceAfterPackageDeclarationNoImportsRemain", "leaveImportForStaticImportEnumInAnnotation", "leaveImportIfRemovedTypeIsStillReferredTo", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfMoreThanStarCount", "leaveStarStaticImportIfReferenceStillExists", "removeNamedImport", "removePackageInfoImports", "removePackageInfoStarImports", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStaticImportIfNotReferenced", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "resultSetType", "unfoldIfLessThanStarCount", "unfoldStaticUses", "usedInJavadoc", "usedInJavadocWithThrows", "rewrite-test"})
public interface RemoveUnusedImportsTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void doNotRemoveInnerClassImport(@NotNull JavaParser var1);

    @Test
    public void usedInJavadocWithThrows(@NotNull JavaParser var1);

    @Test
    public void usedInJavadoc(@NotNull JavaParser var1);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void leaveImportForStaticImportEnumInAnnotation(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void unfoldIfLessThanStarCount(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfMoreThanStarCount(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removePackageInfoImports(@NotNull JavaParser var1);

    @Test
    public void removePackageInfoStarImports(@NotNull JavaParser var1);

    @Test
    public void dontRemoveStaticReferenceToPrimitiveField(@NotNull JavaParser var1);

    @Test
    public void resultSetType(@NotNull JavaParser var1);

    @Test
    public void ensuresWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull JavaParser var1);

    @Test
    public void doesNotAffectClassBodyFormatting(@NotNull JavaParser var1);

    @Test
    public void doesNotRemoveStaticReferenceToNewClass();

    @Test
    public void doNotUnfoldStaticValidWildCard();

    @Test
    public void unfoldStaticUses();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new RemoveUnusedImports();
        }

        @Test
        public static void doNotRemoveInnerClassImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.Map.Entry;\n\n            public abstract class MyMapEntry<K, V> implements Entry<K, V> {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void usedInJavadocWithThrows(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.time.DateTimeException;\n            \n            class A {\n                /** \n                 * @throws DateTimeException when ...\n                 */\n                void foo() {}\n            }\n        ", null, 10, null);
        }

        @Test
        public static void usedInJavadoc(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.List;\n            import java.util.Collection;\n            \n            /** {@link List} */\n            class A {\n                /** {@link Collection} */\n                void foo() {}\n            }\n        ", null, 10, null);
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.List;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 490, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.List;\n            class A {\n               List<Integer> list;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void leaveImportForStaticImportEnumInAnnotation(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite.test;\n            \n            public @interface YesOrNo {\n                Status status();\n                enum Status {\n                    YES, NO\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package org.openrewrite.test;\n            \n            import static org.openrewrite.test.YesOrNo.Status.YES;\n            \n            @YesOrNo(status = YES)\n            public class Foo {}\n        ", stringArray2, 2, null);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 490, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.*;\n            \n            class A {\n                Collection<Integer> c;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            class A {\n                Collection<Integer> c;\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void unfoldIfLessThanStarCount(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n            }\n        ", null, "\n            import java.util.Collection;\n            import java.util.HashSet;\n            import java.util.Set;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfMoreThanStarCount(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n               List<String> l = Arrays.asList(\"a\",\"b\",\"c\");\n            }\n        ", null, 10, null);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 490, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", null, "import static java.util.Collections.emptyList;\nclass A {\n   Object o = emptyList();\n}", 0, 0, null, null, 490, null);
        }

        @Test
        public static void removeStaticImportIfNotReferenced(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package foo;\n                public class B {\n                    public static final String STRING = \"string\";\n                    public static final String STRING2 = \"string2\";\n                }\n            ", "\n                package foo;\n                public class C {\n                    public static final String ANOTHER = \"string\";\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", stringArray2, "\n            import static foo.B.STRING;\n            \n            public class A {\n                String a = STRING;\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void removePackageInfoImports(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n            import foo.FooAnnotation;\n        ", stringArray2, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void removePackageInfoStarImports(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package foo;\n                public @interface FooAnnotation {}\n                public @interface Foo {}\n                public @interface Bar {}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.*;\n        ", stringArray2, "\n            @Foo\n            @Bar\n            package foo.bar.baz;\n            \n            import foo.Bar;\n            import foo.Foo;\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void dontRemoveStaticReferenceToPrimitiveField(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import static java.sql.ResultSet.TYPE_FORWARD_ONLY;\n            public class A {\n                int t = TYPE_FORWARD_ONLY;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void resultSetType(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.sql.ResultSet;\n            public class A {\n                int t = ResultSet.TYPE_FORWARD_ONLY;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void ensuresWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            package com.example.foo;\n            import java.util.List;\n            public class A {\n            }\n        ", null, "\n            package com.example.foo;\n            \n            public class A {\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void doesNotAffectClassBodyFormatting(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure formatting is not overzealous\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure formatting is not overzealous\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void doesNotRemoveStaticReferenceToNewClass(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Bar {\n                public static final class Buz {\n                    public Buz() {}\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            package foo.test;\n\n            import static org.openrewrite.Bar.Buz;\n\n            public class Test {\n                private void method() {\n                    new Buz();\n                }\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        public static void doNotUnfoldStaticValidWildCard(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Foo {\n                public static final int FOO_CONSTANT = 10;\n                public static final class Bar {\n                    private Bar() {}\n                    public static void helper() {}\n                }\n                public static void fooMethod() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            package foo.test;\n            \n            import static org.openrewrite.Foo.*;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    fooMethod();\n                    Bar.helper();\n                }\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        public static void unfoldStaticUses(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Foo {\n                public static final int FOO_CONSTANT = 10;\n                public static final class Bar {\n                    private Bar(){}\n                    public static void helper() {}\n                }\n                public static void fooMethod() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            package foo.test;\n            \n            import static org.openrewrite.Foo.*;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    Bar.helper();\n                }\n            }\n        ", stringArray2, "\n            package foo.test;\n            \n            import static org.openrewrite.Foo.FOO_CONSTANT;\n            import static org.openrewrite.Foo.Bar;\n            \n            public class Test {\n                int val = FOO_CONSTANT;\n                private void method() {\n                    Bar.helper();\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnusedImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnusedImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnusedImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull RemoveUnusedImportsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveUnusedImportsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveUnusedImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }
    }
}

