/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/MethodMatcherTest;", "", "argRegex", "Lkotlin/text/Regex;", "signature", "", "dotDotMatchesArrayArgs", "", "jp", "Lorg/openrewrite/java/JavaParser;", "matchesArguments", "matchesArgumentsWithDotDot", "matchesArgumentsWithWildcards", "matchesArrayArguments", "matchesConstructorUsage", "matchesMethod", "matchesMethodName", "matchesMethodNameWithDotSeparator", "matchesMethodNameWithPoundSeparator", "matchesMethodSymbolsWithVarargs", "matchesMethodTargetType", "matchesMethodWithWildcardForClassInPackage", "matchesMethodWithWildcardForClassNotInPackage", "matchesPrimitiveArgument", "matchesSuperclassArgumentTypes", "matchesSuperclassType", "matchesUnqualifiedJavaLangArguments", "matchesWildcardedMethodNameStartingWithJavaKeyword", "nameRegex", "typeRegex", "wildcardType", "rewrite-test"})
public interface MethodMatcherTest {
    @NotNull
    public Regex typeRegex(@NotNull String var1);

    @NotNull
    public Regex nameRegex(@NotNull String var1);

    @NotNull
    public Regex argRegex(@NotNull String var1);

    @Test
    public void matchesSuperclassType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodTargetType(@NotNull JavaParser var1);

    @Test
    public void matchesMethodNameWithDotSeparator(@NotNull JavaParser var1);

    @Test
    public void matchesMethodNameWithPoundSeparator(@NotNull JavaParser var1);

    @Test
    public void matchesMethodName(@NotNull JavaParser var1);

    @Test
    public void matchesArguments(@NotNull JavaParser var1);

    @Test
    public void matchesUnqualifiedJavaLangArguments(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithWildcards(@NotNull JavaParser var1);

    @Test
    public void matchesArgumentsWithDotDot(@NotNull JavaParser var1);

    @Test
    public void matchesSuperclassArgumentTypes(@NotNull JavaParser var1);

    @Test
    public void matchesMethodSymbolsWithVarargs(@NotNull JavaParser var1);

    @Test
    public void dotDotMatchesArrayArgs(@NotNull JavaParser var1);

    @Test
    public void matchesArrayArguments(@NotNull JavaParser var1);

    @Test
    public void matchesPrimitiveArgument(@NotNull JavaParser var1);

    @Test
    public void matchesConstructorUsage(@NotNull JavaParser var1);

    @Test
    public void matchesMethod(@NotNull JavaParser var1);

    @Test
    public void matchesMethodWithWildcardForClassInPackage(@NotNull JavaParser var1);

    @Test
    public void matchesMethodWithWildcardForClassNotInPackage(@NotNull JavaParser var1);

    @Test
    public void matchesWildcardedMethodNameStartingWithJavaKeyword(@NotNull JavaParser var1);

    @Test
    public void wildcardType(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Regex typeRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getTargetTypePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).targetTypePattern");
            boolean bl = false;
            return new Regex(pattern);
        }

        @NotNull
        public static Regex nameRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getMethodNamePattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).methodNamePattern");
            boolean bl = false;
            return new Regex(pattern);
        }

        @NotNull
        public static Regex argRegex(@NotNull MethodMatcherTest this_, @NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Pattern pattern = new MethodMatcher(signature).getArgumentPattern();
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"MethodMatcher(signature).argumentPattern");
            boolean bl = false;
            return new Regex(pattern);
        }

        @Test
        public static void matchesSuperclassType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test { java.util.List l; }"};
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)jp.parse(stringArray).get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            JavaType.FullyQualified listType = ((J.VariableDeclarations)e).getTypeAsFullyQualified();
            Assertions.assertTrue((boolean)new MethodMatcher("java.util.Collection size()", true).matchesTargetType(listType));
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodTargetType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.typeRegex("*..MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("MyClass foo()").matches((CharSequence)"MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("com.bar.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
            Assertions.assertTrue((boolean)this_.typeRegex("com.*.MyClass foo()").matches((CharSequence)"com.bar.MyClass"));
        }

        @Test
        public static void matchesMethodNameWithDotSeparator(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A.foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A.*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A.fo*()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesMethodNameWithPoundSeparator(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A#foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#fo*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A#*oo()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesMethodName(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A foo()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A *()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A fo*()").matches((CharSequence)"foo"));
            Assertions.assertTrue((boolean)this_.nameRegex("A *oo()").matches((CharSequence)"foo"));
        }

        @Test
        public static void matchesArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo()").matches((CharSequence)""));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java.util.Map)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesUnqualifiedJavaLangArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(String)").matches((CharSequence)"java.lang.String"));
        }

        @Test
        public static void matchesArgumentsWithWildcards(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java.util.*)").matches((CharSequence)"java.util.Map"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(java..*)").matches((CharSequence)"java.util.Map"));
        }

        @Test
        public static void matchesArgumentsWithDotDot(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(.., int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(.., int)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int, ..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int, ..)").matches((CharSequence)"int,int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)""));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(..)").matches((CharSequence)"int,int"));
        }

        @Test
        public static void matchesSuperclassArgumentTypes(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("Object equals(Object)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.String")));
            Assertions.assertFalse((boolean)new MethodMatcher("String equals(String)").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object")));
        }

        @Test
        public static void matchesMethodSymbolsWithVarargs(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.argRegex("A foo(String, Object...)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void dotDotMatchesArrayArgs(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.argRegex("A foo(..)").matches((CharSequence)"String,Object[]");
        }

        @Test
        public static void matchesArrayArguments(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(String[])").matches((CharSequence)"java.lang.String[]"));
        }

        @Test
        public static void matchesPrimitiveArgument(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int)").matches((CharSequence)"int"));
            Assertions.assertTrue((boolean)this_.argRegex("A foo(int[])").matches((CharSequence)"int[]"));
            Assertions.assertFalse((boolean)this_.argRegex("A foo(int[])").matches((CharSequence)"int"));
        }

        @Test
        public static void matchesConstructorUsage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package a;\nclass A { \n    A a = new A(); \n}"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            MethodMatcher methodMatcher = new MethodMatcher("a.A <constructor>()");
            List list = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.classes");
            List list2 = ((J.ClassDeclaration)CollectionsKt.first((List)list)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cu.classes.first().body.statements");
            Object object = CollectionsKt.first((List)list2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            }
            List list3 = ((J.VariableDeclarations)object).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"cu.classes.first().body.statements.first() as J.VariableDeclarations)\n                    .variables");
            stringArray = ((J.VariableDeclarations.NamedVariable)CollectionsKt.first((List)list3)).getInitializer();
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
            }
            Assertions.assertTrue((boolean)methodMatcher.matches((J.NewClass)stringArray));
        }

        @Test
        public static void matchesMethod(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"package a;\n\nclass A {\n    void setInt(int value) {}\n    int getInt() {}\n    void setInteger(Integer value) {}\n    Integer getInteger(){}\n}"};
            List list = jp.parse(object);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\"\n            package a;\n            \n            class A {\n                void setInt(int value) {}\n                int getInt() {}\n                void setInteger(Integer value) {}\n                Integer getInteger(){}\n            }\n        \"\"\".trimIndent()\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            object = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)object);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration setIntMethod = (J.MethodDeclaration)e;
            Object e2 = classDecl2.getBody().getStatements().get(1);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration getIntMethod = (J.MethodDeclaration)e2;
            Object e3 = classDecl2.getBody().getStatements().get(2);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration setIntegerMethod = (J.MethodDeclaration)e3;
            Object e4 = classDecl2.getBody().getStatements().get(3);
            if (e4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration getIntegerMethod = (J.MethodDeclaration)e4;
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInt(int)").matches(setIntMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInt()").matches(getIntMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A setInteger(Integer)").matches(setIntegerMethod, classDecl2));
            Assertions.assertTrue((boolean)new MethodMatcher("a.A getInteger()").matches(getIntegerMethod, classDecl2));
        }

        @Test
        public static void matchesMethodWithWildcardForClassInPackage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            package a;\n            \n            class A {\n                void foo() {}\n            }\n        "};
            List list = jp.parse(object);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\"\n            package a;\n            \n            class A {\n                void foo() {}\n            }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            object = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)object);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration fooMethod = (J.MethodDeclaration)e;
            Assertions.assertTrue((boolean)new MethodMatcher("* foo(..)").matches(fooMethod, classDecl2));
        }

        @Test
        public static void matchesMethodWithWildcardForClassNotInPackage(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            class A {\n                void foo() {}\n            }\n        "};
            List list = jp.parse(object);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\n            \"\"\"\n            class A {\n                void foo() {}\n            }\n        \"\"\"\n        )");
            J.CompilationUnit cu = (J.CompilationUnit)CollectionsKt.first((List)list);
            object = cu.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cu.classes");
            J.ClassDeclaration classDecl2 = (J.ClassDeclaration)CollectionsKt.first((List)object);
            Object e = classDecl2.getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.MethodDeclaration fooMethod = (J.MethodDeclaration)e;
            Assertions.assertTrue((boolean)new MethodMatcher("* foo(..)").matches(fooMethod, classDecl2));
        }

        @Test
        public static void matchesWildcardedMethodNameStartingWithJavaKeyword(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)this_.nameRegex("A assert*()").matches((CharSequence)"assertThat"));
        }

        @Test
        public static void wildcardType(@NotNull MethodMatcherTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Assertions.assertTrue((boolean)new MethodMatcher("*..* build()").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"javax.ws.rs.core.Response")));
            Assertions.assertTrue((boolean)new MethodMatcher("javax..* build()").matchesTargetType((JavaType.FullyQualified)JavaType.Class.build((String)"javax.ws.rs.core.Response")));
        }
    }
}

