/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.NoDoubleBraceInitialization;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/cleanup/NoDoubleBraceInitializationTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "addStatementInForLoop", "", "doubleBraceInitWithinConstructorArg", "doubleBraceInitializationForFieldVar", "doubleBranchInitializationForArg", "doubleBranchInitializationForNewClassArg", "memberVar", "selectIsThis", "rewrite-test"})
public interface NoDoubleBraceInitializationTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void doubleBranchInitializationForArg();

    @Test
    public void doubleBranchInitializationForNewClassArg();

    @Test
    public void doubleBraceInitWithinConstructorArg();

    @Test
    public void addStatementInForLoop();

    @Test
    public void doubleBraceInitializationForFieldVar();

    @Test
    public void memberVar();

    @Test
    public void selectIsThis();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new NoDoubleBraceInitialization();
        }

        @Test
        public static void doubleBranchInitializationForArg(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                void m1(Map<String, String> map) {\n                }\n                void m2() {\n                    m1(new HashMap<String, String>(){{put(\"a\", \"a\");}});\n                }\n            }\n        ", null, 11, null);
        }

        @Test
        public static void doubleBranchInitializationForNewClassArg(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package abc;\n            import java.util.List;\n            \n            public class Thing {\n                private final List<String> stuff;\n                public Thing(List<String> stuff) {\n                    this.stuff = stuff;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            package abc;\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            class A {\n                Thing t = new Thing(new ArrayList<String>(){{add(\"abc\"); add(\"def\");}});\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        public static void doubleBraceInitWithinConstructorArg(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.List;\n            import java.util.Collections;\n            import java.util.ArrayList;\n            class A {\n                private final List<String> expectedCommand =\n                  Collections.unmodifiableList(\n                      new ArrayList<String>() {\n                        {\n                          add(\"a\");\n                          add(\"b\");\n                        }\n                      });\n            }\n        ", null, 11, null);
        }

        @Test
        public static void addStatementInForLoop(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Set;\n            import java.util.LinkedHashSet;\n            class A {\n                void a() {\n                    Integer CNT = 10;\n                    final Set<Integer> keys = new LinkedHashSet(){{\n                        for (int i = 0; i < CNT; i++) {\n                            add(i);\n                        }\n                    }};\n                }\n            }\n        ", null, "\n            import java.util.Set;\n            import java.util.LinkedHashSet;\n            class A {\n                void a() {\n                    Integer CNT = 10;\n                    final Set<Integer> keys = new LinkedHashSet();\n                    for (int i = 0; i < CNT; i++) {\n                        keys.add(i);\n                    }\n                }\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void doubleBraceInitializationForFieldVar(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.ArrayList;\n            import java.util.HashMap;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            \n            class A {\n                private static final Map<String, String> map = new HashMap() {{put(\"a\", \"a\");}};\n                private final List<String> lst = new ArrayList() {{add(\"x\");add(\"y\");}};\n                private final Set<String> mySet = new HashSet(){{add(\"q\");}};\n            }\n        ", null, "\n            import java.util.ArrayList;\n            import java.util.HashMap;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            \n            class A {\n                private static final Map<String, String> map;\n                static {\n                    map = new HashMap<>();\n                    map.put(\"a\", \"a\");\n                }\n                private final List<String> lst;\n                {\n                    lst = new ArrayList<>();\n                    lst.add(\"x\");\n                    lst.add(\"y\");\n                }\n                private final Set<String> mySet;\n                {\n                    mySet = new HashSet<>();\n                    mySet.add(\"q\");\n                }\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void memberVar(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                void example() {\n                    Map<String, String> aMap = new HashMap<>();\n                    aMap.put(\"c\", \"c\");\n                    String s = \"x\";\n                    Map<String, String> bMap = new HashMap(){{\n                        s.concat(\"z\");\n                        put(\"a\", \"A\");\n                        put(\"b\", \"B\");\n                    }};\n                }\n            }\n        ", null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                void example() {\n                    Map<String, String> aMap = new HashMap<>();\n                    aMap.put(\"c\", \"c\");\n                    String s = \"x\";\n                    Map<String, String> bMap = new HashMap();\n                    s.concat(\"z\");\n                    bMap.put(\"a\", \"A\");\n                    bMap.put(\"b\", \"B\");\n                }\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void selectIsThis(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                void example() {\n                    Map<String, String> bMap = new HashMap(){{\n                        this.put(\"a\", \"A\");\n                        this.put(\"b\", \"B\");\n                    }};\n                }\n            }\n        ", null, "\n            import java.util.HashMap;\n            import java.util.Map;\n            class A {\n                void example() {\n                    Map<String, String> bMap = new HashMap();\n                    bMap.put(\"a\", \"A\");\n                    bMap.put(\"b\", \"B\");\n                }\n            }\n        ", 0, 0, null, null, 491, null);
        }

        public static void assertChangedBase(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull NoDoubleBraceInitializationTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NoDoubleBraceInitializationTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NoDoubleBraceInitializationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }
    }
}

