/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.RemoveImportTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/RemoveImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "doesNotAffectClassBodyFormatting", "", "jp", "Lorg/openrewrite/java/JavaParser;", "generateNewUUIDPerUnfoldedImport", "leaveAloneIfThreeOrMoreStaticsAreInUse", "leaveImportIfRemovedTypeIsStillReferredTo", "leaveNamedStaticImportIfReferenceStillExists", "leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "preservesWhitespaceAfterPackageDeclaration", "preservesWhitespaceAfterPackageDeclarationNoImportsRemain", "preservesWhitespaceAfterRemovedImport", "preservesWhitespaceBetweenGroupsOfImports", "removeFromWildcardAndDuplicateImport", "removeImport", "Lorg/openrewrite/Recipe;", "type", "", "force", "", "removeNamedImport", "removeStarImportEvenIfReferredTo", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStarStaticImportWhenRemovingSpecificMethod", "removeStaticImport", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "unfoldStaticImportIfTwoOrLessAreUsed", "rewrite-test"})
public interface RemoveImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe removeImport(@NotNull String var1, boolean var2);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImportWhenRemovingSpecificMethod(@NotNull JavaParser var1);

    @Test
    public void removeStarImportEvenIfReferredTo(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterRemovedImport(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceBetweenGroupsOfImports(@NotNull JavaParser var1);

    @Test
    public void doesNotAffectClassBodyFormatting(@NotNull JavaParser var1);

    @Test
    public void removeFromWildcardAndDuplicateImport(@NotNull JavaParser var1);

    @Test
    public void generateNewUUIDPerUnfoldedImport(@NotNull JavaParser var1);

    @Test
    public void leaveAloneIfThreeOrMoreStaticsAreInUse(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticImportIfTwoOrLessAreUsed(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe removeImport(@NotNull RemoveImportTest this_, @NotNull String type, boolean force) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this_.toRecipe((Function0)new Function0<TreeVisitor<?, ExecutionContext>>(type, force){
                final /* synthetic */ String $type;
                final /* synthetic */ boolean $force;
                {
                    this.$type = $type;
                    this.$force = $force;
                    super(0);
                }

                @NotNull
                public final TreeVisitor<?, ExecutionContext> invoke() {
                    return (TreeVisitor)new RemoveImport(this.$type, this.$force);
                }
            });
        }

        public static /* synthetic */ Recipe removeImport$default(RemoveImportTest removeImportTest, String string, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeImport");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return removeImportTest.removeImport(string, bl);
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            import java.util.List;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            import java.util.List;\n            class A {\n               List<Integer> list;\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            import java.util.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            import java.util.*;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n               Map<Integer, Integer> m = new HashMap<>();\n            }\n        ", null, 8, null);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.Collections", false, 2, null), "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void removeStarStaticImportWhenRemovingSpecificMethod(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.Collections.emptyList", false, 2, null), "\n            import static java.util.Collections.*;\n            class A {\n                Object o = emptySet();\n            }\n        ", null, "\n            import static java.util.Collections.emptySet;\n            class A {\n                Object o = emptySet();\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void removeStarImportEvenIfReferredTo(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.removeImport("java.util.List", true), "\n            import java.util.List;\n            class A {\n                List<String> l;\n            }\n        ", null, "\n            class A {\n                List<String> l;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.Collections", false, 2, null), "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", null, "import static java.util.Collections.emptyList;\nclass A {\n   Object o = emptyList();\n}", 0, 0, null, null, 488, null);
        }

        @Test
        public static void removeStaticImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.time.DayOfWeek.MONDAY", false, 2, null), "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.Collections", false, 2, null), "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void preservesWhitespaceAfterPackageDeclaration(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<String> foo = new ArrayList<>();\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<String> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void preservesWhitespaceAfterRemovedImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            package com.example.foo;\n            \n            import java.util.Collection;\n            import java.util.List;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.Collection;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void preservesWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            package com.example.foo;\n            \n            import java.util.List;\n            \n            public class A {\n            }\n        ", null, "\n            package com.example.foo;\n            \n            public class A {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void preservesWhitespaceBetweenGroupsOfImports(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null);
            String[] stringArray = new String[]{"\n            package com.yourorg.b;\n            public class B {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "\n            package com.example.foo;\n            \n            import com.yourorg.b.B;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<B> foo = new ArrayList<>();\n            }\n        ", stringArray2, "\n            package com.example.foo;\n            \n            import com.yourorg.b.B;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<B> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void doesNotAffectClassBodyFormatting(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.List", false, 2, null), "\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure AutoFormat has not been applied to the class body\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure AutoFormat has not been applied to the class body\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void removeFromWildcardAndDuplicateImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, DefaultImpls.removeImport$default(this_, "java.util.Collection", false, 2, null), "\n            package a;\n\n            import java.util.*;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", null, "\n            package a;\n\n            import java.util.Set;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void generateNewUUIDPerUnfoldedImport(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Recipe recipe2 = DefaultImpls.removeImport$default(this_, "java.util.Collection", false, 2, null).doNext((Recipe)new ChangeType("java.util.List", "java.util.Collection"));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"removeImport(\"java.util.Collection\")\n            .doNext(ChangeType(\"java.util.List\", \"java.util.Collection\"))");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            package a;\n\n            import java.util.*;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", null, "\n            package a;\n\n            import java.util.Collection;\n            import java.util.Set;\n\n            public class A {\n                Set<Integer> s;\n                Collection<Integer> l;\n            }\n        ", 0, 0, null, generateNewUUIDPerUnfoldedImport.1.INSTANCE, 232, null);
        }

        @Test
        public static void leaveAloneIfThreeOrMoreStaticsAreInUse(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n            package org.test;\n            public class Example {\n                public static final int VALUE_1 = 1;\n                public static final int VALUE_2 = 2;\n                public static final int VALUE_3 = 3;\n                public static int method1() { return 1; }\n            }\n        "};
            Recipe recipe3 = recipe2;
            recipe2 = DefaultImpls.removeImport$default(this_, "org.test.Example.VALUE_1", false, 2, null);
            this_.assertUnchanged(jp, recipe2, "\n            package org.test.a;\n            \n            import static org.test.Example.*;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int value3 = VALUE_3;\n                    int methodValue = method1();\n                }\n            }\n        ", (String[])recipe3);
        }

        @Test
        public static void unfoldStaticImportIfTwoOrLessAreUsed(@NotNull RemoveImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n            package org.test;\n            public class Example {\n                public static final int VALUE_1 = 1;\n                public static final int VALUE_2 = 2;\n                public static final int VALUE_3 = 3;\n                public static int method1() { return 1; }\n            }\n        "};
            Recipe recipe3 = recipe2;
            recipe2 = DefaultImpls.removeImport$default(this_, "org.test.Example.VALUE_1", false, 2, null);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "\n            package org.test.a;\n            \n            import static org.test.Example.*;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int methodValue = method1();\n                }\n            }\n        ", (String[])recipe3, "\n            package org.test.a;\n            \n            import static org.test.Example.method1;\n            import static org.test.Example.VALUE_2;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int methodValue = method1();\n                }\n            }\n        ", 0, 0, null, null, 480, null);
        }

        public static void assertChangedBase(@NotNull RemoveImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull RemoveImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull RemoveImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull RemoveImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull RemoveImportTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveImportTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }
    }
}

