/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\bf\u0018\u0000 +2\u00020\u0001:\u0001+J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u000f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010&\u001a\u00020\u0007H\u0017J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006,"}, d2={"Lorg/openrewrite/java/OrderImportsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/OrderImports;", "getRecipe", "()Lorg/openrewrite/java/OrderImports;", "blankLineThenEmptyBlockThenNonEmptyBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blankLinesBetweenImports", "Lorg/openrewrite/java/JavaParser$Builder;", "blankLinesNotFollowedByBlockArentAdded", "collapsesDifferentStaticImportsFromSamePackage", "detectBlockPattern", "doNotFoldImports", "doNotFoldPackageWithJavaLangClassNames", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "groupImportsIsAwareOfNestedClasses", "idempotence", "importSorting", "innerClasses", "multipleClassesWithTheSameNameButDifferentPackages", "orderAndDoNotFoldImports", "orderAndDoNotFoldStaticClasses", "orderAndDoNotFoldStaticConstants", "orderAndDoNotFoldStaticMethods", "orderImports", "packagePatternEscapesDots", "preservesDifferentStaticImportsFromSamePackage", "preservesStaticInheritanceImport", "preservesStaticMethodArguments", "preservesStaticStarImportWhenRemovingUnused", "removeUnused", "removesRedundantImports", "sortInnerAndOuterClassesInTheSamePackage", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStarMultiple", "unfoldStaticStar", "Companion", "rewrite-test"})
public interface OrderImportsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.OrderImportsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
    @NotNull
    public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";

    @NotNull
    public OrderImports getRecipe();

    @Test
    public void orderImports(@NotNull JavaParser var1);

    @Test
    public void sortInnerAndOuterClassesInTheSamePackage(@NotNull JavaParser var1);

    @Test
    public void multipleClassesWithTheSameNameButDifferentPackages(@NotNull JavaParser var1);

    @Test
    public void innerClasses(@NotNull JavaParser var1);

    @Test
    public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void unfoldStarMultiple(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat();

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Test
    public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser var1);

    @Test
    public void preservesStaticStarImportWhenRemovingUnused(@NotNull JavaParser var1);

    @Test
    public void preservesStaticInheritanceImport(@NotNull JavaParser var1);

    @Test
    public void preservesStaticMethodArguments(@NotNull JavaParser var1);

    @Test
    public void preservesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void collapsesDifferentStaticImportsFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void removesRedundantImports(@NotNull JavaParser var1);

    @Test
    public void blankLinesBetweenImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void groupImportsIsAwareOfNestedClasses(@NotNull JavaParser var1);

    @Test
    public void detectBlockPattern(@NotNull JavaParser var1);

    @Test
    public void doNotFoldImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void orderAndDoNotFoldImports(@NotNull JavaParser var1);

    @Test
    public void orderAndDoNotFoldStaticClasses(@NotNull JavaParser var1);

    @Test
    public void orderAndDoNotFoldStaticConstants(@NotNull JavaParser var1);

    @Test
    public void orderAndDoNotFoldStaticMethods(@NotNull JavaParser var1);

    @Test
    public void doNotFoldPackageWithJavaLangClassNames(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/OrderImportsTest$Companion;", "", "()V", "a", "", "b", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String a = "\n            package com.foo;\n            \n            public class A {\n                public static int one() { return 1;}\n                public static int plusOne(int n) { return n + 1; }\n                public static int three() { return 3; }\n            }\n        ";
        @NotNull
        public static final String b = "\n            package com.foo;\n            \n            public class B {\n                public static int two() { return 2; }\n                public static int multiply(int n, int n2) { return n * n2; }\n                public static int four() { return 4; }\n            }    \n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static OrderImports getRecipe(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new OrderImports(false);
        }

        @Test
        public static void orderImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.stream.Collectors.joining;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            class A {}\n        ", null, "\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.regex.Pattern;\n            \n            import static java.util.stream.Collectors.joining;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void sortInnerAndOuterClassesInTheSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Test {}\n        ", null, 10, null);
        }

        @Test
        public static void multipleClassesWithTheSameNameButDifferentPackages(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.another;\n            public class Comment {}\n        "};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import org.another.Comment;\n            import org.openrewrite.java.tree.Comment;\n            import org.openrewrite.java.tree.CoordinatesBuilder;\n            import org.openrewrite.java.tree.Expression;\n            import org.openrewrite.java.tree.Flag;\n            import org.openrewrite.java.tree.JavaType;\n            \n            class Test {}\n        ", stringArray, 2, null);
        }

        @Test
        public static void innerClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import org.openrewrite.java.tree.Comment;\n            import org.openrewrite.java.tree.CoordinatesBuilder;\n            import org.openrewrite.java.tree.Expression;\n            import org.openrewrite.java.tree.Flag;\n            import org.openrewrite.java.tree.J.Assert;\n            import org.openrewrite.java.tree.J.ClassDeclaration;\n            import org.openrewrite.java.tree.J.MethodDeclaration;\n            import org.openrewrite.java.tree.J.NewArray;\n            import org.openrewrite.java.tree.J.NewClass;\n            import org.openrewrite.java.tree.JavaType;\n            \n            class Test {}\n        ", null, "\n            import org.openrewrite.java.tree.*;\n            import org.openrewrite.java.tree.J.*;\n            \n            class Test {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.ArrayList;\n            import java.util.Objects;\n\n            import org.openrewrite.java.tree.JavaType;\n            \n            class A {}\n        ", null, "\n            import org.openrewrite.java.tree.JavaType;\n            \n            import java.util.ArrayList;\n            import java.util.Objects;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void foldIntoStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n            \n            class A {}\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void foldIntoExistingStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            \n            class A {}\n        ", null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void idempotence(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.util.*;\n            import java.util.regex.Pattern;\n\n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void unfoldStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ", null, "\n            import java.util.List;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void unfoldStarMultiple(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n                Map<Integer, Integer> map;\n            }\n        ", null, "\n            import java.util.List;\n            import java.util.Map;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n                Map<Integer, Integer> map;\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void removeUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.*;\n            \n            class A {\n            }\n        ", null, "\n            class A {\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void unfoldStaticStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new OrderImports(true), "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void packagePatternEscapesDots(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import javax.annotation.Nonnull;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void twoImportsFollowedByStar(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void springCloudFormat(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "spring", "spring", "spring", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().classCountToUseStarImport(999).nameCountToUseStarImport(999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles(\n            listOf(\n                NamedStyles(\n                    randomId(), \"spring\", \"spring\", \"spring\", emptySet(), listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(999)\n                            .nameCountToUseStarImport(999)\n                            .importPackage(\"java.*\")\n                            .blankLine()\n                            .importPackage(\"javax.*\")\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .importPackage(\"org.springframework.*\")\n                            .blankLine()\n                            .importStaticAllOthers()\n                            .build()\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ", null, 10, null);
        }

        @Test
        public static void importSorting(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            class A {}\n        ", null, "\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import r.core.Flux;\n            import reactor.core.publisher.Mono;\n            import s.core.Flux;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n            \n            class A {}\n        ", null, "\n            import static java.util.stream.Collectors.*;\n            \n            class A {}\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void preservesStaticStarImportWhenRemovingUnused(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void barB() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void preservesStaticInheritanceImport(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{"\n                package com.baz;\n                \n                public class A {\n                    public static void foo() {}\n                    public static void bar() {}\n                    public static void baz() {}\n                    public static void foo2() {}\n                    public static void bar2() {}\n                    public static void baz2() {}\n                }\n            ", "\n                package com.foo;\n                \n                import com.baz.A; \n                \n                public class B extends A { }\n            "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.B.*;\n            \n            class C {\n                void method() {\n                    foo();\n                    bar();\n                    baz();\n                    foo2();\n                    bar2();\n                    baz2();\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void preservesStaticMethodArguments(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{"\n                package com.foo;\n                \n                public class A {\n                    public static void foo(String bar) {}\n                    public static String stringify(Integer baz) { return baz.toString(); }\n                    public static Integer numberOne() { return 1; }\n                    public static Integer plusOne(Integer n) { return n + 1; }\n                    public static Integer timesTwo(Integer n) { return n * 2; }\n                    public static Integer numberTwo() { return 2; }\n                }\n            "};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            \n            class B {\n                void bar() {\n                    foo(stringify(numberOne()));\n                    timesTwo(plusOne(numberTwo()));\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void preservesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            this_.assertUnchanged(jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                }\n            }\n        ", stringArray2);
        }

        @Test
        public static void collapsesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports(true);
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)orderImports, "\n            package org.bar;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.plusOne;\n            import static com.foo.A.three;\n            import static com.foo.B.multiply;\n            import static com.foo.B.two;\n            import static com.foo.B.four;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ", stringArray2, "\n            package org.bar;\n            \n            import static com.foo.A.*;\n            import static com.foo.B.*;\n            \n            public class C {\n                void c() {\n                    multiply(plusOne(one()), two());\n                    three();\n                    four();\n                }\n            }\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void removesRedundantImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{OrderImportsTest.a, OrderImportsTest.b};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            package org.bar;\n            \n            import com.foo.B;\n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ", stringArray2, "\n            package org.bar;\n            \n            import com.foo.B;\n            \n            import static com.foo.A.one;\n            \n            public class C {\n                void c() {\n                    one();\n                    B.two();\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void blankLinesBetweenImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(9999).nameCountToUseStarImport(9999).importStaticAllOthers().blankLine().importAllOthers().blankLine().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    randomId(),\n                    \"custom\",\n                    \"custom style\",\n                    null,\n                    emptySet(),\n                    listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(9999)\n                            .nameCountToUseStarImport(9999)\n                            .importStaticAllOthers()\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .build() as Style\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, "\n            import java.util.List;\n            import static java.util.Collections.singletonList;\n            class Test {\n            }\n        ", null, "\n            import static java.util.Collections.singletonList;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n        ", 0, 0, null, null, 490, null);
        }

        @Test
        public static void groupImportsIsAwareOfNestedClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.abc;\n            public class A {}\n            public class B {}\n            public class C {}\n            public class D {}\n            public class E {}\n            public class F {}\n            public class G {}\n            public class H {\n                public class H1 {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "package org.bar;\n\nimport org.abc.A;\nimport org.abc.B;\nimport org.abc.C;\nimport org.abc.D;\nimport org.abc.E;\nimport org.abc.F;\nimport org.abc.G;\nimport org.abc.H;\nimport org.abc.H.H1;\nimport java.util.Arrays;\nimport java.util.List;\n\npublic class C {\n    void c() {\n        List<?> l = Arrays.asList(new A(), new B(), new C(), new D(), new E(), new F(), new G(), new H(), new H1());\n    }\n}", stringArray2, "package org.bar;\n\nimport org.abc.*;\nimport org.abc.H.H1;\n\nimport java.util.Arrays;\nimport java.util.List;\n\npublic class C {\n    void c() {\n        List<?> l = Arrays.asList(new A(), new B(), new C(), new D(), new E(), new F(), new G(), new H(), new H1());\n    }\n}", 0, 0, null, null, 482, null);
        }

        @Test
        public static void detectBlockPattern(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            package org.bar;\n            \n            // org.slf4j should be detected as a block pattern, and not be moved to all other imports.\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            import java.util.Arrays;\n            import java.util.List;\n            \n            public class C {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void doNotFoldImports(@NotNull OrderImportsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(Integer.MAX_VALUE).nameCountToUseStarImport(Integer.MAX_VALUE).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importStaticAllOthers().build();
            if (importLayoutStyle == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.style.Style");
            }
            JavaParser javaParser = jp.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "custom", "custom style", null, SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(\n            listOf(\n                NamedStyles(\n                    randomId(),\n                    \"custom\",\n                    \"custom style\",\n                    null,\n                    emptySet(),\n                    listOf(\n                        ImportLayoutStyle.builder()\n                            .classCountToUseStarImport(2147483647)\n                            .nameCountToUseStarImport(2147483647)\n                            .importPackage(\"java.*\")\n                            .blankLine()\n                            .importPackage(\"javax.*\")\n                            .blankLine()\n                            .importAllOthers()\n                            .blankLine()\n                            .importStaticAllOthers()\n                            .build() as Style\n                    )\n                )\n            )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, "\n            package org.bar;\n            \n            import java.util.ArrayList;\n            import java.util.Collections;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Set;\n            \n            import javax.persistence.Entity;\n            import javax.persistence.FetchType;\n            import javax.persistence.JoinColumn;\n            import javax.persistence.JoinTable;\n            import javax.persistence.ManyToMany;\n            import javax.persistence.Table;\n            \n            public class C {\n            }\n        ", null, 10, null);
        }

        @Test
        public static void orderAndDoNotFoldImports(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            JavaType.Class clazz;
            String it;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n\nimport org.foo.FooB;\nimport org.bar.BarB;\nimport org.foo.FooD;\nimport org.foo.FooC;\nimport org.bar.BarC;\nimport org.foo.FooA;\nimport org.foo.FooE;\nimport org.bar.BarD;\nimport org.bar.BarA;\nimport org.bar.BarE;\n\npublic class Test {\n    FooA fooA = new FooA();\n    FooB fooB = new FooB();\n    FooC fooC = new FooC();\n    FooD fooD = new FooD();\n    FooE fooE = new FooE();\n    \n    BarA barA = new BarA();\n    BarB barB = new BarB();\n    BarC barC = new BarC();\n    BarD barD = new BarD();\n    BarE barE = new BarE();\n}", "package org.foo; public class Shared {}", "package org.foo; public class FooA {}", "package org.foo; public class FooB {}", "package org.foo; public class FooC {}", "package org.foo; public class FooD {}", "package org.foo; public class FooE {}", "package org.bar; public class Shared {}", "package org.bar; public class BarA {}", "package org.bar; public class BarB {}", "package org.bar; public class BarC {}", "package org.bar; public class BarD {}", "package org.bar; public class BarE {}"};
            String[] inputs = stringArray;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            String[] stringArray2 = new String[]{"org.foo.Shared", "org.foo.FooA", "org.foo.FooB", "org.foo.FooC", "org.foo.FooD", "org.foo.FooE", "org.bar.Shared", "org.bar.BarA", "org.bar.BarB", "org.bar.BarC", "org.bar.BarD", "org.bar.BarE"};
            String[] classNames = stringArray2;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            String[] $this$forEach$iv = classNames;
            boolean $i$f$forEach = false;
            String[] stringArray3 = $this$forEach$iv;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                it = element$iv = stringArray3[i];
                boolean bl2 = false;
                clazz = JavaType.Class.build((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(it)");
                fqns.add(clazz);
            }
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl3 = false;
            List markedFiles = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv2 = sourceFiles;
            boolean $i$f$forEach2 = false;
            for (String element$iv : $this$forEach$iv2) {
                it = (J.CompilationUnit)element$iv;
                boolean bl4 = false;
                clazz = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(clazz);
            }
            TreeVisitor recipe2 = new OrderImports(false).getVisitor();
            Tree result = recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 10 ? 1 : 0) != 0).isTrue();
        }

        @Test
        public static void orderAndDoNotFoldStaticClasses(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            JavaType.Class clazz;
            String it;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n\nimport static org.faz.Faz.FooA;\nimport static org.faz.Faz.FooB;\nimport static org.faz.Faz.FooC;\nimport static org.baz.Baz.BarA;\nimport static org.baz.Baz.BarB;\nimport static org.baz.Baz.BarC;\n\npublic class Test {\n    FooA fooA;\n    FooB fooB;\n    FooC fooC;\n    BarA barA;\n    BarB barB;\n    BarC barC;\n}", "package org.faz;\npublic class Faz {\n    public static class Shared {}\n    public static class FooA {}\n    public static class FooB {}\n    public static class FooC {}\n}", "package org.baz;\npublic class Baz {\n    public static class Shared {}\n    public static class BarA {}\n    public static class BarB {}\n    public static class BarC {}\n}"};
            String[] inputs = stringArray;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            String[] stringArray2 = new String[]{"org.faz.Faz$Shared", "org.faz.Faz$FooA", "org.faz.Faz$FooB", "org.faz.Faz$FooC", "org.baz.Baz$Shared", "org.baz.Baz$BarA", "org.baz.Baz$BarB", "org.baz.Baz$BarC"};
            String[] classNames = stringArray2;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            String[] $this$forEach$iv = classNames;
            boolean $i$f$forEach = false;
            String[] stringArray3 = $this$forEach$iv;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                it = element$iv = stringArray3[i];
                boolean bl2 = false;
                clazz = JavaType.Class.build((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(it)");
                fqns.add(clazz);
            }
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl3 = false;
            List markedFiles = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv2 = sourceFiles;
            boolean $i$f$forEach2 = false;
            for (String element$iv : $this$forEach$iv2) {
                it = (J.CompilationUnit)element$iv;
                boolean bl4 = false;
                clazz = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(clazz);
            }
            TreeVisitor recipe2 = new OrderImports(false).getVisitor();
            Tree result = recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 6 ? 1 : 0) != 0).isTrue();
        }

        @Test
        public static void orderAndDoNotFoldStaticConstants(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            String it;
            String element$iv2;
            int n;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n\nimport static org.fiz.Fiz.FOO_A;\nimport static org.fiz.Fiz.FOO_B;\nimport static org.fiz.Fiz.FOO_C;\nimport static org.biz.Biz.BAR_A;\nimport static org.biz.Biz.BAR_B;\nimport static org.biz.Biz.BAR_C;\n\npublic class Test {\n    int fooA = FOO_A;\n    int fooB = FOO_B;\n    int fooC = FOO_C;\n    int barA = BAR_A;\n    int barB = BAR_B;\n    int barC = BAR_C;\n}", "package org.fiz;\npublic class Fiz {\n    public static int SHARED = 1;\n    public static int FOO_A = 2;\n    public static int FOO_B = 3;\n    public static int FOO_C = 4;\n}", "package org.biz;\npublic class Biz {\n    public static int SHARED = 1;\n    public static int BAR_A = 2;\n    public static int BAR_B = 3;\n    public static int BAR_C = 4;\n}"};
            String[] inputs = stringArray;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            String[] stringArray2 = new String[]{"org.fiz.Fiz", "org.biz.Biz"};
            String[] classNames = stringArray2;
            String[] stringArray3 = new String[]{"SHARED", "FOO_A", "FOO_B", "FOO_C", "SHARED", "BAR_A", "BAR_B", "BAR_C"};
            String[] variableNames = stringArray3;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            Object[] objectArray = new Flag[]{Flag.Public, Flag.Static};
            Set flags = SetsKt.setOf((Object[])objectArray);
            boolean bl2 = false;
            List variables = new ArrayList();
            String[] $this$forEach$iv = variableNames;
            boolean $i$f$forEach = false;
            String[] stringArray4 = $this$forEach$iv;
            int n2 = stringArray4.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = stringArray4[n];
                boolean bl3 = false;
                JavaType.Variable variable = JavaType.Variable.build((String)it, null, (JavaType)JavaType.buildType((String)"int"), (List)CollectionsKt.emptyList(), (long)Flag.flagsToBitMap((Set)flags));
                Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"build(it, null, JavaType.buildType(\"int\"), emptyList(), Flag.flagsToBitMap(flags))");
                variables.add(variable);
            }
            $this$forEach$iv = classNames;
            $i$f$forEach = false;
            stringArray4 = $this$forEach$iv;
            n2 = stringArray4.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = stringArray4[n];
                boolean bl4 = false;
                boolean bl5 = false;
                bl5 = false;
                JavaType.Class clazz = JavaType.Class.build((Set)flags, (String)it, (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)variables, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), null, null, null);
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(flags, it, JavaType.Class.Kind.Class, variables, listOf(), listOf(), null, null, null)");
                fqns.add(clazz);
            }
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl6 = false;
            List markedFiles = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv2 = sourceFiles;
            boolean $i$f$forEach2 = false;
            for (String element$iv2 : $this$forEach$iv2) {
                it = (J.CompilationUnit)element$iv2;
                boolean bl7 = false;
                J.CompilationUnit compilationUnit = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(compilationUnit);
            }
            TreeVisitor recipe2 = new OrderImports(false).getVisitor();
            Tree result = recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 6 ? 1 : 0) != 0).isTrue();
        }

        @Test
        public static void orderAndDoNotFoldStaticMethods(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            JavaType.Class methodNamesBar;
            JavaType.Class methodNamesFoo;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"org.fuz.Fuz", "org.buz.Buz"};
            String[] classNames = stringArray;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            Object[] objectArray = new Flag[]{Flag.Public, Flag.Static};
            Set flags = SetsKt.setOf((Object[])objectArray);
            boolean bl2 = false;
            JavaType.Method.Signature methodSignature = new JavaType.Method.Signature(JavaType.buildType((String)"boolean"), CollectionsKt.emptyList());
            boolean bl3 = false;
            List variables = new ArrayList();
            boolean bl4 = false;
            List methodsFoo = new ArrayList();
            JavaType.Class clazz = new JavaType.Class[]{"assertShared", "assertA", "assertB", "assertC"};
            JavaType.Class $this$forEach$iv = methodNamesFoo = clazz;
            boolean $i$f$forEach = false;
            JavaType.Class clazz2 = $this$forEach$iv;
            int n = ((String[])clazz2).length;
            for (int i = 0; i < n; ++i) {
                String element$iv22;
                String it = element$iv22 = clazz2[i];
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                bl6 = false;
                JavaType.Method method2 = JavaType.Method.build((Set)flags, (JavaType.FullyQualified)((JavaType.FullyQualified)JavaType.Class.build((String)"declClass")), (String)it, null, (JavaType.Method.Signature)methodSignature, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"build(flags, JavaType.Class.build(\"declClass\"), it, null, methodSignature, listOf(), listOf(), listOf())");
                methodsFoo.add(method2);
            }
            $i$f$forEach = false;
            $i$f$forEach = false;
            $this$forEach$iv = JavaType.Class.build((long)Flag.flagsToBitMap((Set)flags), (String)classNames[0], (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)variables, (List)CollectionsKt.emptyList(), (List)methodsFoo, null, null, (List)CollectionsKt.emptyList(), null, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"build(Flag.flagsToBitMap(flags), classNames[0], JavaType.Class.Kind.Class, variables,\n            listOf(), methodsFoo, null, null, listOf(), null, false)");
            fqns.add($this$forEach$iv);
            $i$f$forEach = false;
            List methodsBar = new ArrayList();
            clazz2 = new JavaType.Class[]{"assertShared", "assertThatA", "assertThatB", "assertThatC"};
            JavaType.Class $this$forEach$iv2 = methodNamesBar = clazz2;
            boolean $i$f$forEach2 = false;
            JavaType.Class clazz3 = $this$forEach$iv2;
            int element$iv22 = ((String[])clazz3).length;
            for (int it = 0; it < element$iv22; ++it) {
                String element$iv;
                String it2 = element$iv = clazz3[it];
                boolean bl7 = false;
                boolean bl8 = false;
                bl8 = false;
                bl8 = false;
                JavaType.Method method3 = JavaType.Method.build((Set)flags, (JavaType.FullyQualified)((JavaType.FullyQualified)JavaType.Class.build((String)"declClass")), (String)it2, null, (JavaType.Method.Signature)methodSignature, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"build(flags, JavaType.Class.build(\"declClass\"), it, null, methodSignature, listOf(), listOf(), listOf())");
                methodsBar.add(method3);
            }
            $i$f$forEach2 = false;
            $i$f$forEach2 = false;
            $this$forEach$iv2 = JavaType.Class.build((long)Flag.flagsToBitMap((Set)flags), (String)classNames[1], (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)variables, (List)CollectionsKt.emptyList(), (List)methodsBar, null, null, (List)CollectionsKt.emptyList(), null, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"build(Flag.flagsToBitMap(flags), classNames[1], JavaType.Class.Kind.Class, variables,\n            listOf(), methodsBar, null, null, listOf(), null, false)");
            fqns.add($this$forEach$iv2);
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl9 = false;
            List markedFiles = new ArrayList();
            String[] element$iv22 = new String[]{"package org.test;\n\nimport static org.fuz.Fuz.assertA;\nimport static org.fuz.Fuz.assertB;\nimport static org.fuz.Fuz.assertC;\nimport static org.buz.Buz.assertThatA;\nimport static org.buz.Buz.assertThatB;\nimport static org.buz.Buz.assertThatC;\n\npublic class Test {\n    boolean fooA = assertA();\n    boolean fooB = assertB();\n    boolean fooC = assertC();\n    boolean barA = assertThatA();\n    boolean barB = assertThatB();\n    boolean barC = assertThatC();\n}", "package org.fuz;\npublic class Fuz {\n    public static boolean assertShared() { return true; }\n    public static boolean assertA() { return true; }\n    public static boolean assertB() { return true; }\n    public static boolean assertC() { return true; }\n}", "package org.buz;\npublic class Buz {\n    public static boolean assertShared() { return true; }\n    public static boolean assertThatA() { return true; }\n    public static boolean assertThatB() { return true; }\n    public static boolean assertThatC() { return true; }\n}"};
            String[] inputs = element$iv22;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv3 = sourceFiles;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                J.CompilationUnit it = (J.CompilationUnit)element$iv;
                boolean bl10 = false;
                J.CompilationUnit compilationUnit = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(compilationUnit);
            }
            TreeVisitor recipe2 = new OrderImports(false).getVisitor();
            Tree result = recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 6 ? 1 : 0) != 0).isTrue();
        }

        @Test
        public static void doNotFoldPackageWithJavaLangClassNames(@NotNull OrderImportsTest this_, @NotNull JavaParser jp) {
            JavaType.Class clazz;
            String it;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n\nimport org.foo.Process;\nimport org.foo.FooD;\nimport org.foo.FooC;\nimport org.foo.Thread;\nimport org.foo.FooE;\n\npublic class Test {\n    Thread thread = new Thread();\n    Process process = new Process();\n    FooC fooC = new FooC();\n    FooD fooD = new FooD();\n    FooE fooE = new FooE();\n}", "package org.foo; public class Thread {}", "package org.foo; public class Process {}", "package org.foo; public class FooC {}", "package org.foo; public class FooD {}", "package org.foo; public class FooE {}"};
            String[] inputs = stringArray;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            String[] stringArray2 = new String[]{"java.lang.Thread", "org.foo.Thread", "org.foo.Process", "org.foo.FooC", "org.foo.FooD", "org.foo.FooE"};
            String[] classNames = stringArray2;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            String[] $this$forEach$iv = classNames;
            boolean $i$f$forEach = false;
            String[] stringArray3 = $this$forEach$iv;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                it = element$iv = stringArray3[i];
                boolean bl2 = false;
                clazz = JavaType.Class.build((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(it)");
                fqns.add(clazz);
            }
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl3 = false;
            List markedFiles = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv2 = sourceFiles;
            boolean $i$f$forEach2 = false;
            for (String element$iv : $this$forEach$iv2) {
                it = (J.CompilationUnit)element$iv;
                boolean bl4 = false;
                clazz = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(clazz);
            }
            TreeVisitor recipe2 = new OrderImports(false).getVisitor();
            Tree result = recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 5 ? 1 : 0) != 0).isTrue();
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull OrderImportsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull OrderImportsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull OrderImportsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull OrderImportsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull OrderImportsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }
    }
}

