/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.MissingOverrideAnnotation;
import org.openrewrite.java.tree.J;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\bf\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lorg/openrewrite/java/cleanup/MissingOverrideAnnotationTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "when a method already has an @Override annotation", "", "when a method implements an interface", "when a method overrides from a parent", "when a method overrides from a parent and a method implements an interface", "when a method overrides multiple layers of parents", "when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class", "when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class", "when ignoreObjectMethods is false and a method overrides from the base Object class", "when ignoreObjectMethods is true and a method overrides from the base Object class", "when methods are implemented from multiple interfaces", "when methods are implemented from multiple layers of interfaces", "when the method is static", "when the parent is abstract and the method to override is abstract", "when the parent is abstract and the method to override is not abstract", "Companion", "rewrite-test"})
public interface MissingOverrideAnnotationTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.cleanup.MissingOverrideAnnotationTest$Companion.$$INSTANCE;

    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void when a method overrides from a parent();

    @Test
    public void when a method overrides multiple layers of parents();

    @Test
    public void when a method implements an interface();

    @Test
    public void when methods are implemented from multiple interfaces();

    @Test
    public void when methods are implemented from multiple layers of interfaces();

    @Test
    public void when a method overrides from a parent and a method implements an interface();

    @Test
    public void when the method is static();

    @Test
    public void when the parent is abstract and the method to override is abstract();

    @Test
    public void when the parent is abstract and the method to override is not abstract();

    @Test
    public void when a method already has an @Override annotation();

    @Test
    @Disabled(value="Override annotation is not being attributed in Java 8, causing infinite cycles when adding annotations to anonymous classes. Only appears in Java 8.")
    public void when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class();

    @Test
    @Disabled(value="Override annotation is not being attributed in Java 8, causing infinite cycles when adding annotations to anonymous classes. Only appears in Java 8.")
    public void when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class();

    @Test
    public void when ignoreObjectMethods is true and a method overrides from the base Object class();

    @Test
    public void when ignoreObjectMethods is false and a method overrides from the base Object class();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/cleanup/MissingOverrideAnnotationTest$Companion;", "", "()V", "supportingParents", "", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Language(value="java")
        @NotNull
        private static final String supportingParents = "\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new MissingOverrideAnnotation(null, null);
        }

        @Test
        public static void when a method overrides from a parent(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test extends TestParentParent {\n                public void testParentParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            class Test extends TestParentParent {\n                @Override\n                public void testParentParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when a method overrides multiple layers of parents(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test extends TestParent {\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            class Test extends TestParent {\n                @Override\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when a method implements an interface(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test implements TestInterface {\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", stringArray2, "\n            class Test implements TestInterface {\n                @Override\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when methods are implemented from multiple interfaces(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test implements TestInterface, TestInterface0 {\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface0() {\n                }\n            }\n        ", stringArray2, "\n            class Test implements TestInterface, TestInterface0 {\n                @Override\n                public void testInterface() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface0() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when methods are implemented from multiple layers of interfaces(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test implements TestInterfaceExtension {\n                public void testInterfaceExtension() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface0() {\n                }\n            }\n        ", stringArray2, "\n            class Test implements TestInterfaceExtension {\n                @Override\n                public void testInterfaceExtension() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface0() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when a method overrides from a parent and a method implements an interface(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test extends TestParent implements TestInterface {\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n\n                public void testInterface() {\n                }\n            }\n        ", stringArray2, "\n            class Test extends TestParent implements TestInterface {\n                @Override\n                public void testParent() {\n                }\n\n                public void localMethod() {\n                }\n\n                @Override\n                public void testInterface() {\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when the method is static(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"import java.util.Collection;\nimport java.util.Collections;\n\nclass TestBase {\n    protected static Collection<Object[]> parameters() {\n        return Collections.emptyList();\n    }\n}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            import java.util.Collection;\n            import java.util.Collections;\n\n            class Test extends TestBase {\n                protected static Collection<Object[]> parameters() {\n                    return Collections.emptyList();\n                }\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        public static void when the parent is abstract and the method to override is abstract(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test extends AbstractTestParent {\n                public boolean isAbstractBoolean() {\n                    return false;\n                }\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        public static void when the parent is abstract and the method to override is not abstract(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            class Test extends AbstractTestParent {\n                public boolean isAbstractBoolean() {\n                    return false;\n                }\n\n                public boolean isBoolean() {\n                    return true;\n                }\n            }\n        ", stringArray2, "\n            class Test extends AbstractTestParent {\n                public boolean isAbstractBoolean() {\n                    return false;\n                }\n\n                @Override\n                public boolean isBoolean() {\n                    return true;\n                }\n            }\n        ", 0, 0, null, null, 483, null);
        }

        @Test
        public static void when a method already has an @Override annotation(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, null, "\n            class Test extends TestParent {\n                @Override\n                public void testParent() {\n                }\n            }\n        ", stringArray2, 3, null);
        }

        @Test
        @Disabled(value="Override annotation is not being attributed in Java 8, causing infinite cycles when adding annotations to anonymous classes. Only appears in Java 8.")
        public static void when ignoreAnonymousClassMethods is true and a method overrides within an anonymous class(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            MissingOverrideAnnotation missingOverrideAnnotation = new MissingOverrideAnnotation(null, Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, (Recipe)missingOverrideAnnotation, "\n            class Test {\n                public void method() {\n                    TestParent t = new TestParent() {\n                        public void testParent() {\n                        }\n                    };\n                }\n            }\n        ", stringArray2, 1, null);
        }

        @Test
        @Disabled(value="Override annotation is not being attributed in Java 8, causing infinite cycles when adding annotations to anonymous classes. Only appears in Java 8.")
        public static void when ignoreAnonymousClassMethods is false and a method overrides within an anonymous class(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            MissingOverrideAnnotation missingOverrideAnnotation = new MissingOverrideAnnotation(null, Boolean.valueOf(false));
            String[] stringArray = new String[]{"\n            interface TestInterface {\n                void testInterface();\n            }\n\n            interface TestInterface0 {\n                void testInterface0();\n            }\n\n            interface TestInterfaceExtension extends TestInterface0 {\n                void testInterfaceExtension();\n            }\n\n            class TestParentParent {\n                public void testParentParent() {\n                }\n            }\n\n            class TestParent extends TestParentParent {\n                public void testParent() {\n                }\n            }\n\n            abstract class AbstractTestParent {\n                abstract boolean isAbstractBoolean();\n\n                boolean isBoolean() {\n                    return true;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)missingOverrideAnnotation, "\n            class Test {\n                public void method() {\n                    TestParent t = new TestParent() {\n                        public void testParent() {\n                        }\n                    };\n                }\n            }\n        ", stringArray2, "\n            class Test {\n                public void method() {\n                    TestParent t = new TestParent() {\n                        @Override\n                        public void testParent() {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, null, 481, null);
        }

        @Test
        public static void when ignoreObjectMethods is true and a method overrides from the base Object class(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, null, (Recipe)new MissingOverrideAnnotation(Boolean.valueOf(true), null), "\n            class Test {\n                public String toString() {\n                    return super.toString();\n                }\n            }\n        ", null, 9, null);
        }

        @Test
        public static void when ignoreObjectMethods is false and a method overrides from the base Object class(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new MissingOverrideAnnotation(Boolean.valueOf(false), null), "\n            class Test {\n                public String toString() {\n                    return super.toString();\n                }\n            }\n        ", null, "\n            class Test {\n                @Override\n                public String toString() {\n                    return super.toString();\n                }\n            }\n        ", 0, 0, null, null, 489, null);
        }

        public static void assertChangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull MissingOverrideAnnotationTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull MissingOverrideAnnotationTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull MissingOverrideAnnotationTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull MissingOverrideAnnotationTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull MissingOverrideAnnotationTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }
    }
}

