/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTreeTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/tree/VariableDeclarationsTest;", "Lorg/openrewrite/java/JavaTreeTest;", "arrayVariables", "", "jp", "Lorg/openrewrite/java/JavaParser;", "fieldDefinition", "fieldWithNoInitializer", "finalVar", "hasModifier", "localVariableDefinition", "modifierOrdering", "multipleDeclaration", "multipleDeclarationOneAssignment", "rewrite-test"})
public interface VariableDeclarationsTest
extends JavaTreeTest {
    @Test
    public void fieldDefinition(@NotNull JavaParser var1);

    @Test
    public void finalVar(@NotNull JavaParser var1);

    @Test
    public void localVariableDefinition(@NotNull JavaParser var1);

    @Test
    public void fieldWithNoInitializer(@NotNull JavaParser var1);

    @Test
    public void arrayVariables(@NotNull JavaParser var1);

    @Test
    public void multipleDeclarationOneAssignment(@NotNull JavaParser var1);

    @Test
    public void multipleDeclaration(@NotNull JavaParser var1);

    @Test
    public void modifierOrdering(@NotNull JavaParser var1);

    @Test
    public void hasModifier(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void fieldDefinition(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public String a = \"\";\n        ", new String[0]);
        }

        @Test
        public static void finalVar(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "final var a = \"\";", new String[0]);
        }

        @Test
        public static void localVariableDefinition(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            String a = \"\";\n        ", new String[0]);
        }

        @Test
        public static void fieldWithNoInitializer(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public String a;\n        ", new String[0]);
        }

        @Test
        public static void arrayVariables(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n           int n [ ];\n           String s [ ] [ ];\n           int [ ] n2;\n           String [ ] [ ] s2;\n        ", new String[0]);
        }

        @Test
        public static void multipleDeclarationOneAssignment(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            int i , j = 0;\n        ", new String[0]);
        }

        @Test
        public static void multipleDeclaration(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Block, "\n            Integer[] m = { 0 }, n[] = { { 0 } };\n        ", new String[0]);
        }

        @Test
        public static void modifierOrdering(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            this_.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.Class, "\n            public /* static */ final static Integer n = 0;\n        ", new String[0]);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void hasModifier(@NotNull VariableDeclarationsTest this_, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            class A {\n                protected static final Integer n = 0;\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            List list = ((J.ClassDeclaration)a.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            J.VariableDeclarations inv = (J.VariableDeclarations)CollectionsKt.first((List)((List)destination$iv$iv));
            Assertions.assertThat((List)inv.getModifiers()).hasSize(3);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Protected));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Static));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)inv.hasModifier(J.Modifier.Type.Final));
        }
    }
}

