/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/MethodInvocationTest;", "", "genericMethodInvocation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "methodInvocation", "methodThatDoesNotExist", "staticMethodInvocation", "allInvs", "", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "rewrite-test"})
public interface MethodInvocationTest {
    @Test
    public void methodInvocation(@NotNull JavaParser var1);

    @Test
    public void genericMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void staticMethodInvocation(@NotNull JavaParser var1);

    @Test
    public void methodThatDoesNotExist(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        private static List<J.MethodInvocation> allInvs(MethodInvocationTest this_, J.CompilationUnit receiver) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            List list = ((J.ClassDeclaration)receiver.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classes[0].body\n        .statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Expression expression = ((J.VariableDeclarations.NamedVariable)it.getVariables().get(0)).getInitializer();
                if (expression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
                }
                J.MethodInvocation methodInvocation2 = (J.MethodInvocation)expression;
                collection.add(methodInvocation2);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            public class A {\n                Integer m = foo ( 0, 1, 2 );\n    \n                public Integer foo(Integer n, Integer... ns) { return n; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            Object object2 = object = DefaultImpls.allInvs(this_, a);
            boolean bl = false;
            J.MethodInvocation inv = (J.MethodInvocation)object2.get(0);
            Assertions.assertEquals((Object)"foo", (Object)inv.getName().printTrimmed());
            object2 = TestKt.asFullyQualified(inv.getReturnType());
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(object2 == null ? null : object2.getFullyQualifiedName()));
            object2 = new JavaType.Primitive[]{JavaType.Primitive.Int, JavaType.Primitive.Int, JavaType.Primitive.Int};
            List list = CollectionsKt.listOf((Object[])object2);
            object2 = inv.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inv.arguments");
            object2 = (Iterable)object2;
            List list2 = list;
            boolean $i$f$filterIsInstance = false;
            JavaType.FullyQualified fullyQualified = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.Literal)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<JavaType.Primitive> collection = (List)destination$iv$iv;
            $this$filterIsInstance$iv = collection;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Literal literal = (J.Literal)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                JavaType.Primitive primitive = it.getType();
                collection.add(primitive);
            }
            collection = (List)destination$iv$iv;
            Assertions.assertEquals((Object)list2, (Object)collection);
            JavaType.Method method = inv.getType();
            Intrinsics.checkNotNull((Object)method);
            List effectParams = method.getResolvedSignature().getParamTypes();
            JavaType.FullyQualified fullyQualified2 = TestKt.asFullyQualified((JavaType)effectParams.get(0));
            Assertions.assertEquals((Object)"java.lang.Integer", (Object)(fullyQualified2 == null ? null : fullyQualified2.getFullyQualifiedName()));
            Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)effectParams.get(1), "java.lang.Integer"));
            JavaType.Method method2 = inv.getType();
            Intrinsics.checkNotNull((Object)method2);
            JavaType.Method.Signature signature = method2.getResolvedSignature();
            JavaType.Method method3 = inv.getType();
            Intrinsics.checkNotNull((Object)method3);
            Assertions.assertEquals((Object)signature, (Object)method3.getGenericSignature());
            fullyQualified2 = inv.getType();
            Assertions.assertEquals((Object)"A", fullyQualified2 == null ? null : ((fullyQualified = fullyQualified2.getDeclaringType()) == null ? null : fullyQualified.getFullyQualifiedName()));
            Assertions.assertEquals((Object)"foo ( 0, 1, 2 )", (Object)inv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void genericMethodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            public class A {\n                Integer o = generic ( 0, 1, 2 );\n                Integer p = this . < Integer > generic ( 0, 1, 2 );\n    \n                public <T> T generic(T n, T... ns) { return n; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            Object object2 = object = DefaultImpls.allInvs(this_, a);
            boolean bl = false;
            J.MethodInvocation genericInv = (J.MethodInvocation)object2.get(0);
            Object[] objectArray = object;
            boolean bl2 = false;
            J.MethodInvocation explicitGenericInv = (J.MethodInvocation)objectArray.get(1);
            objectArray = new J.MethodInvocation[]{genericInv, explicitGenericInv};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                J.MethodInvocation test = (J.MethodInvocation)element$iv;
                boolean bl3 = false;
                Object object3 = TestKt.asFullyQualified(test.getReturnType());
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)(object3 == null ? null : object3.getFullyQualifiedName()));
                object3 = new JavaType.Primitive[]{JavaType.Primitive.Int, JavaType.Primitive.Int, JavaType.Primitive.Int};
                List list = CollectionsKt.listOf((Object[])object3);
                object3 = test.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"test.arguments");
                object3 = (Iterable)object3;
                List list2 = list;
                boolean $i$f$filterIsInstance = false;
                JavaType.GenericTypeVariable genericTypeVariable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof J.Literal)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<JavaType.Primitive> collection = (List)destination$iv$iv;
                $this$filterIsInstance$iv = collection;
                boolean $i$f$map22 = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    J.Literal literal = (J.Literal)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    JavaType.Primitive primitive = it.getType();
                    collection.add(primitive);
                }
                collection = (List)destination$iv$iv;
                Assertions.assertEquals((Object)list2, (Object)collection);
                JavaType.Method method = test.getType();
                Intrinsics.checkNotNull((Object)method);
                List effectiveParams = method.getResolvedSignature().getParamTypes();
                JavaType.FullyQualified $i$f$map22 = TestKt.asFullyQualified((JavaType)effectiveParams.get(0));
                Assertions.assertEquals((Object)"java.lang.Integer", (Object)($i$f$map22 == null ? null : $i$f$map22.getFullyQualifiedName()));
                Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)effectiveParams.get(1), "java.lang.Integer"));
                JavaType.Method method2 = test.getType();
                Intrinsics.checkNotNull((Object)method2);
                JavaType.Method.Signature methType = method2.getGenericSignature();
                genericTypeVariable = TestKt.asGeneric(methType.getReturnType());
                Assertions.assertEquals((Object)"T", (Object)(genericTypeVariable == null ? null : genericTypeVariable.getFullyQualifiedName()));
                genericTypeVariable = TestKt.asGeneric((JavaType)methType.getParamTypes().get(0));
                Assertions.assertEquals((Object)"T", (Object)(genericTypeVariable == null ? null : genericTypeVariable.getFullyQualifiedName()));
                Assertions.assertTrue((boolean)TestKt.hasElementType((JavaType)methType.getParamTypes().get(1), "T"));
            }
            Assertions.assertEquals((Object)"this . < Integer > generic ( 0, 1, 2 )", (Object)explicitGenericInv.printTrimmed());
        }

        @Test
        public static void staticMethodInvocation(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            JavaType.FullyQualified fullyQualified;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n            public class A {\n                Integer n = staticFoo ( 0 );\n                Integer o = staticFoo ( );\n    \n                public static int staticFoo(int... args) { return 0; }\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            Object object2 = object = DefaultImpls.allInvs(this_, a);
            boolean bl = false;
            J.MethodInvocation staticInv = (J.MethodInvocation)object2.get(0);
            Object object3 = object;
            boolean bl2 = false;
            J.MethodInvocation parameterlessStaticInv = (J.MethodInvocation)object3.get(1);
            Assertions.assertEquals((Object)"staticFoo", (Object)staticInv.getName().printTrimmed());
            object3 = staticInv.getType();
            Assertions.assertEquals((Object)"A", object3 == null ? null : ((fullyQualified = object3.getDeclaringType()) == null ? null : fullyQualified.getFullyQualifiedName()));
            Assertions.assertEquals((Object)"staticFoo ( 0 )", (Object)staticInv.printTrimmed());
            Assertions.assertEquals((Object)"staticFoo ( )", (Object)parameterlessStaticInv.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void methodThatDoesNotExist(@NotNull MethodInvocationTest this_, @NotNull JavaParser jp) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public class A {\n                Integer n = doesNotExist();\n            }\n        "};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(stringArray).get(0);
            List list = ((J.ClassDeclaration)a.getClasses().get(0)).getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].body.statements");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof J.VariableDeclarations)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Expression expression = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)CollectionsKt.first((List)((List)destination$iv$iv))).getVariables().get(0)).getInitializer();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            J.MethodInvocation inv = (J.MethodInvocation)expression;
            Assertions.assertNull((Object)((expression = inv.getType()) == null ? null : expression.getDeclaringType()));
            Assertions.assertNull((Object)inv.getType());
            Assertions.assertNull((Object)inv.getType());
        }
    }
}

