/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.format.EmptyNewlineAtEndOfFile;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/format/EmptyNewlineAtEndOfFileTest;", "", "comments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "multipleLinesToOne", "noComments", "rewrite-test"})
public interface EmptyNewlineAtEndOfFileTest {
    @Test
    public void noComments(@NotNull JavaParser var1);

    @Test
    public void comments(@NotNull JavaParser var1);

    @Test
    public void multipleLinesToOne(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void noComments(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.parse(stringArray)).get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.print()).isEqualTo("class Test {}\n");
        }

        @Test
        public static void comments(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}\n/*comment*/"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.parse(stringArray)).get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.print()).isEqualTo("class Test {}\n/*comment*/\n");
        }

        @Test
        public static void multipleLinesToOne(@NotNull EmptyNewlineAtEndOfFileTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {}\n\n"};
            SourceFile sourceFile = ((Result)new EmptyNewlineAtEndOfFile().run(jp.parse(stringArray)).get(0)).getAfter();
            Intrinsics.checkNotNull((Object)sourceFile);
            Assertions.assertThat((String)sourceFile.print()).isEqualTo("class Test {}\n");
        }
    }
}

